package com.bizunited.platform.mars.policy.process.rule.waiter;

import java.util.Set;

import org.springframework.stereotype.Component;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeTimerNode;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.rule.starter.StarterRuleable;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 阻塞计时器规则节点
 * @author yinwenjie
 */
@Component("_timeRuleable")
public class TimerRuleable<T extends RuntimeTimerNode> implements StarterRuleable<T> {
  public int getType() {
    return RuntimeNodeType.TIMER.getValue();
  }
  @Override
  public void doProcess(RuntimeTimerNode currentNode, RuleRuntimeContext context,RuntimeProcessorLinked runtimeProcessorLinked, ProcessorChain processChain) {
    /*
     * 阻塞计时器节点没有任何业务逻辑过程需要执行
     */
  }
  
  @Override
  public Set<RuntimeProcessorLinked> createProcessorLinkeds(RuntimeTimerNode currentNode, RuleRuntimeContext context) {
    /*
     * 当阻塞过程完成，接收到继续处理的通知后，
     * 计时器组件只需要将后续的连接线做成一个新的执行链路即可向后继续执行
     * */
    // 
    
    return null;
  }
}
