package com.bizunited.platform.mars.policy.process.runtime.contexts;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang3.Validate;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.runtime.RuleRunTimeStatus;

/**
 * 规则实例运行时上下文信息，不允许继承、修改，只允许在一个工作线程的范围进行使用
 * @author yinwenjie
 */
public final class RuleRuntimeContext {
  // TODO 最后确认是需要弱引用，以便在本规则实例没有任何处理步骤的情况下，进行规则上下文的回收
  // TODO Futer也是需要的，以便保证调用者能随时取到上下文中的结果和异常信息——即使这个规则实例已经运行完成
  // 当前正在处理（包括延迟等待的）的规则实例上下文映射信息，存储在这里
  private static Map<String , WeakReference<RuleRuntimeContext>> ruleRuntimeContexts = new HashMap<>();
  /**
   * 当前可能处于阻塞状态的，请求当次规则实例执行的调用请求线程
   */
  private Thread requestThread;
  /**
   * 当前规则的运行状态
   */
  private RuleRunTimeStatus status;
  /**
   * 这个map结构存储当前上下文中的各种参数信息
   */
  private Map<String, Object> params = new HashMap<>();
  /**
   * 规则正常运行结束后的返回结果在这里存储
   */
  private Object _return;
  /**
   * 如果当前规则运行过程已经出现异常，则异常信息在这里
   */
  private Throwable currentThrowable;
  /**
   * 记录当前抛出异常的运行时节点层次（即递归深度）
   */
  private Integer exceptionLevel;
  /**
   * 当前规则实例运行上下文中对应的规定定义描述（运行时）
   */
  private RuntimeDefinition runtimeDefinition;
  
  public Thread getRequestThread() {
    return requestThread;
  }
  public void setRequestThread(Thread requestThread) {
    this.requestThread = requestThread;
  }
  public RuleRunTimeStatus getStatus() {
    return status;
  }
  public void setStatus(RuleRunTimeStatus status) {
    this.status = status;
  }
  public Map<String, Object> getParams() {
    return params;
  }
  public void setParams(Map<String, Object> params) {
    this.params = params;
  }
  public Object get_return() {
    return _return;
  }
  public void set_return(Object _return) {
    this._return = _return;
  }
  public Throwable getCurrentThrowable() {
    return currentThrowable;
  }
  public void setCurrentThrowable(Throwable currentThrowable) {
    this.currentThrowable = currentThrowable;
  }
  public Integer getExceptionLevel() {
    return exceptionLevel;
  }
  public void setExceptionLevel(Integer exceptionLevel) {
    this.exceptionLevel = exceptionLevel;
  }
  public RuntimeDefinition getRuntimeDefinition() {
    return runtimeDefinition;
  }
  public void setRuntimeDefinition(RuntimeDefinition runtimeDefinition) {
    this.runtimeDefinition = runtimeDefinition;
  }
  
  /**
   * TODO 注释未写
   * @param instanceId
   * @return
   */
  public static RuleRuntimeContext getRuleRuntimeContext(String instanceId) {
    WeakReference<RuleRuntimeContext> refs = RuleRuntimeContext.ruleRuntimeContexts.get(instanceId);
    return refs.get();
  }
  
  /**
   * TODO 注释未写
   * @param instanceId
   * @param ruleRuntimeContext
   */
  public static void setRuleRuntimeContext(String instanceId , RuleRuntimeContext ruleRuntimeContext) {
    Validate.notNull(ruleRuntimeContext , "错误的规则实例上下文信息[null]，请检查!!");
    // TODO 需要一个引用队列信息
    WeakReference<RuleRuntimeContext> refs = new WeakReference<>(ruleRuntimeContext, null);
    RuleRuntimeContext.ruleRuntimeContexts.put(instanceId, refs);
  }
}
