package com.bizunited.platform.mars.policy.process.runtime.service;

import java.util.Set;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 则实例运行所需要的完整规则节点信息，在这里被进行查询、操作和缓存
 * @author yinwenjie
 */
public interface RuntimeNodeService {
  /**
   * 根据当前规则运行时信息，寻找这个规则定义的开始节点
   * @return
   */
  RuntimeNode findStartByDefinition(RuntimeDefinition currentDefinition);
  /**
   * 根据当前规则链路定义信息，寻找这个链路定义的开始节点
   * @param runtimeProcessorLinked
   * @return
   */
  RuntimeNode findStartByRuntimeProcessorLinked(RuntimeProcessorLinked runtimeProcessorLinked);
  /**
   * 根据当前规则运行时信息，寻找这个规则定义的结束节点（一个或者多个）
   * @param currentDefinition 
   * @return
   */
  Set<RuntimeNode> findEndByDefinition(RuntimeDefinition currentDefinition);
  /**
   * 根据当前规则运行时信息，根据节点的唯一code进行节点运行时的查询
   * @param nodeCode 
   * @param processDefinition 
   * @return 
   */
  RuntimeNode findByCodeAndContext(String nodeCode , RuleRuntimeContext context);
  /**
   * 根据当前的节点信息，基于当前运行的上下文信息，获取后续的运行节点信息</br>
   * 注意，这些节点都是正常规则连线场景下的后续运行时节点
   * @param processDefinition 
   * @return 
   */
  RuntimeNode findNextByContext(RuntimeNode currentNode , RuleRuntimeContext context);
  /**
   * 根据当前的节点信息，基于当前运行的上下文信息，获取后续的运行节点信息</br>
   * 注意，这些节点都是正常规则连线场景下的后续运行时节点
   * @param processDefinition
   * @return
   */
  RuntimeNode findExceptionNextByContext(RuntimeNode currentNode , RuleRuntimeContext context);
//  /**
//   * 在当前线程存在规则执行上下文的场景下，动态的在当前正在处理的节点定义的位置（一般是通过），执行一个指定templateNodeCode的节点
//   * 这个节点定义将从规则执行上下文中获取入参，并将执行后的数据按照出参要求写入到规则上下文中</p>
//   * 如果执行失败，将抛出异常，且影响当前规则执行的后续执行策略
//   * @param templateNodeCode 指定的节点模板业务编号
//   * @param returnParamName 在处理成功结束后，从当前规则执行的上下文中的哪个key里面，提取该方法的返回信息
//   */
//  Object process(String templateNodeCode ,String returnParamName);
//  /**
//   * 在当前线程存在规则执行上下文的场景下，动态的在当前正在处理的节点定义的位置（一般是通过），执行一个指定templateNodeCode的节点
//   * 这个节点定义将从规则执行上下文中获取入参，并将执行后的数据按照出参要求写入到规则上下文中</p>
//   * 如果执行失败，将抛出异常，且影响当前规则执行的后续执行策略
//   * @param templateNodeCode 指定的节点模板业务编号
//   * @param params 可能需要的其它外部参数（可能不传入）
//   * @param returnParamName 在处理成功结束后，从当前规则执行的上下文中的哪个key里面，提取该方法的返回信息
//   */
//  Object process(String templateNodeCode , Map<String , Object> params,String returnParamName);
//  /**
//   * 在当前线程存在规则执行上下文的场景下，动态的在当前正在处理的节点定义的位置（一般是通过），执行一个指定的节点定义信息
//   * 这个节点定义将从规则执行上下文中获取入参，并将执行后的数据按照出参要求写入到规则上下文中</p>
//   * @param currentNode 指定的节点定义信息
//   */
//  void process(RuntimeNode currentNode);
//  /**
//   * 在当前线程存在规则执行上下文的场景下，动态的在当前正在处理的节点定义的位置（一般是通过），执行一个指定的节点定义信息
//   * 这个节点定义将从规则执行上下文中获取入参，并将执行后的数据按照出参要求写入到规则上下文中</p>
//   * @param currentNode 指定的节点定义信息
//   * @param params 可能需要的其它外部参数（可能不传入）
//   */
//  void process(RuntimeNode currentNode, Map<String , Object> params);
}