package com.bizunited.platform.mars.policy.process.runtime.service;

import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;

/**
 * 执行链的操作服务，被执行上下文所封装
 * @author yinwenjie
 */
public interface RuntimeProcessorLinkedService {
  /**
   * 向指定的规则实例上下文中，添加一个新的规则链路，这个规则链路必须满足以下条件：</br>
   * 1、添加时当前规则链路处于运行状态</br>
   * 2、添加时必须指定当前链路的开始节点A，且开始节点A是当前规则实例上下文中规则定义中的其中一个节点</br>
   * 3、添加时必须指定当前链路的第一条分支连线，且这个分支线源于开始节点A</p>
   * 
   * 如果当前链路的开始节点是某个已存在的链路的结束节点，那么这两个链路的父子关系会自动被绑定
   * @param context 
   * @param runtimeProcessorLinked 
   */
  public RuntimeProcessorLinked start(RuleRuntimeContext context , RuntimeProcessorLinked runtimeProcessorLinked);
  
  /**
   * TODO 注释未写
   * @param runtimeProcessorLinked
   * @param runtimeNode
   * @return
   */
  public RuntimeProcessorLinked next(RuntimeProcessorLinked runtimeProcessorLinked , RuntimeNode runtimeNode);
  
  /**
   * 通过该方法将指定规则链路的状态变更为正常结束，并提交正常结束时所执行的最后一个规则节点。</br>
   * 提交的最后一个规则节点，只能是实现了RuntimeEndNode接口的节点，或者继承了RuntimeDelayNode类的节点</p>
   * 
   * 如果实现了RuntimeEndNode接口，那么当前规则链路的结束状态将被置为DONE，表示后续没有任何需要执行的子级链路了；</br>
   * 如果继承了RuntimeDelayNode类，那么当前规则链路的结束状态将被置为DONESELF，表示后续还有需要执行的子级链路；</br>
   * @param runtimeProcessorLinked 
   * @param runtimeNode 
   */
  public RuntimeProcessorLinked end(RuntimeProcessorLinked runtimeProcessorLinked , RuntimeNode runtimeNode);
  
  /**
   * 通过该方法将指定的规则链路的状态更改为异常，并提交异常节点的信息和异常信息
   * @param runtimeProcessorLinked 
   * @param runtimeNode 
   * @param throwable 提交的异常信息 
   * @return 
   */
  public RuntimeProcessorLinked exception(RuntimeProcessorLinked runtimeProcessorLinked , RuntimeNode runtimeNode , Throwable throwable);
}