/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.cache;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.entity.RuleNodeNextsEntity;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeParams;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class RuntimeNode {
    private String id;
    private String code;
    private String templateNodeId;
    private String instanceId;
    private RuntimeNodeType type;
    private String ruleableClass;
    private Set<RuntimeNodeParams> inputs;
    private Set<RuntimeNodeParams> outputs;
    private Set<RuntimeNodeNexts> nexts;

    protected static <S extends RuleNodeEntity, T extends RuntimeNode> T doMappingTransform(Class<T> targetClass, S ruleNode) {
        T runtimeStartNode = RuntimeNode.copyRuntimeNodeByWhiteList(ruleNode, targetClass);
        ((RuntimeNode)runtimeStartNode).setTemplateNodeId(ruleNode.getTemplateNode().getId());
        String nodeCode = ruleNode.getCode();
        Set<RuntimeNodeNexts> runtimeNodeNexts = ((RuntimeNode)runtimeStartNode).getNexts();
        for (RuntimeNodeNexts runtimeNodeNextItem : runtimeNodeNexts) {
            Set ruleNexts = ruleNode.getNexts();
            RuleNodeNextsEntity currentNext = ruleNexts.stream().filter(item -> StringUtils.equals((CharSequence)nodeCode, (CharSequence)item.getFromNode().getCode())).findFirst().orElse(null);
            runtimeNodeNextItem.setToNodeCode(currentNext.getToNode().getCode());
        }
        return runtimeStartNode;
    }

    private static <T extends RuntimeNode> T copyRuntimeNodeByWhiteList(RuleNodeEntity ruleNode, Class<T> targetClass) {
        NebulaToolkitService nebulaToolkitService = new NebulaToolkitService();
        return (T)((RuntimeNode)nebulaToolkitService.copyObjectByWhiteList((Object)ruleNode, targetClass, LinkedHashSet.class, ArrayList.class, new String[]{"inputs", "outputs", "nexts"}));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public RuntimeNodeType getType() {
        return this.type;
    }

    public void setType(RuntimeNodeType type) {
        this.type = type;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getTemplateNodeId() {
        return this.templateNodeId;
    }

    public void setTemplateNodeId(String templateNodeId) {
        this.templateNodeId = templateNodeId;
    }

    public String getRuleableClass() {
        return this.ruleableClass;
    }

    public void setRuleableClass(String ruleableClass) {
        this.ruleableClass = ruleableClass;
    }

    public Set<RuntimeNodeParams> getInputs() {
        return this.inputs;
    }

    public void setInputs(Set<RuntimeNodeParams> inputs) {
        this.inputs = inputs;
    }

    public Set<RuntimeNodeParams> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(Set<RuntimeNodeParams> outputs) {
        this.outputs = outputs;
    }

    public Set<RuntimeNodeNexts> getNexts() {
        return this.nexts;
    }

    public void setNexts(Set<RuntimeNodeNexts> nexts) {
        this.nexts = nexts;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }
}

