/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.executor;

import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeStartAble;
import com.bizunited.platform.mars.policy.process.executor.ProcessorChain;
import com.bizunited.platform.mars.policy.process.executor.RuntimeRuleMapping;
import com.bizunited.platform.mars.policy.process.rule.Ruleable;
import com.bizunited.platform.mars.policy.process.runtime.RuleRunTimeStatus;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeProcessorLinkedService;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Primary;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Primary
@Component(value="ProcessorLinkedChain")
@Scope(value="prototype")
public final class ProcessorLinkedChain
implements ProcessorChain,
Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessorLinkedChain.class);
    private RuntimeNode currentNode;
    private RuleRuntimeContext ruleRuntimeContext;
    private RuntimeProcessorLinked runtimeProcessorLinked;
    @Autowired
    @Qualifier(value="_delayTimerQueue")
    private DelayQueue<RuntimeDelayNode> delayQueue;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeProcessorLinkedService runtimeProcessorLinkedService;
    private int count = 0;

    public ProcessorLinkedChain() {
    }

    public ProcessorLinkedChain(RuntimeNode currentNode, RuleRuntimeContext ruleRuntimeContext, RuntimeProcessorLinked runtimeProcessorLinked) {
        this.currentNode = currentNode;
        this.ruleRuntimeContext = ruleRuntimeContext;
        this.runtimeProcessorLinked = runtimeProcessorLinked;
    }

    @Override
    public void run() {
    }

    @Override
    public void doProcessNode(RuleRuntimeContext context, RuntimeProcessorLinked runtimeProcessorLinked) {
        block15: {
            Validate.notNull((Object)this.ruleRuntimeContext, (String)"\u89c4\u5219\u5b9e\u4f8b\u4e0a\u4e0b\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
            Validate.notNull((Object)runtimeProcessorLinked, (String)"\u89c4\u5219\u94fe\u8def\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
            RuntimeNode currentNode = runtimeProcessorLinked.getCurrentNode();
            if (currentNode == null && this.count == 0) {
                currentNode = runtimeProcessorLinked.getFounder();
                runtimeProcessorLinked.setCurrentNode(currentNode);
            } else if (currentNode == null) {
                Validate.notNull((Object)currentNode, (String)"\u6ca1\u6709\u627e\u5230\u89c4\u5219\u94fe\u8def\u5b9a\u4e49\u7684\u5f00\u59cb\u8282\u70b9\uff0c\u8fd9\u79cd\u60c5\u51b5\u4e00\u822c\u7531\u4e8e\u89c4\u5219\u5b9a\u4e49\u7ed3\u6784\u53d7\u5230\u7834\u574f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            Integer currentLevel = this.count++;
            Class<? extends Ruleable> currentRuleableClass = RuntimeRuleMapping.MAPPING.get(currentNode.getClass());
            Ruleable currentRuleable = (Ruleable)this.applicationContext.getBean(currentRuleableClass);
            if (currentLevel == 0) {
                RuntimeStartAble runtimeStartAble = (RuntimeStartAble)currentNode;
                if (runtimeStartAble.reloadStartNode()) {
                    currentRuleable.doProcess(currentNode, context, runtimeProcessorLinked, this);
                    return;
                }
            } else {
                if (currentNode.getType() == RuntimeNodeType.END) {
                    if (context.getStatus() == RuleRunTimeStatus.EXCEPTION) {
                        throw new IllegalArgumentException(context.getCurrentThrowable());
                    }
                    context.setStatus(RuleRunTimeStatus.DONE);
                    RuntimeDefinition currentDefinition = context.getRuntimeDefinition();
                    String returnParam = currentDefinition.getReturnParam();
                    if (!StringUtils.isBlank((CharSequence)returnParam)) {
                        context.set_return(context.getParams().get(returnParam));
                    }
                    if (context.getRequestThread() != null) {
                        LockSupport.unpark(context.getRequestThread());
                    }
                    return;
                }
                if (currentLevel != 0 && RuntimeStartAble.class.isAssignableFrom(currentRuleableClass)) {
                    RuntimeDelayNode runtimeDelayNode = (RuntimeDelayNode)currentNode;
                    this.delayQueue.add(runtimeDelayNode);
                    this.runtimeProcessorLinkedService.end(runtimeProcessorLinked, currentNode);
                    return;
                }
            }
            RuntimeNodeNexts runtimeNodeNext = null;
            if (this.currentNode == this.runtimeProcessorLinked.getFounder()) {
                runtimeNodeNext = this.runtimeProcessorLinked.getFoundNext();
                Validate.notNull((Object)runtimeNodeNext, (String)"\u6839\u636e\u5f53\u524d\u89c4\u5219\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\uff0c\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4e0b\u4e00\u8fd0\u884c\u65f6\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                currentNode = this.runtimeNodeService.findByCodeAndContext(runtimeNodeNext.getToNodeCode(), context);
            } else {
                currentNode = this.runtimeNodeService.findNextByContext(currentNode, context);
                Validate.notNull((Object)currentNode, (String)"\u6839\u636e\u5f53\u524d\u89c4\u5219\u8fd0\u884c\u65f6\u4e0a\u4e0b\u6587\uff0c\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u4e0b\u4e00\u8fd0\u884c\u65f6\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            currentRuleableClass = RuntimeRuleMapping.MAPPING.get(currentNode.getClass());
            currentRuleable = (Ruleable)this.applicationContext.getBean(currentRuleableClass);
            try {
                currentRuleable.doProcess(currentNode, context, runtimeProcessorLinked, this);
                this.runtimeProcessorLinkedService.next(runtimeProcessorLinked, currentNode);
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                if (context.getStatus() != RuleRunTimeStatus.NORMAL) break block15;
                RuntimeException currente = e;
                context.setCurrentThrowable(currente);
                context.setStatus(RuleRunTimeStatus.EXCEPTION);
                context.setExceptionLevel(currentLevel);
                this.runtimeProcessorLinkedService.exception(this.runtimeProcessorLinked, currentNode, e);
            }
        }
    }
}

