/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.runtime.service;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.policy.process.cache.Mappable;
import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeMapping;
import com.bizunited.platform.mars.policy.process.cache.waiter.RuntimeDelayNode;
import com.bizunited.platform.mars.policy.process.runtime.RuleRunTimeStatus;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.AbstractRuntimeService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeDefinitionService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;
import com.bizunited.platform.mars.service.RuleDefinitionListener;
import com.bizunited.platform.mars.service.RuleDefinitionService;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.ExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="simpleRuntimeDefinitionService")
public class SimpleRuntimeDefinitionService
extends AbstractRuntimeService
implements RuntimeDefinitionService,
RuleDefinitionListener {
    @Autowired
    private RuleDefinitionService ruleDefinitionService;
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    @Qualifier(value="_delayTimerQueue")
    private DelayQueue<RuntimeDelayNode> delayQueue;
    private static Cache<String, RuleDefinitionEntity> cached;
    private static Map<String, ReentrantLock> runtimeDefinitionQueryLocks;
    private static final String PRE = "_MARS";
    private static final Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleRuntimeDefinitionService() {
        Class<SimpleRuntimeDefinitionService> clazz = SimpleRuntimeDefinitionService.class;
        synchronized (SimpleRuntimeDefinitionService.class) {
            while (cached == null) {
                ResourcePools resourcePools = ResourcePoolsBuilder.heap((long)500L).build();
                ExpiryPolicy expiryPolicy = ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofHours(24L));
                CacheConfigurationBuilder cacheConfigurationBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, RuleDefinitionEntity.class, (ResourcePools)resourcePools);
                CacheConfiguration cacheConfiguration = cacheConfigurationBuilder.withExpiry(expiryPolicy).build();
                CacheManagerBuilder build = CacheManagerBuilder.newCacheManagerBuilder();
                CacheManager cacheManager = build.withCache("pre_RuleDefinition_Configured", cacheConfiguration).withDefaultSizeOfMaxObjectSize(1024L, MemoryUnit.MB).build(true);
                cached = cacheManager.getCache("pre_RuleDefinition_Configured", String.class, RuleDefinitionEntity.class);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Object process(String code, String version, Map<String, Object> params) {
        RuleRuntimeContext runtimeContext = this.start(code, version, params);
        runtimeContext.setRequestThread(Thread.currentThread());
        LockSupport.park(runtimeContext);
        return runtimeContext.get_return();
    }

    private RuntimeDefinition createByCodeAndVersion(String code, String version) {
        Validate.notBlank((CharSequence)code, (String)"\u5fc5\u987b\u4f20\u5165\u89c4\u5219\u5b9a\u4e49\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)version, (String)"\u5fc5\u987b\u4f20\u5165\u89c4\u5219\u5b9a\u4e49\u7248\u672c\u4fe1\u606f!!", (Object[])new Object[0]);
        String instanceId = UUID.randomUUID().toString();
        RuleDefinitionEntity ruleDefinition = this.findDetailsByCodeAndVersion(code, version);
        Validate.notNull((Object)ruleDefinition, (String)"\u9519\u8bef\u7684\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f[code=%s;version=%s]\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{code, version});
        RuntimeDefinition resultRuntimeDefinition = (RuntimeDefinition)this.nebulaToolkitService.copyObjectByWhiteList((Object)ruleDefinition, RuntimeDefinition.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        resultRuntimeDefinition.setInstanceId(instanceId);
        HashSet<RuntimeNode> runtimeNodes = new HashSet<RuntimeNode>();
        for (RuleNodeEntity ruleNode : ruleDefinition.getNodes()) {
            int type = ruleNode.getType();
            Class<? extends RuntimeNode> runtimeNodeClass = null;
            runtimeNodeClass = type == 2 ? RuntimeNodeMapping.MAPPING.get(type * 10 + ruleNode.getSourceType()) : RuntimeNodeMapping.MAPPING.get(type);
            Validate.notNull(runtimeNodeClass, (String)"\u627e\u5230\u8282\u70b9\u7c7b\u578b\u4e3a[%d]\u7684\u8282\u70b9\u5b9a\u4e49\uff0c\u4f46\u662f\u8be5\u503c\u6240\u5bf9\u5e94\u7684\u8282\u70b9\u7c7b\u578b\uff0c\u76ee\u524d\u89c4\u5219\u5f15\u64ce\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{type});
            RuntimeNode currrentRuntimeNode = null;
            try {
                currrentRuntimeNode = runtimeNodeClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            Validate.isTrue((boolean)(currrentRuntimeNode instanceof Mappable), (String)"\u5f53\u524d\u8282\u70b9\u7c7b\u578b[%s]\u4e0b\u7684\u5177\u4f53\u8282\u70b9\u5b9a\u4e49\uff0c\u6ca1\u6709\u5b9e\u73b0Mappable\u63a5\u53e3\uff0c\u65e0\u6cd5\u5b9e\u73b0\u8282\u70b9\u5b9a\u4e49\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5!!", (long)type);
            Mappable currentMappable = (Mappable)((Object)currrentRuntimeNode);
            Object currentRuntimeNode = currentMappable.mappingTransform(ruleNode);
            ((RuntimeNode)currentRuntimeNode).setInstanceId(instanceId);
            runtimeNodes.add((RuntimeNode)currentRuntimeNode);
        }
        resultRuntimeDefinition.setNodes(runtimeNodes);
        return resultRuntimeDefinition;
    }

    private RuleRuntimeContext start(String code, String version, Map<String, Object> params) {
        RuntimeDefinition currentDefinition = this.createByCodeAndVersion(code, version);
        RuntimeNode startNode = this.runtimeNodeService.findStartByDefinition(currentDefinition);
        Set<RuntimeNode> endNodes = this.runtimeNodeService.findEndByDefinition(currentDefinition);
        Validate.notNull((Object)startNode, (String)"\u672a\u627e\u5230\u89c4\u5219\u5b9a\u4e49\u4e2d\u7684\u5f00\u59cb\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u5b9a\u4e49!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(endNodes) ? 1 : 0) != 0, (String)"\u672a\u627e\u5230\u89c4\u5b9a\u5b9a\u4e49\u4e2d\u6709\u4efb\u4f55\u7ed3\u675f\u8282\u70b9\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u5b9a\u4e49!!", (Object[])new Object[0]);
        Validate.isTrue((endNodes.size() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u89c4\u5219\u5b9a\u4e49\u4e2d\u627e\u5230\u4e0d\u6b62\u4e00\u4e2a\u7ed3\u675f\u8282\u70b9\uff0c\u4e0d\u80fd\u4f7f\u7528\u540c\u6b65\u8c03\u7528\u65b9\u5f0f\u8fdb\u884c\u89c4\u5219\u5b9e\u4f8b\u7684\u8c03\u7528!!", (Object[])new Object[0]);
        RuleRuntimeContext runtimeContext = new RuleRuntimeContext();
        runtimeContext.setStatus(RuleRunTimeStatus.NORMAL);
        if (params != null) {
            runtimeContext.setParams(new HashMap<String, Object>(params));
        }
        runtimeContext.setRuntimeDefinition(currentDefinition);
        RuleRuntimeContext.setRuleRuntimeContext(currentDefinition.getInstanceId(), runtimeContext);
        this.delayQueue.add((RuntimeDelayNode)startNode);
        return runtimeContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RuleDefinitionEntity findDetailsByCodeAndVersion(String code, String version) {
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)version)) {
            return null;
        }
        String key = StringUtils.join((Object[])new String[]{PRE, "_", code, "_", version});
        RuleDefinitionEntity cacheRuleDefinitionEntity = this.findDetailsByCodeAndVersionOnCache(code, version);
        if (cacheRuleDefinitionEntity != null) {
            LOGGER.info("// === \u4ece\u7f13\u5b58\u4e2d\u52a0\u8f7d!!cacheRuleDefinitionEntity = " + code);
            return cacheRuleDefinitionEntity;
        }
        Class<SimpleRuntimeDefinitionService> clazz = SimpleRuntimeDefinitionService.class;
        synchronized (SimpleRuntimeDefinitionService.class) {
            while (runtimeDefinitionQueryLocks.get(key) == null) {
                runtimeDefinitionQueryLocks.put(key, new ReentrantLock());
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            ReentrantLock lock = null;
            RuleDefinitionEntity ruleDefinitionEntity = null;
            try {
                lock = runtimeDefinitionQueryLocks.get(key);
                lock.lock();
                ruleDefinitionEntity = this.findDetailsByCodeAndVersionOnCache(code, version);
                if (ruleDefinitionEntity == null) {
                    ruleDefinitionEntity = this.ruleDefinitionService.findDetailsByCodeAndVersion(code, version);
                    if (ruleDefinitionEntity == null) {
                        RuleDefinitionEntity ruleDefinitionEntity2 = null;
                        return ruleDefinitionEntity2;
                    }
                    RuleDefinitionEntity target = (RuleDefinitionEntity)this.nebulaToolkitService.copyObjectByWhiteList((Object)ruleDefinitionEntity, RuleDefinitionEntity.class, LinkedHashSet.class, ArrayList.class, new String[]{"nodes", "nodes.templateNode", "nodes.ruleLockExt", "nodes.ruleAggregationExt", "nodes.ruleTimerExt", "nodes.inputs", "nodes.outputs", "nodes.nexts", "nodes.nexts.fromNode", "nodes.nexts.toNode"});
                    cached.put((Object)key, (Object)target);
                    RuleDefinitionEntity ruleDefinitionEntity3 = target;
                    return ruleDefinitionEntity3;
                }
                RuleDefinitionEntity ruleDefinitionEntity4 = ruleDefinitionEntity;
                return ruleDefinitionEntity4;
            }
            finally {
                lock.unlock();
            }
        }
    }

    private RuleDefinitionEntity findDetailsByCodeAndVersionOnCache(String code, String version) {
        String key = StringUtils.join((Object[])new String[]{PRE, "_", code, "_", version});
        RuleDefinitionEntity ruleDefinitionEntity = (RuleDefinitionEntity)cached.get((Object)key);
        return ruleDefinitionEntity;
    }

    @Override
    public void processAsync(String code, String version, Map<String, Object> params) {
    }

    public void onDefinitionCreate(RuleDefinitionEntity ruleDefinition) {
    }

    public void onDefinitionModify(RuleDefinitionEntity ruleDefinition) {
        this.onDefinitionDelete(ruleDefinition);
    }

    public void onDefinitionDelete(RuleDefinitionEntity ruleDefinition) {
        String code = ruleDefinition.getCode();
        String version = ruleDefinition.getCverion();
        String key = StringUtils.join((Object[])new String[]{PRE, "_", code, "_", version});
        cached.remove((Object)key);
    }

    static {
        runtimeDefinitionQueryLocks = new ConcurrentHashMap<String, ReentrantLock>();
        LOGGER = LoggerFactory.getLogger(SimpleRuntimeDefinitionService.class);
    }
}

