/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.policy.process.runtime.service;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.mars.policy.process.cache.RuntimeDefinition;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNode;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeNexts;
import com.bizunited.platform.mars.policy.process.cache.RuntimeNodeType;
import com.bizunited.platform.mars.policy.process.cache.RuntimeProcessorLinked;
import com.bizunited.platform.mars.policy.process.runtime.contexts.RuleRuntimeContext;
import com.bizunited.platform.mars.policy.process.runtime.service.AbstractRuntimeService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeDefinitionService;
import com.bizunited.platform.mars.policy.process.runtime.service.RuntimeNodeService;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="SimpleRuntimeNodeService")
public class SimpleRuntimeNodeService
extends AbstractRuntimeService
implements RuntimeNodeService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleRuntimeNodeService.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RuntimeNodeService runtimeNodeService;
    @Autowired
    private RuntimeDefinitionService runtimeDefinitionService;
    @Autowired
    private ScriptService scriptService;

    @Override
    public RuntimeNode findStartByDefinition(RuntimeDefinition currentDefinition) {
        if (currentDefinition == null) {
            return null;
        }
        Set<RuntimeNode> nodes = currentDefinition.getNodes();
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        return nodes.stream().filter(item -> item.getType() == RuntimeNodeType.BEGIN).findFirst().orElse(null);
    }

    @Override
    public RuntimeNode findStartByRuntimeProcessorLinked(RuntimeProcessorLinked runtimeProcessorLinked) {
        if (runtimeProcessorLinked == null) {
            return null;
        }
        return runtimeProcessorLinked.getFounder();
    }

    @Override
    public Set<RuntimeNode> findEndByDefinition(RuntimeDefinition currentDefinition) {
        if (currentDefinition == null) {
            return null;
        }
        Set<RuntimeNode> nodes = currentDefinition.getNodes();
        if (CollectionUtils.isEmpty(nodes)) {
            return null;
        }
        return nodes.stream().filter(item -> item.getType() == RuntimeNodeType.END).collect(Collectors.toSet());
    }

    @Override
    public RuntimeNode findByCodeAndContext(String nodeCode, RuleRuntimeContext context) {
        if (StringUtils.isBlank((CharSequence)nodeCode) || context == null) {
            return null;
        }
        RuntimeDefinition runtimeDefinition = context.getRuntimeDefinition();
        Set<RuntimeNode> runtimeNodes = runtimeDefinition.getNodes();
        RuntimeNode currentNode = runtimeNodes.stream().filter(item -> StringUtils.equals((CharSequence)item.getCode(), (CharSequence)nodeCode)).findFirst().orElse(null);
        if (!this.validate(currentNode, context)) {
            return null;
        }
        return currentNode;
    }

    @Override
    public RuntimeNode findNextByContext(RuntimeNode currentNode, RuleRuntimeContext context) {
        if (!this.validate(currentNode, context)) {
            return null;
        }
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        Set<RuntimeNode> nodes = context.getRuntimeDefinition().getNodes();
        RuntimeNodeType type = currentNode.getType();
        if (type != RuntimeNodeType.CONDITION && type != RuntimeNodeType.CONCURRENCY) {
            Validate.isTrue((nexts.stream().filter(item -> item.getLineType() == 1).count() == 1L ? 1 : 0) != 0, (String)"\u5f53\u524d\u8fd0\u884c\u7684\u89c4\u5219\u8282\u70b9\u5b9a\u4e49\uff0c\u4e0d\u662f\u6761\u4ef6\u7c7b\u578b\u6216\u8005\u5e76\u884c\u5206\u652f\u7c7b\u578b\u7684\u8282\u70b9\uff0c\u4e0d\u80fd\u6709\u591a\u4e2a\u5e38\u89c4\u8fde\u7ebf\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            RuntimeNodeNexts next = nexts.stream().filter(item -> item.getLineType() == 1).findFirst().orElse(null);
            String nodeCode = next.getToNodeCode();
            LOGGER.info("\u89c4\u5219\u5f15\u64ce\u6b63\u5728\u67e5\u627e\u4e0b\u4e00\u8282\u70b9\uff1anodeCode = " + nodeCode);
            RuntimeNode targetNode = null;
            try {
                targetNode = nodes.stream().filter(item -> StringUtils.equals((CharSequence)item.getCode(), (CharSequence)nodeCode)).findFirst().orElse(null);
            }
            catch (RuntimeException e) {
                if (nodes != null) {
                    LOGGER.info("96\u884c\u9519\u8bef\uff0c\u5f53\u524dnodes\u7684\u60c5\u51b5\u4e3a " + JSONArray.toJSONString(nodes));
                }
                LOGGER.info("96\u884c\u9519\u8bef\uff0c\u5f53\u524dnodes\u7684\u60c5\u51b5\u4e3a null ");
            }
            return targetNode;
        }
        Set sortNexts = nexts.stream().filter(item -> item.getLineType() == 1).sorted((source, target) -> source.getSort() - target.getSort()).collect(Collectors.toSet());
        RuntimeNodeNexts currentNext = null;
        for (RuntimeNodeNexts next : sortNexts) {
            String conditions = next.getConditions();
            if (StringUtils.isBlank((CharSequence)conditions)) continue;
            Object evalResult = this.executeGroovyScript(conditions, context.getParams());
            if (evalResult == null || Boolean.class != evalResult.getClass()) {
                throw new IllegalArgumentException("\u6761\u4ef6\u5224\u5b9a\u5206\u652f\u7684\u8fd4\u56de\u503c\uff0c\u53ea\u80fd\u662fboolean\u578b\uff0c\u8bf7\u68c0\u67e5!!");
            }
            if (!((Boolean)evalResult).booleanValue()) continue;
            currentNext = next;
            break;
        }
        if (currentNext == null) {
            currentNext = sortNexts.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getConditions())).findFirst().orElse(null);
        }
        Validate.notNull(currentNext, (String)"\u672a\u53d1\u73b0\u4efb\u4f55\u7b26\u5408\u6761\u4ef6\u7684\u8fd0\u884c\u5206\u652f\uff0c\u4e5f\u6ca1\u6709\u53d1\u73b0\u672a\u8bbe\u7f6e\u8fd0\u884c\u6761\u4ef6\u7684\u9ed8\u8ba4\u5206\u652f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String toNodeCode = currentNext.getToNodeCode();
        RuntimeNode targetNode = nodes.stream().filter(item -> item.getCode() == toNodeCode).findFirst().orElse(null);
        Validate.notNull((Object)targetNode, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u8282\u70b9\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{toNodeCode});
        return targetNode;
    }

    private Object executeGroovyScript(String scriptContxt, Map<String, Object> contentMap) {
        HashMap<String, Object> scriptInputsMap = new HashMap<String, Object>(contentMap);
        scriptInputsMap.put("runtimeNodeService", this.runtimeNodeService);
        scriptInputsMap.put("runtimeDefinitionService", this.runtimeDefinitionService);
        return this.scriptService.invoke(scriptContxt, scriptInputsMap);
    }

    private boolean validate(RuntimeNode currentNode, RuleRuntimeContext context) {
        if (currentNode == null || context == null) {
            return false;
        }
        String fromId = currentNode.getId();
        RuntimeNodeType type = currentNode.getType();
        if (StringUtils.isBlank((CharSequence)fromId)) {
            return false;
        }
        if (type == RuntimeNodeType.END) {
            return false;
        }
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        if (CollectionUtils.isEmpty(nexts)) {
            throw new IllegalArgumentException("\u672a\u53d1\u73b0\u6307\u5b9a\u8282\u70b9\u7684\u540e\u7eed\u8282\u70b9\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5\u89c4\u5219\u6a21\u677f\u8bbe\u5b9a!!");
        }
        return true;
    }

    @Override
    public RuntimeNode findExceptionNextByContext(RuntimeNode currentNode, RuleRuntimeContext context) {
        Set sortNexts;
        if (!this.validate(currentNode, context)) {
            return null;
        }
        Set<RuntimeNodeNexts> nexts = currentNode.getNexts();
        Set<RuntimeNode> nodes = context.getRuntimeDefinition().getNodes();
        Throwable currentThrowable = context.getCurrentThrowable();
        if (currentThrowable == null) {
            return null;
        }
        if (currentThrowable instanceof InvocationTargetException) {
            currentThrowable = ((InvocationTargetException)currentThrowable).getTargetException();
        }
        if (CollectionUtils.isEmpty(sortNexts = nexts.stream().filter(item -> item.getLineType() == 2).sorted((source, target) -> source.getSort() - target.getSort()).collect(Collectors.toSet()))) {
            return null;
        }
        ClassLoader classLoader = this.applicationContext.getClassLoader();
        RuntimeNodeNexts currentNext = null;
        for (RuntimeNodeNexts next : sortNexts) {
            String[] exceptionValues;
            String exceptions = next.getExceptions();
            if (StringUtils.isBlank((CharSequence)exceptions)) continue;
            for (String exceptionValue : exceptionValues = StringUtils.split((String)exceptions, (String)",")) {
                Class<?> exceptionClass = null;
                try {
                    exceptionClass = classLoader.loadClass(exceptionValue);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                    throw new IllegalArgumentException(String.format("\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u5f02\u5e38\u5b9a\u4e49\u7c7b[%s]\uff0c\u8bf7\u68c0\u67e5!!", exceptionValue), e);
                }
                if (!exceptionClass.isAssignableFrom(currentThrowable.getClass())) continue;
                currentNext = next;
            }
        }
        if (currentNext == null) {
            currentNext = sortNexts.stream().filter(item -> StringUtils.isBlank((CharSequence)item.getConditions())).findFirst().orElse(null);
        }
        if (currentNext == null) {
            return null;
        }
        String toNodeCode = currentNext.getToNodeCode();
        RuntimeNode targetNode = nodes.stream().filter(item -> item.getCode() == toNodeCode).findFirst().orElse(null);
        Validate.notNull((Object)targetNode, (String)"\u6ca1\u6709\u53d1\u73b0\u6307\u5b9a\u7684\u8282\u70b9[%s]\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{toNodeCode});
        return targetNode;
    }
}

