package com.bizunited.platform.mars.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.mars.entity.RuleTemplateNodeEntity;
import com.bizunited.platform.mars.service.RuleTemplateNodeEntityService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.lang.String;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * RuleTemplateNodeEntity业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/ruleTemplateNodes")
public class RuleTemplateNodeController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RuleTemplateNodeController.class);
  
  @Autowired
  private RuleTemplateNodeEntityService ruleTemplateNodeEntityService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建ruleTemplateNodeEntity中的基本信息以外，还可以对ruleTemplateNodeEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleTemplateNodeEntity）模型的创建操作传入的ruleTemplateNodeEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建ruleTemplateNodeEntity中的基本信息以外，还可以对ruleTemplateNodeEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleTemplateNodeEntity）模型的创建操作传入的ruleTemplateNodeEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="ruleTemplateNodeEntity" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建ruleTemplateNodeEntity中的基本信息以外，还可以对ruleTemplateNodeEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleTemplateNodeEntity）模型的创建操作传入的ruleTemplateNodeEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") RuleTemplateNodeEntity ruleTemplateNodeEntity) {
    try {
      RuleTemplateNodeEntity current = this.ruleTemplateNodeEntityService.create(ruleTemplateNodeEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "节点模板基本信息，包括其下的入参、出参信息的更新操作。更新操作不能变化code、类型、逻辑类型等信息，而且出参和入参信息会进行全量更新")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="ruleTemplateNodeEntity" , value="节点模板基本信息，包括其下的入参、出参信息的更新操作。更新操作不能变化code、类型、逻辑类型等信息，而且出参和入参信息会进行全量更新") RuleTemplateNodeEntity ruleTemplateNodeEntity) {
    try {
      RuleTemplateNodeEntity current = this.ruleTemplateNodeEntityService.update(ruleTemplateNodeEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }
  
  /**
   * 基于指定的模板分组ID，绑定模板节点信息（支持多个，增量绑定）
   * @param id
   * @param templateNodeIds
   */
  @ApiOperation(value = "基于指定的模板分组ID，绑定模板节点信息（支持多个，增量绑定）")
  @PostMapping(value="/bindTemplateGroup")
  public ResponseModel bindTemplateGroup(@RequestParam("templateGroupId") @ApiParam("基于指定的模板分组ID") String templateGroupId ,
                                         @RequestParam("templateNodeIds") @ApiParam("绑定模板节点信息（支持多个，增量绑定）") String[] templateNodeIds) {
    try { 
      this.ruleTemplateNodeEntityService.bindTemplateGroup(templateGroupId, templateNodeIds);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }
  /**
   * 基于指定的模板分组ID，重绑定模板节点信息（全量重绑定），其它绑定关系将被作废
   * @param id
   * @param templateNodeIds
   */
  @ApiOperation(value = "基于指定的模板分组ID，重绑定模板节点信息（全量重绑定），其它绑定关系将被作废")
  @PostMapping(value="/rebindTemplateGroup")
  public ResponseModel rebindTemplateGroup(@RequestParam("templateGroupId") @ApiParam("基于指定的模板分组ID") String templateGroupId ,
                                           @RequestParam("templateNodeIds") @ApiParam("绑定模板节点信息（全量重绑定），其它绑定关系将被作废") String[] templateNodeIds) {
    try { 
      this.ruleTemplateNodeEntityService.rebindTemplateGroup(templateGroupId, templateNodeIds);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }
  /**
   * 基于指定的模板分组，解除绑定模板节点信息
   * @param id
   * @param templateNodeIds
   */
  @ApiOperation(value = "基于指定的模板分组，解除绑定模板节点信息")
  @PostMapping(value="/unbindTemplateGroups")
  public ResponseModel unbindTemplateGroups(@RequestParam("templateGroupId") @ApiParam("基于指定的模板分组ID") String templateGroupId ,
                                            @RequestParam("templateNodeIds") @ApiParam("解除绑定模板节点id编号信息") String[] templateNodeIds) {
    try { 
      this.ruleTemplateNodeEntityService.unbindTemplateGroups(templateGroupId, templateNodeIds);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  /**
   * 按照RuleTemplateNodeEntity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照RuleTemplateNodeEntity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      RuleTemplateNodeEntity result = this.ruleTemplateNodeEntityService.findDetailsById(id); 
      return this.buildHttpResultW(result, new String[]{"templateGroup","inputs","outputs","sourceServicable","sourceAggregateDataView","sourceScript"}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  

  @ApiOperation(value = "按照RuleTemplateNodeEntity实体中的（code）节点模板业务编号进行查询")
  @RequestMapping(value="/findByCode" , method={RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("节点模板业务编号") String code) {
    try { 
      RuleTemplateNodeEntity result = this.ruleTemplateNodeEntityService.findByCode(code); 
      return this.buildHttpResultW(result, new String[]{}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }

  @ApiOperation(value = "按照模板节点分组，查询属于这个模板分组下符合模板定义的模板节点的信息（只包括基本信息）,返回信息将按照节点模板业务编号进行排序")
  @RequestMapping(value="/findByTemplateGroupAndStatus" , method={RequestMethod.GET})
  public ResponseModel findByTemplateGroupAndStatus(@RequestParam("templateGroup") @ApiParam("关联的 节点定义所属的分组") String templateGroup , 
                                           @RequestParam(name = "nodeStatus" , required = false) @ApiParam(value="节点模板的状态条件(可以不传入)，如果不传就不再参考该条件" , required = false) Integer nodeStatus) {
    try {  
      Set<RuleTemplateNodeEntity> result = this.ruleTemplateNodeEntityService.findByTemplateGroupAndStatus(templateGroup , nodeStatus); 
      return this.buildHttpResultW(result); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  
  @ApiOperation(value = "按照模板节点分组，节点状态，节点模板类型查询符合要求的模板节点的信息（只包括基本信息）,返回信息将按照创建时间进行倒叙排列。注意，其中的三个参数都不是必须填写的")
  @RequestMapping(value="/findByTemplateGroupAndStatusAndType" , method={RequestMethod.GET})
  public ResponseModel findByTemplateGroupAndStatusAndType(@RequestParam(name="templateGroup" , required = false) @ApiParam(value ="指定的模板分组id" , required = false) String templateGroup 
                                                           ,@RequestParam(name="nodeStatus", required = false) @ApiParam(value ="节点模板的状态条件(可以不传入)，如果不传就不再参考该条件" , required = false) Integer nodeStatus ,
                                                           @RequestParam(name="type", required = false) @ApiParam(value =" 1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件" , required = false) Integer type) {
    try { 
      List<RuleTemplateNodeEntity> results = this.ruleTemplateNodeEntityService.findByTemplateGroupAndStatusAndType(templateGroup, nodeStatus, type);
      return this.buildHttpResultW(results , "templateGroup"); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }
} 
