package com.bizunited.platform.mars.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.mars.entity.RuleDefinitionEntity;
import com.bizunited.platform.mars.service.RuleDefinitionService;

import io.swagger.annotations.ApiOperation;
import java.util.List;

import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * RuleDefinitionEntity业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/ruleDefinitions")
public class RuleDefinitionController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RuleDefinitionController.class);
  
  @Autowired
  private RuleDefinitionService ruleDefinitionEntityService;
  
  /**
   * 查询当前已创建的所有规则定义基本信息，并按照创建时间进行排序
   * @return
   */
  @ApiOperation(value = "查询当前已创建的所有规则定义基本信息，并按照创建时间进行排序")
  @GetMapping(value="/findAll")
  public ResponseModel findAll() {
    try { 
      List<RuleDefinitionEntity> result = this.ruleDefinitionEntityService.findAll();
      return this.buildHttpResultW(result); 
    } catch(RuntimeException e) { 
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }


  /**
   * 按照给定的模板编码和版本，查询模板文件内容。
   * @param code
   * @param version
   */
  @ApiOperation(value = "按照给定的模板编码和版本，查询模板文件内容。")
  @GetMapping("/findContentByCodeAndVersion")
  public ResponseModel findContentByCodeAndVersion(@ApiParam(name = "code", value = "模板编码", required = true) @RequestParam("code") String code,
                                                   @ApiParam(name = "version", value = "版本", required = true) @RequestParam("version") String version){
    try {
      String content = ruleDefinitionEntityService.findContentByCodeAndVersion(code, version);
      return buildHttpResultW(content);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return buildHttpResultForException(e);
    }
  }
} 