package com.bizunited.platform.mars.controller;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.mars.entity.RuleNodeEntity;
import com.bizunited.platform.mars.service.RuleNodeEntityService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.lang.String;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * RuleNodeEntity业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/ruleNodes")
public class RuleNodeController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RuleNodeController.class);
  
  @Autowired
  private RuleNodeEntityService ruleNodeEntityService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建ruleNodeEntity中的基本信息以外，还可以对ruleNodeEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleNodeEntity）模型的创建操作传入的ruleNodeEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建ruleNodeEntity中的基本信息以外，还可以对ruleNodeEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleNodeEntity）模型的创建操作传入的ruleNodeEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="ruleNodeEntity" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建ruleNodeEntity中的基本信息以外，还可以对ruleNodeEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleNodeEntity）模型的创建操作传入的ruleNodeEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") RuleNodeEntity ruleNodeEntity) {
    try {
      RuleNodeEntity current = this.ruleNodeEntityService.create(ruleNodeEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（RuleNodeEntity）的修改操作传入的ruleNodeEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（RuleNodeEntity）的修改操作传入的ruleNodeEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="ruleNodeEntity" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，包括一般属性、ManyToOne和OneToOne性质的关联属性，而ManyToMany、OneToMany的关联属性，虽然也会传入，但需要开发人员自行在Service层完善其更新过程注意：基于模型（RuleNodeEntity）的修改操作传入的ruleNodeEntityJSON对象，其主键信息必须有值，服务端将验证这个主键值是否已经存在。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") RuleNodeEntity ruleNodeEntity) {
    try {
      RuleNodeEntity current = this.ruleNodeEntityService.update(ruleNodeEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照RuleNodeEntity实体中的（templateNode）关联的 该节点定义使用的节点模板进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param templateNode 关联的 该节点定义使用的节点模板
   */
  @ApiOperation(value = "按照RuleNodeEntity实体中的（templateNode）关联的 该节点定义使用的节点模板进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByTemplateNode" , method={RequestMethod.GET})
  public ResponseModel findDetailsByTemplateNode(@RequestParam("templateNode") @ApiParam("关联的 该节点定义使用的节点模板") String templateNode) {
    try { 
      Set<RuleNodeEntity> result = this.ruleNodeEntityService.findDetailsByTemplateNode(templateNode); 
      return this.buildHttpResultW(result, new String[]{"templateNode","definition"}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照RuleNodeEntity实体中的（definition）关联的 规则工作节点所属的规则模板进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param definition 关联的 规则工作节点所属的规则模板
   */
  @ApiOperation(value = "按照RuleNodeEntity实体中的（definition）关联的 规则工作节点所属的规则模板进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByDefinition" , method={RequestMethod.GET})
  public ResponseModel findDetailsByDefinition(@RequestParam("definition") @ApiParam("关联的 规则工作节点所属的规则模板") String definition) {
    try { 
      Set<RuleNodeEntity> result = this.ruleNodeEntityService.findDetailsByDefinition(definition); 
      return this.buildHttpResultW(result, new String[]{"templateNode","definition"}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照RuleNodeEntity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照RuleNodeEntity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      RuleNodeEntity result = this.ruleNodeEntityService.findDetailsById(id); 
      return this.buildHttpResultW(result, new String[]{"templateNode","definition"}); 
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照RuleNodeEntity实体中的（code）节点定义业务编号进行查询
   * @param code 节点定义业务编号
   */
  @ApiOperation(value = "按照RuleNodeEntity实体中的（code）节点定义业务编号进行查询")
  @RequestMapping(value="/findByCode" , method={RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("节点定义业务编号") String code) {
    try { 
      RuleNodeEntity result = this.ruleNodeEntityService.findByCode(code); 
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
} 
