package com.bizunited.platform.mars.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.mars.entity.RuleTemplateGroupEntity;
import com.bizunited.platform.mars.service.RuleTemplateGroupEntityService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.lang.String;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * RuleTemplateGroupEntity业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/ruleTemplateGroups")
public class RuleTemplateGroupController extends BaseController { 
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(RuleTemplateGroupController.class);
  
  @Autowired
  private RuleTemplateGroupEntityService ruleTemplateGroupEntityService;

  /**
   * 相关的创建过程，http接口。请注意该创建过程除了可以创建ruleTemplateGroupEntity中的基本信息以外，还可以对ruleTemplateGroupEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleTemplateGroupEntity）模型的创建操作传入的ruleTemplateGroupEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）
   * */
  @ApiOperation(value = "相关的创建过程，http接口。请注意该创建过程除了可以创建ruleTemplateGroupEntity中的基本信息以外，还可以对ruleTemplateGroupEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleTemplateGroupEntity）模型的创建操作传入的ruleTemplateGroupEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="ruleTemplateGroupEntity" , value="相关的创建过程，http接口。请注意该创建过程除了可以创建ruleTemplateGroupEntity中的基本信息以外，还可以对ruleTemplateGroupEntity中属于OneToMany关联的明细信息一同进行创建注意：基于（RuleTemplateGroupEntity）模型的创建操作传入的ruleTemplateGroupEntityJSON对象，其主键信息不能有值，服务端将会自动为其赋予相关值。另外，创建操作成功后，系统将返回该对象的基本信息（不包括任何关联信息）") RuleTemplateGroupEntity ruleTemplateGroupEntity) {
    try {
      RuleTemplateGroupEntity current = this.ruleTemplateGroupEntityService.create(ruleTemplateGroupEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，只能对状态、名称进行修改。分组的业务编号、支持的组件类型不能修改
   * */
  @ApiOperation(value = "相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，只能对状态、名称进行修改。分组的业务编号、支持的组件类型不能修改")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="ruleTemplateGroupEntity" , value="相关的更新过程，http接口。请注意该更新过程只会更新在模型层被标记为了updateable的属性，只能对状态、名称进行修改。分组的业务编号、支持的组件类型不能修改") RuleTemplateGroupEntity ruleTemplateGroupEntity) {
    try {
      RuleTemplateGroupEntity current = this.ruleTemplateGroupEntityService.update(ruleTemplateGroupEntity);
      return this.buildHttpResultW(current, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照RuleTemplateGroupEntity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照RuleTemplateGroupEntity实体中的（id）主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      RuleTemplateGroupEntity result = this.ruleTemplateGroupEntityService.findDetailsById(id); 
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照RuleTemplateGroupEntity实体中的（code）分组编号编号进行查询
   * @param code 分组编号编号
   */
  @ApiOperation(value = "按照RuleTemplateGroupEntity实体中的（code）分组编号编号进行查询")
  @RequestMapping(value="/findByCode" , method={RequestMethod.GET})
  public ResponseModel findByCode(@RequestParam("code") @ApiParam("分组编号编号") String code) {
    try { 
      RuleTemplateGroupEntity result = this.ruleTemplateGroupEntityService.findByCode(code); 
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }  
  /**
   * 按照分组的状态情况进行查询，并按照分类+名字的方式进行排序（只包括基本信息）
   * @param groupStatus 如果不传入，表示查询所有信息，并按照一直的排序规则进行排序
   * @return 
   */
  @ApiOperation(value = "按照分组的状态情况进行查询，并按照分类+名字的方式进行排序（只包括基本信息）")
  @RequestMapping(value="/findByGroupStatus" , method={RequestMethod.GET})
  public ResponseModel findByGroupStatus(@RequestParam(name = "groupStatus" , required = false) @ApiParam(value = "如果不传入，表示查询所有信息，并按照一直的排序规则进行排序" , required = false) Integer groupStatus) {
    try { 
      Set<RuleTemplateGroupEntity> result = this.ruleTemplateGroupEntityService.findByGroupStatus(groupStatus); 
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  }
  @ApiOperation(value = "按照分组的类型进行查询，并按照分类+名字的方式进行排序（只包括基本信息）")
  @RequestMapping(value="/findByType" , method={RequestMethod.GET})
  public ResponseModel findByType(@RequestParam(name = "type" , required = false) @ApiParam(value = "1:判定组件、2、逻辑组件、3、锁组件，4、开始组件、5、结束组件、6、异常组件" , required = false) Integer type) {
    try { 
      Set<RuleTemplateGroupEntity> result = this.ruleTemplateGroupEntityService.findByType(type); 
      return this.buildHttpResultW(result, new String[]{});
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    } 
  } 
} 