/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.mars.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.mars.service.cache.RuntimeDefinition;
import com.bizunited.platform.mars.service.process.RuntimeDefinitionService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/v1/runtimeDefinitions"})
public class RuntimeDefinitionController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuntimeDefinitionController.class);
    @Autowired
    private RuntimeDefinitionService runtimeDefinitionService;

    @ApiOperation(value="\u9488\u5bf9\u4e00\u4e2a\u65b0\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u8fdb\u884c\u521b\u5efa\u64cd\u4f5c\u3002\u6ce8\u610f\uff1a\u521b\u5efa\u64cd\u4f5c\u65f6\uff0c\u89c4\u5219\u5b9a\u4e49\u7684\u57fa\u672c\u4fe1\u606f\u548c\u9644\u5c5e\u4fe1\u606f\uff0c\u90fd\u4e0d\u80fd\u5305\u542bID\u4fe1\u606f\uff0c\u5177\u4f53\u7684\u4fe1\u606f\u7ed3\u6784\u53ef\u53c2\u89c1\u6587\u6863\u793a\u4f8b")
    @PostMapping(value={""})
    public ResponseModel create(@RequestParam(value="runtimeDefinition") @ApiParam(name="runtimeDefinition", value="\u7b26\u5408\u524d\u540e\u7aef\u89c4\u5219\u5b9a\u4e49\u6570\u636e\u7ed3\u6784\u63cf\u8ff0\u7684json\u4fe1\u606f") String runtimeDefinitionJson, @RequestParam(value="file") @ApiParam(name="file", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") MultipartFile file) {
        try {
            byte[] fileContent = file.getBytes();
            RuntimeDefinition definition = (RuntimeDefinition)JSON.toJavaObject((JSON)JSON.parseObject((String)runtimeDefinitionJson), RuntimeDefinition.class);
            definition = this.runtimeDefinitionService.create(definition, fileContent);
            return this.buildHttpResultW(definition, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel error = new ResponseModel();
            error.setErrorMsg("\u9519\u8bef\u7684\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5!!");
            error.setMessage(e.getMessage());
            error.setResponseCode(ResponseCode.E503);
            error.setSuccess(Boolean.valueOf(false));
            return error;
        }
    }

    @ApiOperation(value="\u9488\u5bf9\u4e00\u4e2a\u5df2\u6709\u7684\u89c4\u5219\u5b9a\u4e49\uff0c\u8fdb\u884c\u8be5\u89c4\u5219\u5b9a\u4e49\u7684\u5168\u91cf\u4fee\u6539\u3002\u6240\u8c13\u5168\u91cf\u4fee\u6539\uff0c\u5c31\u662f\u4e4b\u524d\u7684\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f\u4f1a\u5168\u90e8\u4f5c\u5e9f")
    @PatchMapping(value={""})
    public ResponseModel update(@RequestParam(value="runtimeDefinition") @ApiParam(name="runtimeDefinition", value="\u7b26\u5408\u524d\u540e\u7aef\u89c4\u5219\u5b9a\u4e49\u6570\u636e\u7ed3\u6784\u63cf\u8ff0\u7684json\u4fe1\u606f") String runtimeDefinitionJson, @RequestParam(value="file") @ApiParam(name="file", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") MultipartFile file) {
        try {
            byte[] fileContent = file.getBytes();
            RuntimeDefinition definition = (RuntimeDefinition)JSON.toJavaObject((JSON)JSON.parseObject((String)runtimeDefinitionJson), RuntimeDefinition.class);
            definition = this.runtimeDefinitionService.update(definition, fileContent);
            return this.buildHttpResultW(definition, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            ResponseModel error = new ResponseModel();
            error.setErrorMsg("\u9519\u8bef\u7684\u6587\u4ef6\u4e0a\u4f20\u5185\u5bb9\uff0c\u8bf7\u68c0\u67e5!!");
            error.setMessage(e.getMessage());
            error.setResponseCode(ResponseCode.E503);
            error.setSuccess(Boolean.valueOf(false));
            return error;
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u7ed9\u5b9a\u7684\u89c4\u5219\u5b9a\u4e49\u7f16\u53f7\u548c\u7248\u672c\u4fe1\u606f\uff0c\u67e5\u8be2\u5b8c\u6574\u7684\u89c4\u5219\u63cf\u8ff0\u3002\u89c4\u5219\u63cf\u8ff0\u4fe1\u606f\u5c06\u57fa\u4e8e\u6301\u4e45\u5c42\u5b58\u50a8\u7684\u89c4\u5219\u5b9a\u4e49\u4fe1\u606f\u751f\u6210\uff0c\u5e76\u88ab\u7f13\u5b58\u5230\u5185\u5b58\u4e2d")
    @RequestMapping(value={"/findDetailsByCodeAndVersion"}, method={RequestMethod.GET})
    public ResponseModel findDetailsByCodeAndVersion(@RequestParam(value="code") @ApiParam(name="code", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") String code, @RequestParam(value="version") @ApiParam(name="version", value="\u524d\u7aef\u5e03\u5c40\u6587\u4ef6\u6392\u7248\u4fe1\u606f") String version) {
        try {
            RuntimeDefinition result = this.runtimeDefinitionService.findDetailsByCodeAndVersion(code, version);
            return this.buildHttpResultW(result, new String[]{"nodes", "nodes.inputs", "nodes.outputs", "nodes.nexts"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u4e00\u4e2a\u6307\u5b9a\u89c4\u5219\u5b9a\u4e49\u53d1\u8d77\u8bf7\u6c42\u8c03\u7528\uff0c\u4e00\u6b21\u8c03\u7528\u5c06\u4f7f\u7528\u4e00\u4e2a\u72ec\u7acb\u7684ProcessChain\u5bf9\u8c61\u8fdb\u884c\u8c03\u7528\u8fc7\u7a0b\u7ba1\u7406")
    @RequestMapping(value={"/process"}, method={RequestMethod.POST})
    public ResponseModel process(@RequestParam(value="code") String code, @RequestParam(value="version") String version, HttpServletRequest request, HttpServletResponse response) {
        try {
            Object result;
            HashMap<String, Object> inputs = new HashMap<String, Object>();
            Map parameterMap = request.getParameterMap();
            if (parameterMap != null) {
                Set entrySet = parameterMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    String key = (String)entry.getKey();
                    String[] values = (String[])entry.getValue();
                    if (values == null) continue;
                    if (values.length == 1) {
                        inputs.put(key, values[0]);
                        continue;
                    }
                    inputs.put(key, values);
                }
            }
            if ((result = this.runtimeDefinitionService.process(code, version, inputs)) instanceof Collection) {
                Collection results = (Collection)result;
                return this.buildHttpResultW(results, new String[0]);
            }
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

