/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class ParamsAnalysisUtil {
    private static final String[] DATE_PATTERN = new String[]{"yyyy-MM-dd", "yyyy-MM-dd\u00a0HH:mm:ss"};

    private ParamsAnalysisUtil() {
    }

    public static Object[] unwapperArray2(Object source, Object[] args, int index, String key) {
        switch (key) {
            case "[[I": {
                ArrayList a = (ArrayList)source;
                int[][] ier = new int[a.size()][];
                for (int x = 0; x < a.size(); ++x) {
                    if (a.get(x) != null) {
                        ier[x] = new int[((ArrayList)a.get(x)).size()];
                        for (int y = 0; y < ((ArrayList)a.get(x)).size() && ((ArrayList)a.get(x)).get(y) != null; ++y) {
                            ier[x][y] = (Integer)((ArrayList)a.get(x)).get(y);
                        }
                        continue;
                    }
                    ier[x] = new int[0];
                }
                args[index] = ier;
                break;
            }
            case "[[D": {
                ArrayList b = (ArrayList)source;
                double[][] der = new double[b.size()][];
                for (int x = 0; x < b.size(); ++x) {
                    if (b.get(x) != null) {
                        der[x] = new double[((ArrayList)b.get(x)).size()];
                        for (int y = 0; y < ((ArrayList)b.get(x)).size() && ((ArrayList)b.get(x)).get(y) != null; ++y) {
                            der[x][y] = (Double)((ArrayList)b.get(x)).get(y);
                        }
                        continue;
                    }
                    der[x] = new double[0];
                }
                args[index] = der;
                break;
            }
            case "[[J": {
                ArrayList c = (ArrayList)source;
                long[][] ler = new long[c.size()][];
                for (int x = 0; x < c.size(); ++x) {
                    if (c.get(x) != null) {
                        ler[x] = new long[((ArrayList)c.get(x)).size()];
                        for (int y = 0; y < ((ArrayList)c.get(x)).size() && ((ArrayList)c.get(x)).get(y) != null; ++y) {
                            ler[x][y] = (Long)((ArrayList)c.get(x)).get(y);
                        }
                        continue;
                    }
                    ler[x] = new long[0];
                }
                args[index] = ler;
                break;
            }
            case "[[S": {
                ArrayList d = (ArrayList)source;
                short[][] ser = new short[d.size()][];
                for (int x = 0; x < d.size(); ++x) {
                    if (d.get(x) != null) {
                        ser[x] = new short[((ArrayList)d.get(x)).size()];
                        for (int y = 0; y < ((ArrayList)d.get(x)).size() && ((ArrayList)d.get(x)).get(y) != null; ++y) {
                            ser[x][y] = (Short)((ArrayList)d.get(x)).get(y);
                        }
                        continue;
                    }
                    ser[x] = new short[0];
                }
                args[index] = ser;
                break;
            }
            case "[[B": {
                ArrayList e = (ArrayList)source;
                byte[][] ber = new byte[e.size()][];
                for (int x = 0; x < e.size(); ++x) {
                    if (e.get(x) != null) {
                        ber[x] = new byte[((ArrayList)e.get(x)).size()];
                        for (int y = 0; y < ((ArrayList)e.get(x)).size() && ((ArrayList)e.get(x)).get(y) != null; ++y) {
                            ber[x][y] = (Byte)((ArrayList)e.get(x)).get(y);
                        }
                        continue;
                    }
                    ber[x] = new byte[0];
                }
                args[index] = ber;
                break;
            }
            case "[[Z": {
                ArrayList f = (ArrayList)source;
                boolean[][] zer = new boolean[f.size()][];
                for (int x = 0; x < f.size(); ++x) {
                    if (f.get(x) != null) {
                        zer[x] = new boolean[((ArrayList)f.get(x)).size()];
                        for (int y = 0; y < ((ArrayList)f.get(x)).size() && ((ArrayList)f.get(x)).get(y) != null; ++y) {
                            zer[x][y] = (Boolean)((ArrayList)f.get(x)).get(y);
                        }
                        continue;
                    }
                    zer[x] = new boolean[0];
                }
                args[index] = zer;
                break;
            }
            case "[[F": {
                ArrayList g = (ArrayList)source;
                float[][] fer = new float[g.size()][];
                for (int x = 0; x < g.size(); ++x) {
                    if (g.get(x) != null) {
                        fer[x] = new float[((ArrayList)g.get(x)).size()];
                        for (int y = 0; y < ((ArrayList)g.get(x)).size() && ((ArrayList)g.get(x)).get(y) != null; ++y) {
                            fer[x][y] = ((Float)((ArrayList)g.get(x)).get(y)).floatValue();
                        }
                        continue;
                    }
                    fer[x] = new float[0];
                }
                args[index] = fer;
                break;
            }
            case "[[C": {
                ArrayList h = (ArrayList)source;
                char[][] cer = new char[h.size()][];
                for (int x = 0; x < h.size(); ++x) {
                    if (h.get(x) != null) {
                        cer[x] = new char[((ArrayList)h.get(x)).size()];
                        for (int y = 0; y < ((ArrayList)h.get(x)).size() && ((ArrayList)h.get(x)).get(y) != null; ++y) {
                            cer[x][y] = ((Character)((ArrayList)h.get(x)).get(y)).charValue();
                        }
                        continue;
                    }
                    cer[x] = new char[0];
                }
                args[index] = cer;
                break;
            }
            default: {
                return new Object[0];
            }
        }
        return args;
    }

    public static Object[] unwapperArray(Object source, Object[] args, int index, String key) {
        switch (key) {
            case "[I": {
                ArrayList in = (ArrayList)source;
                args[index] = in.stream().mapToInt(Integer::valueOf).toArray();
                break;
            }
            case "[D": {
                ArrayList dou = (ArrayList)source;
                args[index] = dou.stream().mapToDouble(Double::valueOf).toArray();
                break;
            }
            case "[J": {
                ArrayList lo = (ArrayList)source;
                args[index] = lo.stream().mapToLong(Long::valueOf).toArray();
                break;
            }
            case "[S": {
                ArrayList a = (ArrayList)source;
                short[] b = new short[a.size()];
                for (int x = 0; x < a.size(); ++x) {
                    b[x] = (Short)a.get(x);
                }
                args[index] = b;
                break;
            }
            case "[B": {
                ArrayList a1 = (ArrayList)source;
                byte[] b1 = new byte[a1.size()];
                for (int x = 0; x < a1.size(); ++x) {
                    b1[x] = (Byte)a1.get(x);
                }
                args[index] = b1;
                break;
            }
            case "[Z": {
                ArrayList a2 = (ArrayList)source;
                boolean[] b2 = new boolean[a2.size()];
                for (int x = 0; x < a2.size(); ++x) {
                    b2[x] = (Boolean)a2.get(x);
                }
                args[index] = b2;
                break;
            }
            case "[F": {
                ArrayList a3 = (ArrayList)source;
                float[] b3 = new float[a3.size()];
                for (int x = 0; x < a3.size(); ++x) {
                    b3[x] = ((Float)a3.get(x)).floatValue();
                }
                args[index] = b3;
                break;
            }
            case "[C": {
                ArrayList a4 = (ArrayList)source;
                float[] b4 = new float[a4.size()];
                for (int x = 0; x < a4.size(); ++x) {
                    b4[x] = ((Character)a4.get(x)).charValue();
                }
                args[index] = b4;
                break;
            }
            default: {
                return new Object[0];
            }
        }
        return args;
    }

    public static Object[] unwapper(Object source, Object[] args, int index, String key) {
        switch (key) {
            case "int": {
                args[index] = ((Number)source).intValue();
                break;
            }
            case "double": {
                args[index] = ((Number)source).doubleValue();
                break;
            }
            case "long": {
                args[index] = ((Number)source).longValue();
                break;
            }
            case "short": {
                args[index] = ((Number)source).shortValue();
                break;
            }
            case "byte": {
                args[index] = ((Number)source).byteValue();
                break;
            }
            case "float": {
                args[index] = Float.valueOf(((Number)source).floatValue());
                break;
            }
            case "boolean": {
                args[index] = source;
                break;
            }
            case "char": {
                args[index] = source;
                break;
            }
            default: {
                return new Object[0];
            }
        }
        return args;
    }

    public static Object doTrans(Object obj, String mappingType) {
        if (obj == null) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)mappingType)) {
            mappingType = obj.getClass().getName();
        }
        Object returnObj = null;
        boolean typeFlag = obj instanceof String;
        switch (mappingType) {
            case "java.lang.String": {
                returnObj = String.valueOf(obj);
                break;
            }
            case "java.util.Date": {
                if (typeFlag) {
                    try {
                        returnObj = DateUtils.parseDate((String)obj.toString(), (String[])DATE_PATTERN);
                        break;
                    }
                    catch (ParseException e) {
                        throw new IllegalArgumentException("\u4f20\u5165\u53c2\u6570\u4e0d\u80fd\u8f6c\u6362\u4e3a\u65e5\u671f\u7c7b\u578b" + obj.toString() + "\uff0c\u8bf7\u68c0\u67e5!!");
                    }
                }
                Date d = new Date((Long)obj);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                returnObj = df.format(d);
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                returnObj = typeFlag ? Integer.valueOf(obj.toString()).intValue() : ((Number)obj).intValue();
                break;
            }
            case "double": 
            case "java.lang.Double": {
                returnObj = typeFlag ? Double.valueOf(obj.toString()).doubleValue() : ((Number)obj).doubleValue();
                break;
            }
            case "float": 
            case "java.lang.Float": {
                returnObj = Float.valueOf(typeFlag ? Float.valueOf(obj.toString()).floatValue() : ((Number)obj).floatValue());
                break;
            }
            case "long": 
            case "java.lang.Long": {
                returnObj = typeFlag ? Long.valueOf(obj.toString()).longValue() : ((Number)obj).longValue();
                break;
            }
            case "short": 
            case "java.lang.Short": {
                returnObj = typeFlag ? Short.valueOf(obj.toString()).shortValue() : ((Number)obj).shortValue();
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                returnObj = typeFlag ? Byte.valueOf(obj.toString()).byteValue() : ((Number)obj).byteValue();
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                returnObj = typeFlag ? Boolean.valueOf(obj.toString()).booleanValue() : ((Boolean)obj).booleanValue();
                break;
            }
            case "char": 
            case "java.lang.Character": {
                returnObj = obj;
                break;
            }
            default: {
                returnObj = obj;
            }
        }
        return returnObj;
    }
}

