/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.CodeRuleEntity;
import com.bizunited.platform.core.service.CodeRuleService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/codeRules"})
public class CodeRuleController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeRuleController.class);
    @Autowired
    private CodeRuleService codeRuleService;

    @ApiOperation(value="\u6309\u7167\u6761\u4ef6\u641c\u7d22\u7f16\u7801\u751f\u6210\u89c4\u5219\uff0c\u4e0d\u652f\u6301\u6a21\u7cca\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@ApiParam(name="ruleName", value="\u540d\u79f0") String ruleName, @ApiParam(name="ruleCode", value="\u7f16\u7801") String ruleCode, @ApiParam(name="ruleType", value="\u7c7b\u578b") String ruleType, @ApiParam(name="language", value="\u8bed\u8a00") String language, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page<CodeRuleEntity> page = this.codeRuleService.findByConditions(pageable, ruleName, ruleCode, ruleType, language);
            return this.buildHttpReslutW(page, "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u7f16\u7801\u751f\u6210\u89c4\u5219")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219\u4fe1\u606f") @RequestBody CodeRuleEntity entity) {
        LOGGER.debug("\u521b\u5efa\u7f16\u7801\u751f\u6210\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)entity));
        try {
            CodeRuleEntity codeRuleEntity = this.codeRuleService.create(entity);
            return this.buildHttpReslutW(codeRuleEntity, "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u7f16\u7801\u751f\u6210\u89c4\u5219")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219\u4fe1\u606f") @RequestBody CodeRuleEntity entity) {
        LOGGER.debug("\u4fee\u6539\u7f16\u7801\u751f\u6210\u89c4\u5219\uff1a{}", (Object)JSON.toJSONString((Object)entity));
        try {
            CodeRuleEntity codeRuleEntity = this.codeRuleService.update(entity);
            return this.buildHttpReslutW(codeRuleEntity, "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @ApiOperation(value="\u751f\u6210/\u4fee\u6539\u7f16\u7801\u751f\u6210\u89c4\u5219\u811a\u672c\u5185\u5bb9")
    @RequestMapping(value={"/updateContent"}, method={RequestMethod.PATCH})
    public ResponseModel updateContent(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219ID") @RequestParam(name="ruleId") String ruleId, @ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219\u811a\u672c\u5185\u5bb9") @RequestParam(name="content") String content) {
        try {
            return this.buildHttpReslutW(this.codeRuleService.updateContent(ruleId, content), "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u7f16\u7801\u751f\u6210\u89c4\u5219\u811a\u672c\u5185\u5bb9")
    @RequestMapping(value={"/findContentById"}, method={RequestMethod.GET})
    public ResponseModel findContentById(@ApiParam(name="\u7f16\u7801\u751f\u6210\u89c4\u5219ID") @RequestParam(name="ruleId") String ruleId) {
        try {
            String content = this.codeRuleService.findContentById(ruleId);
            return this.buildHttpReslutW(content, "");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpReslutForException(e);
        }
    }
}

