/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerEntity;
import com.bizunited.platform.core.repository.internal.DynamicTaskSchedulerRepositoryCustom;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="DynamicTaskSchedulerRepository")
public interface DynamicTaskSchedulerRepository
extends JpaRepository<DynamicTaskSchedulerEntity, String>,
JpaSpecificationExecutor<DynamicTaskSchedulerEntity>,
DynamicTaskSchedulerRepositoryCustom {
    @Query(value="from DynamicTaskSchedulerEntity dts  left join fetch dts.script where dts.tstatus = :tstatus and dts.workingStatus in (:workingStatuses) order by dts.taskCode ")
    public Set<DynamicTaskSchedulerEntity> findByTstatusAndWorkingStatus(@Param(value="tstatus") int var1, @Param(value="workingStatuses") int[] var2);

    @Query(value="from DynamicTaskSchedulerEntity dts where dts.tstatus = :tstatus  order by dts.taskCode ")
    public Set<DynamicTaskSchedulerEntity> findByTstatus(@Param(value="tstatus") int var1);

    @Query(value="from DynamicTaskSchedulerEntity dts where dts.workingStatus in (:workingStatuses) order by dts.taskCode ")
    public Set<DynamicTaskSchedulerEntity> findByWorkingStatus(@Param(value="workingStatuses") int[] var1);

    @Query(value="from DynamicTaskSchedulerEntity dts where dts.taskCode = :taskCode ")
    public DynamicTaskSchedulerEntity findByTaskCode(@Param(value="taskCode") String var1);

    @Query(value="from DynamicTaskSchedulerEntity dts  left join fetch dts.script sc left join fetch dts.creator c  left join fetch dts.modifier m where dts.taskCode = :taskCode ")
    public DynamicTaskSchedulerEntity findDetailsByTaskCode(@Param(value="taskCode") String var1);

    @Query(value="from DynamicTaskSchedulerEntity dts order by dts.createTime desc ")
    public Set<DynamicTaskSchedulerEntity> findAlls();

    @Modifying
    @Query(value="update engine_dynamic_task set working_status = 1 , t_status = 0 where task_code in (:taskCodes)", nativeQuery=true)
    public void updateInvalidByTaskCode(@Param(value="taskCodes") String[] var1);

    @Modifying
    @Query(value="update engine_dynamic_task set working_status = 2 , t_status = 1 where task_code in (:taskCodes)", nativeQuery=true)
    public void updateRunningByTaskCode(@Param(value="taskCodes") String[] var1);
}

