/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.repository.internal;

import com.bizunited.platform.core.common.constant.ParamClassTypeConst;
import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.entity.ServicableMethodPropertyEntity;
import com.bizunited.platform.core.repository.internal.ServicableMethodRepositoryCustom;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ServicableMethodRepositoryImpl")
public class ServicableMethodRepositoryImpl
implements ServicableMethodRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<ServicableMethodEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
        Object description;
        String hql = "select distinct sm from ServicableMethodEntity sm left join fetch sm.properties smp where 1=1 ";
        String countSql = "select count(*) from engine_service_method sm left join engine_service_method_property smp on sm.id = smp.service_method_id where 1=1 ";
        if (conditions != null && conditions.get("usedScope") != null) {
            hql = hql + " and sm.usedScope = :usedScope ";
            countSql = countSql + " and sm.used_scope = :usedScope ";
        }
        if (conditions != null && conditions.get("name") != null) {
            hql = hql + " and sm.name = :name ";
            countSql = countSql + " and sm.name = :name ";
        }
        if (conditions != null && conditions.get("interfaceName") != null) {
            hql = hql + " and sm.interfaceName = :interfaceName ";
            countSql = countSql + " and sm.interface_name = :interfaceName ";
        }
        if (conditions != null && conditions.get("simpleMethodName") != null) {
            hql = hql + " and sm.simpleMethodName = :simpleMethodName ";
            countSql = countSql + " and sm.simple_method_name = :simpleMethodName ";
        }
        if (conditions != null && conditions.get("returnClassName") != null) {
            hql = hql + " and sm.returnClassName = :returnClassName ";
            countSql = countSql + " and sm.return_classname = :returnClassName ";
        }
        if (conditions != null && conditions.get("propertyClassName") != null) {
            hql = hql + " and smp.paramClass = :propertyClassName ";
            countSql = countSql + " and smp.param_class = :propertyClassName ";
        }
        Object object = description = conditions != null ? conditions.get("description") : null;
        if (description != null) {
            hql = hql + " AND sm.description like CONCAT('%',:description,'%') ";
            countSql = countSql + " AND sm.description like CONCAT('%',:description,'%') ";
        }
        hql = hql + " order by sm.name desc ";
        Query query = this.entityManager.createQuery(hql);
        Query countQuery = this.entityManager.createNativeQuery(countSql);
        if (conditions != null && conditions.get("usedScope") != null) {
            query.setParameter("usedScope", conditions.get("usedScope"));
            countQuery.setParameter("usedScope", conditions.get("usedScope"));
        }
        if (conditions != null && conditions.get("name") != null) {
            query.setParameter("name", conditions.get("name"));
            countQuery.setParameter("name", conditions.get("name"));
        }
        if (conditions != null && conditions.get("interfaceName") != null) {
            query.setParameter("interfaceName", conditions.get("interfaceName"));
            countQuery.setParameter("interfaceName", conditions.get("interfaceName"));
        }
        if (conditions != null && conditions.get("simpleMethodName") != null) {
            query.setParameter("simpleMethodName", conditions.get("simpleMethodName"));
            countQuery.setParameter("simpleMethodName", conditions.get("simpleMethodName"));
        }
        if (conditions != null && conditions.get("returnClassName") != null) {
            query.setParameter("returnClassName", conditions.get("returnClassName"));
            countQuery.setParameter("returnClassName", conditions.get("returnClassName"));
        }
        if (conditions != null && conditions.get("propertyClassName") != null) {
            query.setParameter("propertyClassName", conditions.get("propertyClassName"));
            countQuery.setParameter("propertyClassName", conditions.get("propertyClassName"));
        }
        if (description != null) {
            query.setParameter("description", conditions.get("description"));
            countQuery.setParameter("description", conditions.get("description"));
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List<ServicableMethodEntity> resutls = this.transParamClassType(query.getResultList());
        BigInteger count = (BigInteger)countQuery.getResultList().get(0);
        PageImpl currentPage = new PageImpl(resutls, pageable, (long)count.intValue());
        return currentPage;
    }

    private List<ServicableMethodEntity> transParamClassType(List<ServicableMethodEntity> resutls) {
        for (ServicableMethodEntity method : resutls) {
            if (method.getProperties() == null || method.getProperties().size() <= 0) continue;
            for (ServicableMethodPropertyEntity param : method.getProperties()) {
                if (!ParamClassTypeConst.BASE_CLASS_MAPPING.containsKey(param.getParamClass())) continue;
                param.setParamClass(ParamClassTypeConst.BASE_CLASS_MAPPING.get(param.getParamClass()));
            }
        }
        return resutls;
    }
}

