/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service;

import com.bizunited.platform.saturn.utils.TStringUtils;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.cglib.core.Converter;

public class NebulaToolkitService {
    private static final Logger LOGGER = LoggerFactory.getLogger(NebulaToolkitService.class);

    public <T, R> Set<R> collectionDiffent(Collection<T> targetCollections, Collection<T> resouceCollections, Function<T, R> function) {
        Set<Object> currentTargetCollections = new HashSet();
        Set<Object> currentResouceCollections = new HashSet();
        if (targetCollections != null && !targetCollections.isEmpty()) {
            currentTargetCollections = targetCollections.stream().map(function).collect(Collectors.toSet());
        }
        if (resouceCollections != null && !resouceCollections.isEmpty()) {
            currentResouceCollections = resouceCollections.stream().map(function).collect(Collectors.toSet());
        }
        Sets.SetView differenceItems = Sets.difference(currentTargetCollections, currentResouceCollections);
        return differenceItems;
    }

    public <T, R> Set<R> collectionIntersection(Collection<T> targetCollections, Collection<T> resouceCollections, Function<T, R> function) {
        Set<Object> currentTargetCollections = new HashSet();
        Set<Object> currentResouceCollections = new HashSet();
        if (targetCollections != null && !targetCollections.isEmpty()) {
            currentTargetCollections = targetCollections.stream().map(function).collect(Collectors.toSet());
        }
        if (resouceCollections != null && !resouceCollections.isEmpty()) {
            currentResouceCollections = resouceCollections.stream().map(function).collect(Collectors.toSet());
        }
        Sets.SetView differenceItems = Sets.intersection(currentTargetCollections, currentResouceCollections);
        return differenceItems;
    }

    public <T, E> void collectionDiscrepancy(Collection<E> currentCollections, Collection<E> referenceCollections, Function<E, T> function, Collection<E> deleteCollections, Collection<E> updateCollections, Collection<E> createCollections) {
        Set updateIds;
        Validate.notNull(currentCollections, (String)"\u5f53\u524d\u8fdb\u884cCUD\u64cd\u4f5c\u7c7b\u578b\u62c6\u5206\u7684\u539f\u59cb\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(function, (String)"\u6307\u5b9a\u7684\u53c2\u7167\u51fd\u6570\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(deleteCollections, (String)"\u62c6\u5206\u5206\u6790\u5b8c\u6210\u540e\uff0c\u7528\u4e8e\u627f\u88c5\u201c\u5220\u9664\u6570\u636e\u201d\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(updateCollections, (String)"\u62c6\u5206\u5206\u6790\u5b8c\u6210\u540e\uff0c\u7528\u4e8e\u627f\u88c5\u201c\u4fee\u6539\u6570\u636e\u201d\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notNull(createCollections, (String)"\u62c6\u5206\u5206\u6790\u5b8c\u6210\u540e\uff0c\u7528\u4e8e\u627f\u88c5\u201c\u65b0\u589e\u6570\u636e\u201d\u7684\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.isTrue((referenceCollections.stream().filter(item -> {
            Object result = function.apply(item);
            if (result == null) {
                return true;
            }
            return result instanceof String && StringUtils.isBlank((CharSequence)((String)result));
        }).count() == 0L ? 1 : 0) != 0, (String)"\u5728\u8fdb\u884c\u62c6\u5206\u5206\u6790\u65f6\uff0c\u53c2\u7167\u96c6\u5408referenceCollections\u4e2d\u5404\u5143\u7d20\u9488\u5bf9\u51fd\u6570\u5f0f[function]\u7684\u8fd4\u56de\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set deleteIds = this.collectionDiffent(referenceCollections, currentCollections, function);
        if (deleteIds != null && !deleteIds.isEmpty()) {
            List deleteResult = referenceCollections.stream().filter(currentItem -> deleteIds.contains(function.apply(currentItem))).collect(Collectors.toList());
            deleteCollections.addAll(deleteResult);
        }
        if ((updateIds = this.collectionIntersection(currentCollections, referenceCollections, function)) != null && !updateIds.isEmpty()) {
            List updateResult = referenceCollections.stream().filter(currentItem -> updateIds.contains(function.apply(currentItem))).collect(Collectors.toList());
            updateCollections.addAll(updateResult);
        }
        List createResult1 = currentCollections.stream().filter(item -> {
            Object result = function.apply(item);
            if (result == null) {
                return true;
            }
            return result instanceof String && StringUtils.isBlank((CharSequence)((String)result));
        }).collect(Collectors.toList());
        Set createIds = this.collectionDiffent(currentCollections, referenceCollections, function);
        List createResult2 = null;
        if (createIds != null && !createIds.isEmpty()) {
            createResult2 = currentCollections.stream().filter(currentItem -> createIds.contains(function.apply(currentItem))).collect(Collectors.toList());
        }
        if (createResult1 != null) {
            createCollections.addAll(createResult1);
        }
        if (createResult2 != null) {
            createCollections.addAll(createResult2);
        }
    }

    public <T> T copyObjectByWhiteList(Object sourceObject, Class<T> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String ... propertiesFilter) {
        Validate.notNull((Object)sourceObject, (String)"\u8fdb\u884c\u4e2d\u8003\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6e90\u5bf9\u8c61!!", (Object[])new Object[0]);
        Validate.notNull(targetClass, (String)"\u8fdb\u884c\u4e2d\u8003\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u76ee\u6807\u7c7b\u578b!!", (Object[])new Object[0]);
        Class<?> sourceClass = sourceObject.getClass();
        T targetObject = null;
        try {
            BeanCopier copier = BeanCopier.create(sourceClass, targetClass, (boolean)true);
            PropertyConverter propertyConverter = new PropertyConverter(targetClass, setCollectionClass == null ? LinkedHashSet.class : setCollectionClass, listCollectionClass == null ? ArrayList.class : listCollectionClass, propertiesFilter);
            targetObject = targetClass.newInstance();
            copier.copy(sourceObject, targetObject, (Converter)propertyConverter);
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return targetObject;
    }

    public <S, T> Collection<T> copyCollectionByWhiteList(Iterable<S> sourceCollections, Class<S> sourceClass, Class<T> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String ... propertiesFilter) {
        Validate.notNull(sourceCollections, (String)"\u8fdb\u884c\u4e2d\u8003\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6e90\u96c6\u5408\u5bf9\u8c61!!", (Object[])new Object[0]);
        Validate.notNull(targetClass, (String)"\u8fdb\u884c\u4e2d\u8003\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u76ee\u6807\u7c7b\u578b!!", (Object[])new Object[0]);
        Collection targetCollection = null;
        try {
            targetCollection = Set.class.isAssignableFrom(sourceCollections.getClass()) ? (Collection)setCollectionClass.newInstance() : (Collection)listCollectionClass.newInstance();
            BeanCopier copier = BeanCopier.create(sourceClass, targetClass, (boolean)true);
            PropertyConverter propertyConverter = new PropertyConverter(targetClass, setCollectionClass == null ? LinkedHashSet.class : setCollectionClass, listCollectionClass == null ? ArrayList.class : listCollectionClass, propertiesFilter);
            for (S item : sourceCollections) {
                T targetItem = targetClass.newInstance();
                copier.copy(item, targetItem, (Converter)propertyConverter);
                targetCollection.add(targetItem);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        return targetCollection;
    }

    private class PropertiesFilterNode {
        private String propertyName;
        private Set<PropertiesFilterNode> childproperties = new HashSet<PropertiesFilterNode>();

        public PropertiesFilterNode(String propertyName) {
            this.propertyName = propertyName;
        }

        public PropertiesFilterNode getChildProperty(String propertyName) {
            List resultChilds = this.childproperties.stream().filter(item -> StringUtils.equals((CharSequence)item.getPropertyName(), (CharSequence)propertyName)).collect(Collectors.toList());
            if (resultChilds == null || resultChilds.isEmpty()) {
                return null;
            }
            return (PropertiesFilterNode)resultChilds.get(0);
        }

        private PropertiesFilterNode addAndGetChildProperty(String propertyName) {
            if (StringUtils.isBlank((CharSequence)propertyName)) {
                return null;
            }
            PropertiesFilterNode currentNode = this.getChildProperty(propertyName);
            if (currentNode != null) {
                return currentNode;
            }
            currentNode = new PropertiesFilterNode(propertyName);
            this.childproperties.add(currentNode);
            return currentNode;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    private class PropertyConverter
    implements Converter {
        private Class<?> targetClass;
        private Class<? extends Set> setCollectionClass;
        private Class<? extends List> listCollectionClass;
        private PropertiesFilterNode currentRoot;

        public PropertyConverter(Class<?> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, String[] propertiesFilter) {
            this.currentRoot = new PropertiesFilterNode("");
            this.targetClass = targetClass;
            this.setCollectionClass = setCollectionClass;
            this.listCollectionClass = listCollectionClass;
            this.buildPropertyTree(propertiesFilter);
        }

        private PropertyConverter(Class<?> targetClass, Class<? extends Set> setCollectionClass, Class<? extends List> listCollectionClass, PropertiesFilterNode currentRoot) {
            this.currentRoot = new PropertiesFilterNode("");
            this.targetClass = targetClass;
            this.setCollectionClass = setCollectionClass;
            this.listCollectionClass = listCollectionClass;
            this.currentRoot = currentRoot;
        }

        private void buildPropertyTree(String[] propertiesFilter) {
            for (int index = 0; propertiesFilter != null && index < propertiesFilter.length; ++index) {
                String propertiyItem;
                String propertiyFilterItem = propertiesFilter[index];
                String[] propertiyItemArrays = StringUtils.split((String)propertiyFilterItem, (String)".");
                PropertiesFilterNode currentPropertyNode = this.currentRoot;
                for (int sum = 0; sum < propertiyItemArrays.length && (currentPropertyNode = currentPropertyNode.addAndGetChildProperty(propertiyItem = propertiyItemArrays[sum])) != null; ++sum) {
                }
            }
        }

        public Object convert(Object fieldValue, Class targetFieldClass, Object fieldMethodObject) {
            if (fieldValue == null) {
                return null;
            }
            Validate.notNull((Object)targetFieldClass, (String)"\u8f6c\u6362\u65f6\u76ee\u6807class\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
            Validate.notNull((Object)fieldMethodObject, (String)"\u5143\u5bf9\u8c61\u7684set\u65b9\u6cd5\u5fc5\u987b\u7f16\u5199\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            if (targetFieldClass.isPrimitive() || targetFieldClass == Byte.class || targetFieldClass == Short.class || targetFieldClass == Integer.class || targetFieldClass == Long.class || targetFieldClass == Float.class || targetFieldClass == Double.class || targetFieldClass == Character.class || targetFieldClass == Boolean.class) {
                return fieldValue;
            }
            if (Date.class.isAssignableFrom(targetFieldClass)) {
                return fieldValue;
            }
            String fieldTypeName = targetFieldClass.getName();
            if (StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.lang.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.math.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.io.") || StringUtils.startsWith((CharSequence)fieldTypeName, (CharSequence)"java.text.")) {
                return fieldValue;
            }
            String fieldSetMethodName = fieldMethodObject.toString();
            String fieldGetMethodName = StringUtils.replace((String)fieldSetMethodName, (String)"s", (String)"g", (int)1);
            String fieldName = RegExUtils.replaceFirst((String)fieldGetMethodName, (String)"get", (String)"");
            fieldName = TStringUtils.letterLowercase((String)fieldName);
            PropertiesFilterNode nextFilterNode = null;
            if (this.currentRoot == null) {
                return null;
            }
            if (this.currentRoot != null && (nextFilterNode = this.currentRoot.getChildProperty(fieldName)) == null) {
                return null;
            }
            try {
                if (Collection.class.isAssignableFrom(targetFieldClass)) {
                    return this.convertPersistentCollectionClass(this.targetClass, fieldValue, targetFieldClass, fieldMethodObject, fieldName, nextFilterNode);
                }
                Object result = this.convertPersistentClass(fieldValue, targetFieldClass, fieldMethodObject, nextFilterNode);
                return result;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }

        private Collection convertPersistentCollectionClass(Class<?> targetClass, Object fieldValue, Class targetFieldClass, Object fieldMethodObject, String fieldName, PropertiesFilterNode nextFilterNode) throws NoSuchFieldException, IllegalAccessException, InstantiationException {
            Collection fieldValues = (Collection)fieldValue;
            if (fieldValues.isEmpty()) {
                return null;
            }
            Collection targetFieldValues = null;
            if (Set.class.isAssignableFrom(targetFieldClass)) {
                targetFieldValues = this.setCollectionClass.newInstance();
            } else if (List.class.isAssignableFrom(targetFieldClass)) {
                targetFieldValues = this.listCollectionClass.newInstance();
            } else {
                return null;
            }
            Class targetItemClass = null;
            Field field = targetClass.getDeclaredField(fieldName);
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)genericType;
                targetItemClass = (Class)pt.getActualTypeArguments()[0];
                if (targetItemClass == null) {
                    return null;
                }
                String fieldTypeName = targetItemClass.getName();
                if (StringUtils.isBlank((CharSequence)fieldTypeName)) {
                    return null;
                }
            } else {
                return null;
            }
            for (Object fieldValueItem : fieldValues) {
                Class<?> fieldValueItemClass = fieldValueItem.getClass();
                BeanCopier fieldCopier = BeanCopier.create(fieldValueItemClass, (Class)targetItemClass, (boolean)true);
                Object currentTargetFieldValue = targetItemClass.newInstance();
                fieldCopier.copy(fieldValueItem, currentTargetFieldValue, (Converter)new PropertyConverter(targetItemClass, this.setCollectionClass, this.listCollectionClass, nextFilterNode));
                targetFieldValues.add(currentTargetFieldValue);
            }
            return targetFieldValues;
        }

        private Object convertPersistentClass(Object fieldValue, Class targetFieldClass, Object fieldMethodObject, PropertiesFilterNode nextFilterNode) throws IllegalAccessException, InstantiationException {
            Object currentFieldValue = fieldValue;
            Class<?> currentFieldItemClass = fieldValue.getClass();
            Class currentTargetFieldClass = targetFieldClass;
            Object currentTargetFieldValue = null;
            currentTargetFieldValue = currentTargetFieldClass.newInstance();
            BeanCopier fieldCopier = BeanCopier.create(currentFieldItemClass, (Class)currentTargetFieldClass, (boolean)true);
            fieldCopier.copy(currentFieldValue, currentTargetFieldValue, (Converter)new PropertyConverter(currentTargetFieldClass, LinkedHashSet.class, ArrayList.class, nextFilterNode));
            return currentTargetFieldValue;
        }
    }
}

