/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.common.utils.ParamsAnalysisUtil;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.service.dataview.analysis.SQLAuthHorizontalAnalysis;
import com.bizunited.platform.core.service.dataview.analysis.SQLAuthVerticalAnalysis;
import com.bizunited.platform.core.service.dataview.analysis.SQLConditionFilterAnalysis;
import com.bizunited.platform.core.service.dataview.analysis.SQLOrderbyAnalysis;
import com.bizunited.platform.core.service.dataview.analysis.SQLPageAnalysis;
import com.bizunited.platform.core.service.dataview.analysis.SQLSystemParamAnalysis;
import com.bizunited.platform.core.service.dataview.model.SQLParamModel;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class SQLAnalysis {
    public static final String EMPTY_CHAR = "";
    public static final String SYSTEM_PARAM_PATTERN = "\\{\\:[a-zA-Z]{1}\\w*\\}";
    public static final String ALIAS_STRING = "s01y01s01";
    public static final Integer AUTH_TYPE_COUNT = 5;
    public static final String PLACE_HOLDER = "?";
    private Set<DataViewFieldEntity> allFileds;
    private Pageable pageable;
    private String dbType = "MYSQL";
    private DataViewEntity dataView;
    private Set<DataViewFilterEntity> filters;
    private Set<DataViewSystemEntity> systemParams;
    private Set<DataViewAuthHorizontalEntity> authHorizontals;
    private Set<DataViewAuthVerticalEntity> authVerticals;
    private InvokeParams params;
    private Map<SQLCorrelationEnum, Object> result;

    public SQLAnalysis(DataViewEntity dataView, Set<DataViewFilterEntity> filters, Set<DataViewSystemEntity> systemParams, Set<DataViewAuthHorizontalEntity> authHorizontals, Set<DataViewAuthVerticalEntity> authVerticals, InvokeParams params, Pageable pageable, Set<DataViewFieldEntity> allFileds) {
        this.dataView = dataView;
        this.filters = filters;
        this.systemParams = systemParams;
        this.authHorizontals = authHorizontals;
        this.authVerticals = authVerticals;
        this.allFileds = allFileds;
        this.params = params;
        this.pageable = pageable;
        this.result = SQLAnalysis.initMap();
    }

    private static Map<SQLCorrelationEnum, Object> initMap() {
        HashMap<SQLCorrelationEnum, Object> map = new HashMap<SQLCorrelationEnum, Object>();
        map.put(SQLCorrelationEnum.RESULT_SQL, EMPTY_CHAR);
        map.put(SQLCorrelationEnum.CONDITION_VALUES, new LinkedHashSet(4));
        map.put(SQLCorrelationEnum.SYSTEM_PARAM_VALUES, new LinkedHashSet(4));
        map.put(SQLCorrelationEnum.AUTH_HORIZONTAL_VALUES, new LinkedHashSet(4));
        map.put(SQLCorrelationEnum.AUTH_VERTICAL_VALUES, new LinkedHashSet(4));
        map.put(SQLCorrelationEnum.COUNTER, 1);
        return map;
    }

    public void analysis() {
        this.authVerticalAnalysis(this.dataView.getSourceSql());
        String sql = this.result.get((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        this.systemParamAnalysis(sql);
        this.conditionsAnalysis();
        this.anthHorizontalAnalysis();
        this.orderbyAnalysis();
        this.pageAnalysis();
    }

    private void pageAnalysis() {
        SQLPageAnalysis.pageAnalysis(this.dbType, this.pageable, this.result);
    }

    private void anthHorizontalAnalysis() {
        SQLAuthHorizontalAnalysis.buildSQLAuthHorizoncal(this.authHorizontals, this.result);
    }

    private void authVerticalAnalysis(String sourceSQL) {
        SQLAuthVerticalAnalysis.buildSQLAuthVertical(this.authVerticals, sourceSQL, this.result, this.allFileds);
    }

    private void orderbyAnalysis() {
        SQLOrderbyAnalysis.buildSQLConditionsOrderBy(this.filters, this.params, this.result);
    }

    private void systemParamAnalysis(String sqlOrSourceSQL) {
        SQLSystemParamAnalysis.buildSystemParamAnalysis(this.systemParams, this.params, this.result, sqlOrSourceSQL);
    }

    private void conditionsAnalysis() {
        SQLConditionFilterAnalysis.buildSQLConditions(this.filters, this.result, this.params);
    }

    public Map<SQLCorrelationEnum, Object> getResult() {
        return this.result;
    }

    public void setPresets(Map<String, Object> systems, Map<String, Object> authHorzontals, Map<Integer, Object> verticalPresets) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(systems)) {
            values.putAll(systems);
        }
        if (!CollectionUtils.isEmpty(authHorzontals)) {
            values.putAll(authHorzontals);
        }
        if (!CollectionUtils.isEmpty(verticalPresets)) {
            this.result.put(SQLCorrelationEnum.VERTICAL_PRESETS, verticalPresets);
        }
        this.result.put(SQLCorrelationEnum.PRESETS, values);
    }

    public void processSQLParams(Object object) {
        Validate.notNull((Object)object, (String)"\u4f20\u5165\u7684Query\u6216PreparedStatement\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        LinkedHashSet systemPart = (LinkedHashSet)this.result.get((Object)SQLCorrelationEnum.SYSTEM_PARAM_VALUES);
        LinkedHashSet conditionPart = (LinkedHashSet)this.result.get((Object)SQLCorrelationEnum.CONDITION_VALUES);
        LinkedHashSet authHorizontalPart = (LinkedHashSet)this.result.get((Object)SQLCorrelationEnum.AUTH_HORIZONTAL_VALUES);
        if (!CollectionUtils.isEmpty((Collection)systemPart)) {
            this.setSQLParams(object, systemPart);
        }
        if (!CollectionUtils.isEmpty((Collection)conditionPart)) {
            this.setSQLParams(object, conditionPart);
        }
        if (!CollectionUtils.isEmpty((Collection)authHorizontalPart)) {
            this.setSQLParams(object, authHorizontalPart);
        }
    }

    private void setSQLParams(Object obj, Set<SQLParamModel> params) {
        for (SQLParamModel model : params) {
            Object value = this.transData(model);
            Validate.notNull((Object)value, (String)"\u8f6c\u6362\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            if (obj instanceof Query) {
                SQLAnalysis.matchJPAParamType((Query)obj, value, model);
                continue;
            }
            SQLAnalysis.matchPreparedStatementParamType((PreparedStatement)obj, value, model);
        }
    }

    private Object transData(SQLParamModel model) {
        switch (model.getTransferType()) {
            case 1: 
            case 2: {
                return ParamsAnalysisUtil.doTrans(model.getValue(), model.getMappingType());
            }
            case 3: {
                return this.getPresetByParamName(model);
            }
        }
        return null;
    }

    private Object getPresetByParamName(SQLParamModel model) {
        Map presets = (Map)this.result.get((Object)SQLCorrelationEnum.PRESETS);
        if (CollectionUtils.isEmpty((Map)presets)) {
            return null;
        }
        return presets.remove(model.getParamName() + "|" + model.getSource().getSimpleName());
    }

    public static void matchJPAParamType(Query query, Object value, SQLParamModel model) {
        Validate.notNull((Object)value, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Class<?> clz = value.getClass();
        switch (clz.getName()) {
            case "java.lang.String": {
                try {
                    query.setParameter(model.getIndex().intValue(), (Object)value.toString());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "int": 
            case "java.lang.Integer": {
                try {
                    query.setParameter(model.getIndex().intValue(), (Object)((Number)value).intValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "double": 
            case "java.lang.Double": {
                try {
                    query.setParameter(model.getIndex().intValue(), (Object)((Number)value).doubleValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "float": 
            case "java.lang.Float": {
                try {
                    query.setParameter(model.getIndex().intValue(), (Object)Float.valueOf(((Number)value).floatValue()));
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "long": 
            case "java.lang.Long": {
                try {
                    query.setParameter(model.getIndex().intValue(), (Object)((Number)value).longValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "short": 
            case "java.lang.Short": {
                try {
                    query.setParameter(model.getIndex().intValue(), (Object)((Number)value).shortValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "byte": 
            case "java.lang.Byte": {
                try {
                    query.setParameter(model.getIndex().intValue(), (Object)((Number)value).byteValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "boolean": 
            case "java.lang.Boolean": {
                try {
                    query.setParameter(model.getIndex().intValue(), value);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "char": 
            case "java.lang.Character": {
                try {
                    query.setParameter(model.getIndex().intValue(), (Object)value.toString());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "java.util.Date": {
                try {
                    query.setParameter(model.getIndex().intValue(), value);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "java.math.BigDecimal": {
                try {
                    query.setParameter(model.getIndex().intValue(), value);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            default: {
                throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!\u672a\u77e5\u7684\u7c7b\u578b!!");
            }
        }
    }

    public static void matchPreparedStatementParamType(PreparedStatement st, Object value, SQLParamModel model) {
        Validate.notNull((Object)value, (String)"\u4f20\u5165\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Class<?> clz = value.getClass();
        switch (clz.getName()) {
            case "java.lang.String": {
                try {
                    st.setString(model.getIndex(), value.toString());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "int": 
            case "java.lang.Integer": {
                try {
                    st.setInt(model.getIndex(), ((Number)value).intValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "double": 
            case "java.lang.Double": {
                try {
                    st.setDouble(model.getIndex(), ((Number)value).doubleValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "float": 
            case "java.lang.Float": {
                try {
                    st.setFloat(model.getIndex(), ((Number)value).floatValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "long": 
            case "java.lang.Long": {
                try {
                    st.setLong(model.getIndex(), ((Number)value).longValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "short": 
            case "java.lang.Short": {
                try {
                    st.setShort(model.getIndex(), ((Number)value).shortValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "byte": 
            case "java.lang.Byte": {
                try {
                    st.setByte(model.getIndex(), ((Number)value).byteValue());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "boolean": 
            case "java.lang.Boolean": {
                try {
                    st.setBoolean(model.getIndex(), (Boolean)value);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "char": 
            case "java.lang.Character": {
                try {
                    st.setString(model.getIndex(), value.toString());
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "java.util.Date": {
                try {
                    st.setDate(model.getIndex(), (Date)value);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            case "java.math.BigDecimal": {
                try {
                    st.setBigDecimal(model.getIndex(), (BigDecimal)value);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!");
                }
            }
            default: {
                throw new IllegalArgumentException("SQL\u6267\u884c\u4f20\u5165\u7684\u7684\u53c2\u6570" + model.getParamName() + "\u6709\u8bef!!\u672a\u77e5\u7684\u7c7b\u578b!!");
            }
        }
    }

    public Pageable getPageable() {
        return this.pageable;
    }
}

