/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.service.dataview.analysis.SQLAnalysis;
import com.bizunited.platform.rbac.server.vo.RoleVo;
import com.bizunited.platform.rbac.server.vo.UserGroupVo;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

class SQLAuthVerticalAnalysis {
    private SQLAuthVerticalAnalysis() {
    }

    static void buildSQLAuthVertical(Set<DataViewAuthVerticalEntity> auths, String sql, Map<SQLCorrelationEnum, Object> map, Set<DataViewFieldEntity> allFileds) {
        if (map == null) {
            map = new HashMap<SQLCorrelationEnum, Object>();
        }
        if (CollectionUtils.isEmpty(auths)) {
            map.put(SQLCorrelationEnum.RESULT_SQL, String.format("select %s from (%s) %s where 1=1 ", "*", sql, "s01y01s01"));
            return;
        }
        HashSet<String> finalFieldNames = new HashSet<String>();
        Map presets = (Map)map.get((Object)SQLCorrelationEnum.VERTICAL_PRESETS);
        HashMap<Integer, Set<String>> verticalDispalyFields = new HashMap<Integer, Set<String>>();
        for (int i = 1; i <= SQLAnalysis.AUTH_TYPE_COUNT; ++i) {
            Integer authType = i;
            Set<DataViewAuthVerticalEntity> sameAuths = auths.stream().filter(e -> authType.compareTo(e.getAuthType()) == 0).collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(sameAuths)) continue;
            SQLAuthVerticalAnalysis.processAuths(sameAuths, presets, i, finalFieldNames, verticalDispalyFields, allFileds);
        }
        SQLAuthVerticalAnalysis.processUnion(verticalDispalyFields, map);
        HashSet displayFields = (HashSet)map.get((Object)SQLCorrelationEnum.DISPLAY_FIELDS);
        String verticalFields = String.join((CharSequence)",", displayFields);
        map.put(SQLCorrelationEnum.RESULT_SQL, String.format("select %s from (%s) %s where 1=1 ", verticalFields, sql, "s01y01s01"));
    }

    private static void processUnion(Map<Integer, Set<String>> verticalDispalyFields, Map<SQLCorrelationEnum, Object> map) {
        HashSet userSets = verticalDispalyFields.get(1) == null ? new HashSet() : verticalDispalyFields.get(1);
        HashSet roleSets = verticalDispalyFields.get(2) == null ? new HashSet() : verticalDispalyFields.get(2);
        HashSet positionSets = verticalDispalyFields.get(3) == null ? new HashSet() : verticalDispalyFields.get(3);
        HashSet groupSets = verticalDispalyFields.get(4) == null ? new HashSet() : verticalDispalyFields.get(4);
        HashSet orgSets = verticalDispalyFields.get(5) == null ? new HashSet() : verticalDispalyFields.get(5);
        Sets.SetView v1 = Sets.union(roleSets, userSets);
        Sets.SetView v2 = Sets.union(positionSets, groupSets);
        Sets.SetView v3 = Sets.union((Set)v1.copyInto(new HashSet()), (Set)v2.copyInto(new HashSet()));
        Sets.SetView v4 = Sets.union(orgSets, (Set)v3.copyInto(new HashSet()));
        map.put(SQLCorrelationEnum.DISPLAY_FIELDS, v4.copyInto(new HashSet()));
    }

    private static void processAuths(Set<DataViewAuthVerticalEntity> sameAuths, Map<Integer, Object> presets, Integer index, Set<String> finalFieldNames, Map<Integer, Set<String>> verticalDispalyFields, Set<DataViewFieldEntity> allFileds) {
        for (DataViewAuthVerticalEntity e : sameAuths) {
            Set<DataViewFieldEntity> displayFields = e.getDisplayFields();
            Validate.notNull(displayFields, (String)"\u663e\u793a\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty(displayFields) ? 1 : 0) != 0, (String)"\u7eb5\u5411\u6743\u9650\u4e2d\u6ca1\u6709\u6307\u5b9a\u663e\u793a\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Set<DataViewAuthVerticalRelationEntity> relations = e.getAuthRelations();
            Validate.notNull(relations, (String)"\u6743\u9650\u9886\u57df\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty(relations) ? 1 : 0) != 0, (String)"\u7eb5\u5411\u6743\u9650\u4e2d\u6ca1\u6709\u6307\u5b9a\u6743\u9650\u9886\u57df\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Object o = presets.get(index);
            Validate.isTrue((o != null ? 1 : 0) != 0, (String)"\u7eb5\u5411\u6743\u9650\u5904\u7406\u65f6\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u5f53\u524d\u9884\u5236\u4fe1\u606f\uff01\uff01", (Object[])new Object[0]);
            switch (index) {
                case 1: 
                case 3: 
                case 5: {
                    Boolean flag1 = relations.stream().anyMatch(x -> StringUtils.equals((CharSequence)x.getAuthRelationIds(), (CharSequence)o.toString()));
                    if (!flag1.booleanValue()) break;
                    finalFieldNames.addAll(displayFields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet()));
                    break;
                }
                case 2: {
                    HashSet roles = (HashSet)o;
                    Set roleStrs = roles.stream().map(RoleVo::getId).collect(Collectors.toSet());
                    Set relationStrs = relations.stream().map(UuidEntity::getId).collect(Collectors.toSet());
                    Sets.SetView roleSets = Sets.intersection(roleStrs, relationStrs);
                    Boolean flag2 = CollectionUtils.isEmpty((Collection)roleSets);
                    if (!flag2.booleanValue()) break;
                    finalFieldNames.addAll(displayFields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet()));
                    break;
                }
                case 4: {
                    HashSet groups = (HashSet)o;
                    Set groupStrs = groups.stream().map(UserGroupVo::getId).collect(Collectors.toSet());
                    Set grelationStrs = relations.stream().map(UuidEntity::getId).collect(Collectors.toSet());
                    Sets.SetView groupSets = Sets.intersection(groupStrs, grelationStrs);
                    Boolean flag3 = CollectionUtils.isEmpty((Collection)groupSets);
                    if (!flag3.booleanValue()) break;
                    finalFieldNames.addAll(displayFields.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet()));
                    break;
                }
            }
        }
        if (CollectionUtils.isEmpty(finalFieldNames)) {
            finalFieldNames = allFileds.stream().map(DataViewFieldEntity::getFieldName).collect(Collectors.toSet());
        }
        verticalDispalyFields.put(index, finalFieldNames);
    }
}

