/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import java.util.Map;
import org.springframework.data.domain.Pageable;

class SQLPageAnalysis {
    private SQLPageAnalysis() {
    }

    static void pageAnalysis(String dbType, Pageable pageable, Map<SQLCorrelationEnum, Object> map) {
        if (pageable == null) {
            return;
        }
        String pageSQL = map.remove((Object)SQLCorrelationEnum.RESULT_SQL).toString();
        map.putIfAbsent(SQLCorrelationEnum.PRE_ORDER_PAGE_SQL, pageSQL);
        switch (dbType) {
            case "MYSQL": {
                pageSQL = String.format("%s limit %s,%s", pageSQL, pageable.getPageNumber() * pageable.getPageSize(), pageable.getPageSize());
                break;
            }
            case "ORACLE": {
                pageSQL = "select * from ((select a.*,rownum rn from (" + pageSQL + ") a where a.rn < " + (pageable.getPageNumber() + 1) * pageable.getPageSize() + ") t where t.rn > " + pageable.getPageNumber() * pageable.getPageSize() + ") x";
                break;
            }
            case "SQLSERVER": {
                pageSQL = "select * from (select row_number()over(order by tempColumn) tempRowNumber , * from (\u540e\u671f\u6765\u505a) t ) tt where tempRowNumber > " + pageable.getPageNumber() * pageable.getPageSize();
                break;
            }
            default: {
                throw new UnsupportedOperationException("\u672a\u77e5\u7684\u6570\u636e\u5e93\u7c7b\u578b\uff0c\u6682\u4e0d\u652f\u6301\uff01\uff01");
            }
        }
        map.put(SQLCorrelationEnum.RESULT_SQL, pageSQL);
    }
}

