/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.analysis;

import com.bizunited.platform.core.common.enums.SQLCorrelationEnum;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.service.dataview.model.SQLParamModel;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

class SQLSystemParamAnalysis {
    private SQLSystemParamAnalysis() {
    }

    static void buildSystemParamAnalysis(Set<DataViewSystemEntity> systemFilters, InvokeParams invokeParams, Map<SQLCorrelationEnum, Object> map, String sourceSQL) {
        if (CollectionUtils.isEmpty(systemFilters)) {
            map.put(SQLCorrelationEnum.RESULT_SQL, sourceSQL);
            return;
        }
        Pattern pattern = Pattern.compile("\\{\\:[a-zA-Z]{1}\\w*\\}");
        block5: for (int i = 0; i < systemFilters.size(); ++i) {
            Matcher m = pattern.matcher(sourceSQL);
            String re = null;
            if (m.find()) {
                re = m.group().substring(2, m.group().length() - 1);
            }
            Validate.notBlank(re, (String)"\u6839\u636e\u6b63\u5219\u8868\u8fbe\u5f0f\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u7cfb\u7edf\u53c2\u6570\u4fe1\u606f", (Object[])new Object[0]);
            String systemParamName = re;
            RegExUtils.removeFirst((String)sourceSQL, (Pattern)pattern);
            Optional<DataViewSystemEntity> op = systemFilters.stream().filter(e -> StringUtils.equals((CharSequence)e.getParamName(), (CharSequence)systemParamName)).findFirst();
            DataViewSystemEntity systemEntity = op.orElse(null);
            Validate.notNull((Object)systemEntity, (String)"\u505a\u7cfb\u7edf\u53c2\u6570\u5206\u6790\u65f6\uff0c\u672a\u80fd\u67e5\u8be2\u5230\u7cfb\u7edf\u53c2\u6570\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((systemEntity.getParamSourceType() != null ? 1 : 0) != 0, (String)"\u505a\u7cfb\u7edf\u53c2\u6570\u5206\u6790\u65f6\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u53c2\u6570\u6765\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01\uff01", (Object[])new Object[0]);
            LinkedHashSet values = map.get((Object)SQLCorrelationEnum.SYSTEM_PARAM_VALUES) == null ? (LinkedHashSet)map.get((Object)SQLCorrelationEnum.SYSTEM_PARAM_VALUES) : new LinkedHashSet();
            switch (systemEntity.getParamSourceType()) {
                case 1: {
                    InvokeOperations model = invokeParams.get(systemParamName);
                    Validate.notNull((Object)model, (String)"\u5916\u90e8\u4f20\u5165\u7684\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                    Object compareValue = model.getCompareValue();
                    Validate.notNull((Object)compareValue, (String)"\u5916\u90e8\u4f20\u5165\u7684\u53c2\u6570\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                    sourceSQL = RegExUtils.replacePattern((String)sourceSQL, (String)pattern.toString(), (String)"?");
                    SQLParamModel paramModel = new SQLParamModel();
                    paramModel.setValue(compareValue);
                    paramModel.setParamName(systemEntity.getParamName());
                    paramModel.setParamType(systemEntity.getParamType());
                    paramModel.setTransferType(1);
                    paramModel.setMappingType(model.getMappingType());
                    SQLSystemParamAnalysis.setCouter(paramModel, map);
                    values.add(paramModel);
                    continue block5;
                }
                case 2: {
                    sourceSQL = RegExUtils.replacePattern((String)sourceSQL, (String)pattern.toString(), (String)"?");
                    SQLParamModel paramModel2 = new SQLParamModel();
                    paramModel2.setValue(systemEntity.getParamValue());
                    paramModel2.setParamName(systemEntity.getParamName());
                    paramModel2.setParamType(systemEntity.getParamType());
                    paramModel2.setTransferType(2);
                    paramModel2.setMappingType(systemEntity.getParamType());
                    SQLSystemParamAnalysis.setCouter(paramModel2, map);
                    values.add(paramModel2);
                    continue block5;
                }
                case 3: {
                    sourceSQL = RegExUtils.replacePattern((String)sourceSQL, (String)pattern.toString(), (String)"?");
                    SQLParamModel paramModel3 = new SQLParamModel();
                    paramModel3.setValue(systemEntity.getParamValue());
                    paramModel3.setParamName(systemEntity.getParamName());
                    paramModel3.setParamKey(systemEntity.getParamName());
                    paramModel3.setTransferType(3);
                    paramModel3.setSource(DataViewSystemEntity.class);
                    SQLSystemParamAnalysis.setCouter(paramModel3, map);
                    values.add(paramModel3);
                }
            }
        }
        map.put(SQLCorrelationEnum.RESULT_SQL, sourceSQL);
    }

    private static void setCouter(SQLParamModel spm, Map<SQLCorrelationEnum, Object> map) {
        int count = (Integer)map.remove((Object)SQLCorrelationEnum.COUNTER);
        spm.setIndex(count++);
        map.put(SQLCorrelationEnum.COUNTER, count);
    }
}

