/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalRelationEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthHorizontalRelationRepository;
import com.bizunited.platform.core.repository.dataview.DataViewAuthHorizontalRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalRelationService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewAuthHorizontalServiceImpl")
public class DataViewAuthHorizontalServiceImpl
implements DataViewAuthHorizontalService {
    @Autowired
    private DataViewRepository dataViewRepository;
    @Autowired
    private DataViewAuthHorizontalRepository dataViewAuthHorizontalRepository;
    @Autowired
    private DataViewAuthHorizontalRelationService dataViewAuthHorizontalRelationService;
    @Autowired
    private DataViewAuthHorizontalRelationRepository dataViewAuthHorizontalRelationRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    @Transactional
    public Set<DataViewAuthHorizontalEntity> create(Set<DataViewAuthHorizontalEntity> authHorizontals) {
        Validate.notNull(authHorizontals, (String)"\u4f20\u5165\u7684\u6a2a\u5411\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(authHorizontals) ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6a2a\u5411\u6743\u9650\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (DataViewAuthHorizontalEntity e2 : authHorizontals) {
            this.createValidation(e2);
        }
        this.dataViewAuthHorizontalRepository.saveAll(authHorizontals);
        Set auths = authHorizontals.stream().filter(e -> e.getParamSourceType() == 2).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(auths)) {
            for (DataViewAuthHorizontalEntity e3 : auths) {
                Set<DataViewAuthHorizontalRelationEntity> authRelations = e3.getAuthRelations();
                authRelations.forEach(x -> {
                    x.setAuthHorizontal(e3);
                    this.dataViewAuthHorizontalRelationService.createValidation((DataViewAuthHorizontalRelationEntity)x);
                });
                this.dataViewAuthHorizontalRelationRepository.saveAll(authRelations);
            }
        }
        return authHorizontals;
    }

    @Override
    public void createValidation(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity) {
        Validate.notNull((Object)dataViewAuthHorizontalEntity, (String)"\u6a2a\u5411\u6570\u636e\u6743\u9650\u7684\u5bf9\u8c61\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewAuthHorizontalEntity.getId()), (String)"\u6dfb\u52a0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewAuthHorizontalEntity.setId(null);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getAuthType(), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalEntity.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalEntity.getParamType(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getParamSourceType(), (String)"\u53c2\u6570\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewFieldEntity field = dataViewAuthHorizontalEntity.getField();
        Validate.notNull((Object)field, (String)"\u6dfb\u52a0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u6743\u9650\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DataViewEntity dataView = dataViewAuthHorizontalEntity.getDataView();
        Validate.notNull((Object)dataView, (String)"\u6dfb\u52a0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<DataViewAuthHorizontalRelationEntity> authRelations = dataViewAuthHorizontalEntity.getAuthRelations();
        if (dataViewAuthHorizontalEntity.getParamSourceType() == 2) {
            Validate.isTrue((!CollectionUtils.isEmpty(authRelations) ? 1 : 0) != 0, (String)"\u5f53\u6dfb\u52a0\u6a2a\u5411\u6570\u636e\u6743\u9650\u65f6\uff0c\u53c2\u6570\u6765\u6e90\u662f\u56fa\u5b9a\u503c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6743\u9650\u9886\u57df\u4fe1\u606f!", (Object[])new Object[0]);
        }
        Validate.isTrue((dataViewAuthHorizontalEntity.getOprtType() == null || dataViewAuthHorizontalEntity.getOprtType().length() <= 32 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getParamType() == null || dataViewAuthHorizontalEntity.getParamType().length() <= 64 ? 1 : 0) != 0, (String)"\u53c2\u6570\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getParamKey() == null || dataViewAuthHorizontalEntity.getParamKey().length() <= 64 ? 1 : 0) != 0, (String)"\u9884\u5236\u503c\u6807\u8bc6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public Set<DataViewAuthHorizontalEntity> update(Set<DataViewAuthHorizontalEntity> authHorizontals, String dataViewId) {
        Validate.notBlank((CharSequence)dataViewId, (String)"\u4f20\u5165\u7684\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Optional op = this.dataViewRepository.findById(dataViewId);
        DataViewEntity dataView = op.orElse(null);
        Validate.notNull((Object)dataView, (String)"\u6839\u636e\u89c6\u56feID\uff0c\u6ca1\u6709\u83b7\u53d6\u5230\u76f8\u5e94\u7684\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(authHorizontals)) {
            Set<DataViewAuthHorizontalEntity> authHors = this.dataViewAuthHorizontalRepository.findDetailsByDataView(dataViewId);
            if (!CollectionUtils.isEmpty(authHors)) {
                for (DataViewAuthHorizontalEntity x2 : authHors) {
                    this.dataViewAuthHorizontalRelationRepository.deleteByAuthHorizontal(x2.getId());
                }
                this.dataViewAuthHorizontalRepository.deleteByDataView(dataViewId);
            }
            return Sets.newHashSet();
        }
        Set<DataViewAuthHorizontalEntity> needInsertSets = authHorizontals.stream().filter(e -> StringUtils.isBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        Set needUpdateSets = authHorizontals.stream().filter(e -> StringUtils.isNotBlank((CharSequence)e.getId())).collect(Collectors.toSet());
        Set<DataViewAuthHorizontalEntity> dbAuthHorizoncals = this.dataViewAuthHorizontalRepository.findDetailsByDataView(dataViewId);
        Set<String> needDeleteFieldKeys = this.nebulaToolkitService.collectionDiffent(dbAuthHorizoncals, authHorizontals, UuidEntity::getId);
        if (!CollectionUtils.isEmpty(needInsertSets)) {
            this.create(needInsertSets);
        }
        if (!CollectionUtils.isEmpty(needDeleteFieldKeys)) {
            for (String authHorizontalKey : needDeleteFieldKeys) {
                this.dataViewAuthHorizontalRelationRepository.deleteByAuthHorizontal(authHorizontalKey);
                this.dataViewAuthHorizontalRepository.deleteById(authHorizontalKey);
            }
        }
        if (CollectionUtils.isEmpty(needUpdateSets)) {
            return authHorizontals;
        }
        for (DataViewAuthHorizontalEntity e2 : needUpdateSets) {
            this.updateValidation(e2);
            String currentId = e2.getId();
            Optional opt = this.dataViewAuthHorizontalRepository.findById(currentId);
            DataViewAuthHorizontalEntity currentDataViewAuthHorizontalEntity = opt.orElse(null);
            Validate.notNull((Object)currentDataViewAuthHorizontalEntity, (String)"\u66f4\u65b0\u65f6\uff0c\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u6a2a\u5411\u6743\u9650\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
            currentDataViewAuthHorizontalEntity.setAuthType(e2.getAuthType());
            currentDataViewAuthHorizontalEntity.setOprtType(e2.getOprtType());
            currentDataViewAuthHorizontalEntity.setParamSourceType(e2.getParamSourceType());
            currentDataViewAuthHorizontalEntity.setParamType(e2.getParamType());
            currentDataViewAuthHorizontalEntity.setParamKey(e2.getParamKey());
            currentDataViewAuthHorizontalEntity.setField(e2.getField());
            currentDataViewAuthHorizontalEntity.setDataView(e2.getDataView());
            if (e2.getParamSourceType() != 2) {
                e2.setAuthRelations(null);
            }
            this.dataViewAuthHorizontalRepository.save(currentDataViewAuthHorizontalEntity);
            Set<DataViewAuthHorizontalRelationEntity> authRelations = e2.getAuthRelations();
            if (CollectionUtils.isEmpty(authRelations) && e2.getParamSourceType() == 3) {
                return authHorizontals;
            }
            Set<DataViewAuthHorizontalRelationEntity> needInsertAuthRelations = null;
            Set<DataViewAuthHorizontalRelationEntity> needUpdateAuthRelations = null;
            if (!CollectionUtils.isEmpty(authRelations)) {
                needInsertAuthRelations = authRelations.stream().filter(x -> StringUtils.isBlank((CharSequence)x.getId())).collect(Collectors.toSet());
            }
            if (!CollectionUtils.isEmpty(authRelations)) {
                needUpdateAuthRelations = authRelations.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getId())).collect(Collectors.toSet());
            }
            Set<DataViewAuthHorizontalRelationEntity> dbAuthHorizoncalRelations = this.dataViewAuthHorizontalRelationRepository.findDetailsByAuthHorizontal(currentDataViewAuthHorizontalEntity.getId());
            Set<String> needDeleteAuthHorizoncalRelationKeys = this.nebulaToolkitService.collectionDiffent(dbAuthHorizoncalRelations, authRelations, UuidEntity::getId);
            if (!CollectionUtils.isEmpty(needInsertAuthRelations)) {
                needInsertAuthRelations.forEach(y -> {
                    y.setAuthHorizontal(currentDataViewAuthHorizontalEntity);
                    this.dataViewAuthHorizontalRelationService.createValidation((DataViewAuthHorizontalRelationEntity)y);
                });
                this.dataViewAuthHorizontalRelationRepository.saveAll(needInsertAuthRelations);
            }
            if (!CollectionUtils.isEmpty(needUpdateAuthRelations)) {
                needUpdateAuthRelations.forEach(y -> {
                    y.setAuthHorizontal(currentDataViewAuthHorizontalEntity);
                    this.dataViewAuthHorizontalRelationService.updateValidation((DataViewAuthHorizontalRelationEntity)y);
                });
                this.dataViewAuthHorizontalRelationRepository.saveAll(needUpdateAuthRelations);
            }
            if (CollectionUtils.isEmpty(needDeleteAuthHorizoncalRelationKeys)) continue;
            needDeleteAuthHorizoncalRelationKeys.forEach(x -> this.dataViewAuthHorizontalRelationRepository.deleteById(x));
        }
        return authHorizontals;
    }

    @Override
    public void updateValidation(DataViewAuthHorizontalEntity dataViewAuthHorizontalEntity) {
        Validate.notNull((Object)dataViewAuthHorizontalEntity, (String)"\u66f4\u65b0\u65f6\uff0c\u6a2a\u5411\u6743\u9650\u4fe1\u606f\u5fc5\u987b\u4f20\u5165\uff01\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)dataViewAuthHorizontalEntity.getId()), (String)"\u4fee\u6539\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getParamSourceType(), (String)"\u53c2\u6570\u6765\u6e90\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewAuthHorizontalEntity.getAuthType(), (String)"\u6743\u9650\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalEntity.getOprtType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewAuthHorizontalEntity.getParamType(), (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewFieldEntity field = dataViewAuthHorizontalEntity.getField();
        Validate.notNull((Object)field, (String)"\u66f4\u65b0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u6743\u9650\u5b57\u6bb5\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DataViewEntity dataView = dataViewAuthHorizontalEntity.getDataView();
        Validate.notNull((Object)dataView, (String)"\u66f4\u65b0\u6a2a\u5411\u6570\u636e\u6743\u9650\u4fe1\u606f\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u6570\u636e\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<DataViewAuthHorizontalRelationEntity> authRelations = dataViewAuthHorizontalEntity.getAuthRelations();
        if (dataViewAuthHorizontalEntity.getParamSourceType() == 2) {
            Validate.isTrue((!CollectionUtils.isEmpty(authRelations) ? 1 : 0) != 0, (String)"\u5f53\u4fee\u6539\u6a2a\u5411\u6570\u636e\u6743\u9650\u65f6\uff0c\u53c2\u6570\u6765\u6e90\u662f\u56fa\u5b9a\u503c\u65f6\uff0c\u5fc5\u987b\u4f20\u5165\u5173\u7cfb\u6743\u9650\u96c6\u4fe1\u606f!", (Object[])new Object[0]);
        }
        Validate.isTrue((dataViewAuthHorizontalEntity.getOprtType() == null || dataViewAuthHorizontalEntity.getOprtType().length() < 32 ? 1 : 0) != 0, (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(32)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getParamType() == null || dataViewAuthHorizontalEntity.getParamType().length() < 64 ? 1 : 0) != 0, (String)"\u53c2\u6570\u7c7b\u578b,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewAuthHorizontalEntity.getParamKey() == null || dataViewAuthHorizontalEntity.getParamKey().length() < 64 ? 1 : 0) != 0, (String)"\u9884\u5236\u503c\u6807\u8bc6,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public DataViewAuthHorizontalEntity findDetailsByFieldAndDataView(String field, String dataViewId) {
        if (StringUtils.isBlank((CharSequence)field) || StringUtils.isBlank((CharSequence)dataViewId)) {
            return null;
        }
        return this.dataViewAuthHorizontalRepository.findDetailsByFieldAndDataView(field, dataViewId);
    }

    @Override
    public Set<DataViewAuthHorizontalEntity> findDetailsByDataView(String dataView) {
        if (StringUtils.isBlank((CharSequence)dataView)) {
            return Sets.newHashSet();
        }
        Set<DataViewAuthHorizontalEntity> auths = this.dataViewAuthHorizontalRepository.findDetailsByDataView(dataView);
        Collection<DataViewAuthHorizontalEntity> collection = this.nebulaToolkitService.copyCollectionByWhiteList(auths, DataViewAuthHorizontalEntity.class, DataViewAuthHorizontalEntity.class, HashSet.class, ArrayList.class, "field", "dataView", "authRelations", "authRelations.authHorizontal");
        return (Set)collection;
    }

    @Override
    public DataViewAuthHorizontalEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewAuthHorizontalRepository.findDetailsById(id);
    }

    @Override
    public DataViewAuthHorizontalEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dataViewAuthHorizontalRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewAuthHorizontalRepository.findById(id);
        op.ifPresent(dataViewAuthHorizontalEntity -> this.dataViewAuthHorizontalRepository.delete(dataViewAuthHorizontalEntity));
    }
}

