/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.repository.dataview.DataViewFilterRepository;
import com.bizunited.platform.core.service.dataview.DataViewFilterService;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewFilterEntityServiceImpl")
public class DataViewFilterServiceImpl
implements DataViewFilterService {
    @Autowired
    private DataViewFilterRepository dataViewFilterEntityRepository;

    @Override
    public void createValidation(DataViewFilterEntity dataViewFilterEntity) {
        Validate.notNull((Object)dataViewFilterEntity, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewFilterEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewFilterEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewFilterEntity.getOpType(), (String)"\u64cd\u4f5c\u7b26\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFilterEntity.getSortIndex(), (String)"\u5b57\u6bb5\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFilterEntity.getNullable(), (String)"\u662f\u5426\u53ef\u4ee5\u4e0d\u8fdb\u884c\u9009\u62e9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFilterEntity.getDisplayName(), (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewFilterEntity.getOpType() == null || dataViewFilterEntity.getOpType().length() < 255 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFilterEntity.getDisplayName() == null || dataViewFilterEntity.getDisplayName().length() < 64 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DataViewFilterEntity create(DataViewFilterEntity dataViewFilterEntity, boolean ignoreValidate) {
        if (!ignoreValidate) {
            this.createValidation(dataViewFilterEntity);
        }
        this.dataViewFilterEntityRepository.save(dataViewFilterEntity);
        return dataViewFilterEntity;
    }

    @Override
    @Transactional
    public DataViewFilterEntity update(DataViewFilterEntity dataViewFilterEntity) {
        this.updateValidation(dataViewFilterEntity);
        String currentId = dataViewFilterEntity.getId();
        Optional op = this.dataViewFilterEntityRepository.findById(currentId);
        DataViewFilterEntity currentDataViewFilterEntity = op.orElse(null);
        Validate.notNull((Object)currentDataViewFilterEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1\u606f", (Object[])new Object[0]);
        currentDataViewFilterEntity.setOpType(dataViewFilterEntity.getOpType());
        currentDataViewFilterEntity.setSortIndex(dataViewFilterEntity.getSortIndex());
        currentDataViewFilterEntity.setNullable(dataViewFilterEntity.getNullable());
        currentDataViewFilterEntity.setDisplayName(dataViewFilterEntity.getDisplayName());
        this.dataViewFilterEntityRepository.save(currentDataViewFilterEntity);
        return currentDataViewFilterEntity;
    }

    @Override
    public void updateValidation(DataViewFilterEntity dataViewFilterEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewFilterEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFilterEntity.getOpType(), (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFilterEntity.getSortIndex(), (String)"\u5b57\u6bb5\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewFilterEntity.getNullable(), (String)"\u662f\u5426\u53ef\u4ee5\u4e0d\u8fdb\u884c\u9009\u62e9\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewFilterEntity.getDisplayName(), (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewFilterEntity.getOpType() == null || dataViewFilterEntity.getOpType().length() < 255 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewFilterEntity.getDisplayName() == null || dataViewFilterEntity.getDisplayName().length() < 64 ? 1 : 0) != 0, (String)"\u663e\u793a\u4e2d\u6587\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public List<DataViewFilterEntity> findByDataView(String dataViewId) {
        if (StringUtils.isBlank((CharSequence)dataViewId)) {
            return null;
        }
        return this.dataViewFilterEntityRepository.findByDataView(dataViewId);
    }

    @Override
    public List<DataViewFilterEntity> findByField(String fieldId) {
        if (StringUtils.isBlank((CharSequence)fieldId)) {
            return null;
        }
        return this.dataViewFilterEntityRepository.findByField(fieldId);
    }

    @Override
    public DataViewFilterEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewFilterEntityRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewFilterEntityRepository.findById(id);
        op.ifPresent(dataViewFilterEntity -> this.dataViewFilterEntityRepository.delete(dataViewFilterEntity));
    }

    @Override
    @Transactional
    public void deleteByField(String fieldId) {
        Validate.notBlank((CharSequence)fieldId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9aField\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        List<DataViewFilterEntity> filters = this.dataViewFilterEntityRepository.findByField(fieldId);
        if (!CollectionUtils.isEmpty(filters)) {
            for (DataViewFilterEntity filter : filters) {
                this.dataViewFilterEntityRepository.deleteById(filter.getId());
            }
        }
    }
}

