/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.utils.ChineseCharUtil;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.repository.dataview.DataSourceRepository;
import com.bizunited.platform.core.repository.dataview.DataViewGroupRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepositoryCustom;
import com.bizunited.platform.core.repository.dataview.DataViewThirdDataSourceRepository;
import com.bizunited.platform.core.service.dataview.DataViewGroupService;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewGroupEntityServiceImpl")
public class DataViewGroupServiceImpl
implements DataViewGroupService {
    @Autowired
    private DataViewGroupRepository dataViewGroupEntityRepository;
    @Autowired
    private DataSourceRepository dataSourceRepository;
    @Autowired
    private DataViewRepository dataViewRepository;
    @Autowired
    private DataViewRepositoryCustom dataViewRepositoryCustom;
    @Autowired
    private DataViewThirdDataSourceRepository dataViewThirdDataSourceRepository;

    @Override
    public void createValidation(DataViewGroupEntity dataViewGroupEntity) {
        Validate.notNull((Object)dataViewGroupEntity, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewGroupEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewGroupEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getGroupName(), (String)"\u5206\u7ec4\u540d(\u4e2d\u6587\u540d)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getTargetTable(), (String)"\u57fa\u51c6\u6570\u636e\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewGroupEntity.getGroupName() == null || dataViewGroupEntity.getGroupName().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u7ec4\u540d(\u4e2d\u6587\u540d),\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewGroupEntity.getTargetTable() == null || dataViewGroupEntity.getTargetTable().length() < 64 ? 1 : 0) != 0, (String)"\u57fa\u51c6\u6570\u636e\u8868,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        List<DataViewGroupEntity> existGroups = this.dataViewGroupEntityRepository.findDetails();
        HashSet mainGroups = new HashSet();
        HashSet threeGroups = new HashSet();
        if (CollectionUtils.isEmpty(existGroups)) {
            return;
        }
        existGroups.stream().forEach(e -> {
            if (e.getDataSource() == null) {
                mainGroups.add(e);
            } else {
                threeGroups.add(e);
            }
        });
        if (dataViewGroupEntity.getDataSource() == null) {
            Validate.isTrue((boolean)mainGroups.stream().allMatch(e -> !StringUtils.equals((CharSequence)e.getTargetTable(), (CharSequence)dataViewGroupEntity.getTargetTable())), (String)"\u65b0\u589e\u57fa\u51c6\u8868\u5df2\u5b58\u5728\u4e8e\u4e3b\u6570\u636e\u6e90\u5206\u7ec4:%s,\u8bf7\u68c0\u67e5", (Object[])new Object[]{dataViewGroupEntity.getTargetTable()});
        } else {
            Validate.isTrue((boolean)threeGroups.stream().allMatch(e -> !StringUtils.equals((CharSequence)e.getTargetTable(), (CharSequence)dataViewGroupEntity.getTargetTable())), (String)"\u65b0\u589e\u57fa\u51c6\u8868\u5df2\u5b58\u5728\u4e8e\u6570\u636e\u6e90\u5206\u7ec4:%s,\u8bf7\u68c0\u67e5", (Object[])new Object[]{dataViewGroupEntity.getTargetTable()});
        }
    }

    @Override
    @Transactional
    public DataViewGroupEntity create(DataViewGroupEntity dataViewGroupEntity, boolean ignoreValidate) {
        if (!ignoreValidate) {
            this.createValidation(dataViewGroupEntity);
        }
        if (null != dataViewGroupEntity.getDataSource()) {
            DataSourceEntity dataSource = dataViewGroupEntity.getDataSource();
            Validate.notNull((Object)dataSource.getId(), (String)"\u6240\u9009\u6570\u636e\u6e90ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Optional op = this.dataSourceRepository.findById(dataSource.getId());
            Validate.isTrue((boolean)op.isPresent(), (String)"\u672a\u5728\u6570\u636e\u5e93\u4e2d\u627e\u5230\u7b2c\u4e09\u65b9\u6570\u636e\u6e90", (Object[])new Object[0]);
            Validate.isTrue((!ChineseCharUtil.hasChinese(dataViewGroupEntity.getTargetTable()) ? 1 : 0) != 0, (String)"\u57fa\u51c6\u8868\u8868\u540d\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
        if (null == dataViewGroupEntity.getDataSource()) {
            this.dataViewRepositoryCustom.checkTable(dataViewGroupEntity.getTargetTable());
        } else {
            this.dataViewThirdDataSourceRepository.checkTable(dataViewGroupEntity.getDataSource().getCode(), dataViewGroupEntity.getTargetTable());
        }
        this.dataViewGroupEntityRepository.save(dataViewGroupEntity);
        return dataViewGroupEntity;
    }

    @Override
    @Transactional
    public DataViewGroupEntity update(DataViewGroupEntity dataViewGroupEntity) {
        this.updateValidation(dataViewGroupEntity);
        String currentId = dataViewGroupEntity.getId();
        Optional op = this.dataViewGroupEntityRepository.findById(currentId);
        DataViewGroupEntity currentDataViewGroupEntity = op.orElse(null);
        Validate.notNull((Object)currentDataViewGroupEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentDataViewGroupEntity.setGroupName(dataViewGroupEntity.getGroupName());
        currentDataViewGroupEntity.setTargetTable(dataViewGroupEntity.getTargetTable());
        this.dataViewGroupEntityRepository.saveAndFlush(currentDataViewGroupEntity);
        return currentDataViewGroupEntity;
    }

    @Override
    public void updateValidation(DataViewGroupEntity dataViewGroupEntity) {
        List sameSourceGroups;
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewGroupEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getGroupName(), (String)"\u5206\u7ec4\u540d(\u4e2d\u6587\u540d)\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupEntity.getTargetTable(), (String)"\u57fa\u51c6\u6570\u636e\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewGroupEntity.getGroupName() == null || dataViewGroupEntity.getGroupName().length() < 64 ? 1 : 0) != 0, (String)"\u5206\u7ec4\u540d(\u4e2d\u6587\u540d),\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewGroupEntity.getTargetTable() == null || dataViewGroupEntity.getTargetTable().length() < 64 ? 1 : 0) != 0, (String)"\u57fa\u51c6\u6570\u636e\u8868,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        DataViewGroupEntity dataViewGroup = this.dataViewGroupEntityRepository.findDetailsById(dataViewGroupEntity.getId());
        List<DataViewGroupEntity> existGroups = this.dataViewGroupEntityRepository.findDetails();
        if (!CollectionUtils.isEmpty(existGroups) && !CollectionUtils.isEmpty(sameSourceGroups = existGroups.stream().filter(o -> {
            if (null == dataViewGroup.getDataSource()) {
                return null == o.getDataSource();
            }
            return dataViewGroup.getDataSource().getId().equals(o.getDataSource().getId());
        }).collect(Collectors.toList()))) {
            sameSourceGroups.stream().forEach(o -> Validate.isTrue((!o.getGroupName().equals(dataViewGroupEntity.getGroupName()) ? 1 : 0) != 0, (String)"\u540c\u4e00\u6570\u636e\u6e90\u4e0b\uff0c\u4fee\u6539\u6570\u636e\u89c6\u56fe\u5206\u7ec4\u540d\u4e0d\u80fd\u91cd\u590d\uff01\u8bf7\u68c0\u67e5", (Object[])new Object[0]));
        }
    }

    @Override
    public List<DataViewGroupEntity> findByDataSource(String dataSourceId) {
        if (StringUtils.isBlank((CharSequence)dataSourceId)) {
            return null;
        }
        return this.dataViewGroupEntityRepository.findByDataSource(dataSourceId);
    }

    @Override
    public DataViewGroupEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewGroupEntityRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewGroupEntityRepository.findById(id);
        op.ifPresent(dataViewGroupEntity -> this.dataViewGroupEntityRepository.delete(dataViewGroupEntity));
    }

    @Override
    @Transactional
    public void moveGroup(String dataViewId, String dataViewGroupId) {
        Validate.notBlank((CharSequence)dataViewId, (String)"\u6240\u9009\u89c6\u56feID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroupId, (String)"\u6240\u9009\u65b0\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional opView = this.dataViewRepository.findById(dataViewId);
        Validate.isTrue((boolean)opView.isPresent(), (String)"\u672a\u627e\u5230\u6240\u9009\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        DataViewEntity dataViewEntity = (DataViewEntity)opView.get();
        Optional opGroup = this.dataViewGroupEntityRepository.findById(dataViewGroupId);
        DataViewGroupEntity dataViewGroupEntity = opGroup.orElse(null);
        Validate.notNull((Object)dataViewGroupEntity, (String)"\u672a\u627e\u5230\u6240\u9009\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        dataViewEntity.setDataViewGroup(dataViewGroupEntity);
        this.dataViewRepository.saveAndFlush(dataViewEntity);
    }

    @Override
    public List<DataViewGroupEntity> findByDataSourceCode(String code) {
        List<DataViewGroupEntity> gourpList = null;
        gourpList = StringUtils.isBlank((CharSequence)code) ? this.dataViewGroupEntityRepository.findByDataSource() : this.dataViewGroupEntityRepository.findByDataSourceCode(code);
        return gourpList;
    }

    @Override
    public List<JSONObject> findDetailsByDataSource(String dataSourceId) {
        List<DataViewGroupEntity> firstLayer = null;
        firstLayer = StringUtils.isBlank((CharSequence)dataSourceId) ? this.dataViewGroupEntityRepository.findByDataSource() : this.dataViewGroupEntityRepository.findByDataSource(dataSourceId);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        if (CollectionUtils.isEmpty(firstLayer)) {
            return list;
        }
        for (DataViewGroupEntity group : firstLayer) {
            group.setDataSource(null);
            String jsonStr = JSONObject.toJSONString((Object)group);
            JSONObject json = JSONObject.parseObject((String)jsonStr);
            json.put("title", (Object)group.getGroupName());
            List<DataViewEntity> views = this.dataViewRepository.findByDataViewGroup(group.getId());
            JSONArray jaArray = new JSONArray();
            if (!CollectionUtils.isEmpty(views)) {
                for (DataViewEntity view : views) {
                    view.setDataViewGroup(null);
                    view.setFields(null);
                    view.setFilters(null);
                    view.setSystemFilters(null);
                    view.setDataSource(null);
                    String vs = JSONObject.toJSONString((Object)view);
                    JSONObject jvs = JSONObject.parseObject((String)vs);
                    jvs.put("title", (Object)view.getName());
                    jaArray.add((Object)jvs);
                }
            }
            json.put("children", (Object)jaArray);
            list.add(json);
        }
        return list;
    }
}

