/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.dataview.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.common.utils.ChineseCharUtil;
import com.bizunited.platform.core.entity.DataSourceEntity;
import com.bizunited.platform.core.entity.DataViewAuthHorizontalEntity;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.entity.DataViewEntity;
import com.bizunited.platform.core.entity.DataViewFieldEntity;
import com.bizunited.platform.core.entity.DataViewFilterEntity;
import com.bizunited.platform.core.entity.DataViewGroupEntity;
import com.bizunited.platform.core.entity.DataViewSystemEntity;
import com.bizunited.platform.core.entity.UuidEntity;
import com.bizunited.platform.core.repository.dataview.DataViewAuthHorizontalRelationRepository;
import com.bizunited.platform.core.repository.dataview.DataViewAuthHorizontalRepository;
import com.bizunited.platform.core.repository.dataview.DataViewAuthVerticalRelationRepository;
import com.bizunited.platform.core.repository.dataview.DataViewAuthVerticalRepository;
import com.bizunited.platform.core.repository.dataview.DataViewFieldRepository;
import com.bizunited.platform.core.repository.dataview.DataViewFilterRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepository;
import com.bizunited.platform.core.repository.dataview.DataViewRepositoryCustom;
import com.bizunited.platform.core.repository.dataview.DataViewSystemRepository;
import com.bizunited.platform.core.service.NebulaToolkitService;
import com.bizunited.platform.core.service.dataview.DataSourceService;
import com.bizunited.platform.core.service.dataview.DataViewAuthHorizontalService;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import com.bizunited.platform.core.service.dataview.DataViewFieldService;
import com.bizunited.platform.core.service.dataview.DataViewFilterService;
import com.bizunited.platform.core.service.dataview.DataViewGroupService;
import com.bizunited.platform.core.service.dataview.DataViewService;
import com.bizunited.platform.core.service.dataview.DataViewSystemService;
import com.bizunited.platform.core.service.dataview.analysis.SQLAnalysis;
import com.bizunited.platform.core.service.dataview.analysis.SQLPresetValueAnalysis;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.math.BigInteger;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.AsyncResult;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DataViewEntityServiceImpl")
public class DataViewServiceImpl
implements DataViewService {
    private static Logger LOGGER = LoggerFactory.getLogger(DataViewServiceImpl.class);
    @Autowired
    private DataViewRepository dataViewEntityRepository;
    @Autowired
    private DataViewRepositoryCustom dataViewRepositoryCustom;
    @Autowired
    private DataViewFieldService dataViewFieldService;
    @Autowired
    private DataViewFieldRepository dataViewFieldRepository;
    @Autowired
    private DataViewFilterService dataViewFilterService;
    @Autowired
    private DataViewFilterRepository dataViewFilterRepository;
    @Autowired
    private DataViewSystemRepository dataViewSystemRepository;
    @Autowired
    private DataViewSystemService dataViewSystemService;
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private DataViewGroupService dataViewGroupService;
    @Autowired
    private DataViewAuthHorizontalService dataViewAuthHorizontalService;
    @Autowired
    private DataViewAuthVerticalService dataViewAuthVerticalService;
    @Autowired
    private DataViewAuthHorizontalRepository dataViewAuthHorizontalRepository;
    @Autowired
    private DataViewAuthHorizontalRelationRepository dataViewAuthHorizontalRelationRepository;
    @Autowired
    private DataViewAuthVerticalRelationRepository dataViewAuthVerticalRelationRepository;
    @Autowired
    private DataViewAuthVerticalRepository dataViewAuthVerticalRepository;
    @Autowired
    private SQLPresetValueAnalysis sqlPresetValueAnalysis;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public void createValidation(DataViewEntity dataViewEntity) {
        Validate.notNull((Object)dataViewEntity, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dataViewEntity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        dataViewEntity.setId(null);
        Validate.notBlank((CharSequence)dataViewEntity.getCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DataViewEntity currentEntity = this.dataViewEntityRepository.findByCode(dataViewEntity.getCode());
        Validate.isTrue((null == currentEntity ? 1 : 0) != 0, (String)"\u8be5CODE\u89c6\u56fe\u5df2\u5b58\u5728\uff0c\u8bf7\u6539\u53d8\u7f16\u7801\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getName(), (String)"\u89c6\u56fe\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtil.hasChinese(dataViewEntity.getCode()) ? 1 : 0) != 0, (String)"\u89c6\u56fe\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getSourceSql(), (String)"\u539f\u59cbSQL\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewEntity.getTstatus(), (String)"\u89c6\u56fe\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getCode() == null || dataViewEntity.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getName() == null || dataViewEntity.getName().length() < 64 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getSourceSql() == null || dataViewEntity.getSourceSql().length() < 2048 ? 1 : 0) != 0, (String)"\u539f\u59cbSQL,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(2048)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DataViewEntity create(DataViewEntity dataViewEntity, boolean ignoreValidate) {
        Set<DataViewSystemEntity> systemFilters;
        DataSourceEntity dataSource;
        if (!ignoreValidate) {
            this.createValidation(dataViewEntity);
        }
        if ((dataSource = dataViewEntity.getDataSource()) != null && StringUtils.isNotBlank((CharSequence)dataSource.getId())) {
            DataSourceEntity currentDataSource = this.dataSourceService.findDetailsById(dataSource.getId());
            Validate.notNull((Object)currentDataSource, (String)"\u672a\u627e\u5230\u8be5\u6570\u636e\u6e90!", (Object[])new Object[0]);
        }
        DataViewGroupEntity dataViewGroup = dataViewEntity.getDataViewGroup();
        Validate.notNull((Object)dataViewGroup, (String)"\u89c6\u56fe\u5206\u7ec4\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroup.getId(), (String)"\u89c6\u56fe\u6240\u9009\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        this.dataViewEntityRepository.save(dataViewEntity);
        Set<DataViewFieldEntity> fields = dataViewEntity.getFields();
        Validate.notNull(fields, (String)"\u89c6\u56fe\u7ed3\u6784\u7684\u8f93\u51fa\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(fields) ? 1 : 0) != 0, (String)"\u89c6\u56fe\u7ed3\u6784\u7684\u8f93\u51fa\u5b57\u6bb5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        fields.forEach(e -> {
            this.dataViewFieldService.createValidation((DataViewFieldEntity)e);
            e.setDataView(dataViewEntity);
        });
        Set<DataViewFilterEntity> filters = dataViewEntity.getFilters();
        if (!CollectionUtils.isEmpty(filters)) {
            for (DataViewFilterEntity filter2 : filters) {
                this.dataViewFilterService.createValidation(filter2);
                filter2.setDataView(dataViewEntity);
            }
        }
        if (!CollectionUtils.isEmpty(systemFilters = dataViewEntity.getSystemFilters())) {
            systemFilters.forEach(e -> {
                this.dataViewSystemService.createValidation((DataViewSystemEntity)e);
                e.setDataView(dataViewEntity);
            });
        }
        this.dataViewFieldRepository.saveAll(fields);
        if (filters != null) {
            filters.forEach(filter -> {
                Optional<DataViewFieldEntity> optional = fields.stream().filter(field -> StringUtils.equals((CharSequence)field.getFieldName(), (CharSequence)filter.getField().getFieldName())).findFirst();
                Validate.isTrue((boolean)optional.isPresent(), (String)"\u8fc7\u6ee4\u5b57\u6bb5\u4e2d\uff0c\u672a\u53d1\u73b0\u5b57\u6bb5\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                filter.setField(optional.get());
            });
        }
        this.dataViewFilterRepository.saveAll(filters);
        this.dataViewSystemRepository.saveAll(systemFilters);
        dataViewEntity.setFields(fields);
        dataViewEntity.setFilters(filters);
        dataViewEntity.setSystemFilters(systemFilters);
        return dataViewEntity;
    }

    @Override
    @Transactional
    public DataViewEntity update(DataViewEntity dataViewEntity) {
        Set<String> needDeleteSystemFilterKeys;
        Set<DataViewSystemEntity> systemFilters;
        Set<String> needDeleteFilterKeys;
        Set<DataViewFilterEntity> filters;
        Set<String> needDeleteFieldKeys;
        Set<DataViewFieldEntity> fields;
        this.updateValidation(dataViewEntity);
        String currentId = dataViewEntity.getId();
        Optional op = this.dataViewEntityRepository.findById(currentId);
        DataViewEntity currentDataViewEntity = op.orElse(null);
        Validate.notNull((Object)currentDataViewEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentDataViewEntity.setCode(dataViewEntity.getCode());
        currentDataViewEntity.setName(dataViewEntity.getName());
        currentDataViewEntity.setSourceSql(dataViewEntity.getSourceSql());
        currentDataViewEntity.setTstatus(dataViewEntity.getTstatus());
        DataSourceEntity currentDataSourceEntity = currentDataViewEntity.getDataSource();
        DataSourceEntity dataSource = dataViewEntity.getDataSource();
        Validate.isTrue((currentDataSourceEntity == null && dataSource == null || currentDataSourceEntity != null && dataSource != null ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6570\u636e\u89c6\u56fe\u6570\u636e\u6e90\u4e0e\u539f\u6709\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff01\uff01", (Object[])new Object[0]);
        if (dataSource != null) {
            Validate.isTrue((boolean)StringUtils.equals((CharSequence)dataSource.getId(), (CharSequence)currentDataSourceEntity.getId()), (String)"\u4f20\u5165\u7684\u6570\u636e\u89c6\u56fe\u6570\u636e\u6e90\u4e0e\u539f\u6709\u7684\u6570\u636e\u6e90\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u8fdb\u884c\u66f4\u65b0\u64cd\u4f5c\uff01\uff01", (Object[])new Object[0]);
        }
        DataViewGroupEntity dataViewGroup = dataViewEntity.getDataViewGroup();
        Validate.notNull((Object)dataViewGroup, (String)"\u89c6\u56fe\u6240\u9009\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewGroup.getId(), (String)"\u89c6\u56fe\u6240\u9009\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Set<DataViewAuthHorizontalEntity> hors = this.dataViewAuthHorizontalRepository.findDetailsByDataView(dataViewEntity.getId());
        if (!CollectionUtils.isEmpty(hors)) {
            for (DataViewAuthHorizontalEntity v : hors) {
                this.dataViewAuthHorizontalRelationRepository.deleteByAuthHorizontal(v.getId());
            }
            this.dataViewAuthHorizontalRepository.deleteByDataView(dataViewEntity.getId());
        }
        Validate.isTrue((!CollectionUtils.isEmpty(fields = dataViewEntity.getFields()) ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u89c6\u56fe\u7ed3\u6784\u7684\u8f93\u51fa\u5b57\u6bb5\u4fe1\u606f\u96c6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        fields.forEach(e -> {
            if (StringUtils.isNotBlank((CharSequence)e.getId())) {
                this.dataViewFieldService.updateValidation((DataViewFieldEntity)e);
            } else {
                this.dataViewFieldService.createValidation((DataViewFieldEntity)e);
            }
        });
        Set<Object> dbFields = new LinkedHashSet();
        if (!CollectionUtils.isEmpty(currentDataViewEntity.getFields())) {
            dbFields = currentDataViewEntity.getFields();
        }
        if (!CollectionUtils.isEmpty(needDeleteFieldKeys = this.nebulaToolkitService.collectionDiffent(dbFields, fields, UuidEntity::getId))) {
            needDeleteFieldKeys.forEach(e -> {
                this.dataViewFilterService.deleteByField((String)e);
                Set<DataViewAuthVerticalEntity> vers = this.dataViewAuthVerticalRepository.findDetailsByDataView(dataViewEntity.getId());
                if (!CollectionUtils.isEmpty(vers)) {
                    for (DataViewAuthVerticalEntity v : vers) {
                        this.dataViewAuthVerticalRelationRepository.deleteByAuthVertical(v.getId());
                    }
                    this.dataViewAuthVerticalRepository.deleteByDataView(dataViewEntity.getId());
                }
                this.dataViewFieldService.deleteById((String)e);
            });
        }
        if ((filters = dataViewEntity.getFilters()) == null) {
            filters = new LinkedHashSet<DataViewFilterEntity>();
        } else {
            filters.forEach(e -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getId()})) {
                    this.dataViewFilterService.updateValidation((DataViewFilterEntity)e);
                } else {
                    this.dataViewFilterService.createValidation((DataViewFilterEntity)e);
                }
            });
        }
        Set<DataViewFilterEntity> dbFilters = currentDataViewEntity.getFilters();
        if (CollectionUtils.isEmpty(dbFilters)) {
            dbFilters = new LinkedHashSet<DataViewFilterEntity>();
        }
        if (!CollectionUtils.isEmpty(needDeleteFilterKeys = this.nebulaToolkitService.collectionDiffent(dbFilters, filters, UuidEntity::getId))) {
            needDeleteFilterKeys.forEach(e -> this.dataViewFilterService.deleteById((String)e));
        }
        if (!CollectionUtils.isEmpty(systemFilters = dataViewEntity.getSystemFilters())) {
            systemFilters.forEach(e -> {
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{e.getId()})) {
                    this.dataViewSystemService.updateValidation((DataViewSystemEntity)e);
                } else {
                    this.dataViewSystemService.createValidation((DataViewSystemEntity)e);
                }
            });
        } else {
            systemFilters = new LinkedHashSet<DataViewSystemEntity>();
        }
        Set<DataViewSystemEntity> dbSystemFilters = currentDataViewEntity.getSystemFilters();
        if (CollectionUtils.isEmpty(dbSystemFilters)) {
            dbSystemFilters = new LinkedHashSet<DataViewSystemEntity>();
        }
        if (!CollectionUtils.isEmpty(needDeleteSystemFilterKeys = this.nebulaToolkitService.collectionDiffent(dbSystemFilters, systemFilters, UuidEntity::getId))) {
            needDeleteSystemFilterKeys.forEach(e -> this.dataViewSystemService.deleteById((String)e));
        }
        for (DataViewFieldEntity fieldEntity : fields) {
            fieldEntity.setDataView(currentDataViewEntity);
            if (StringUtils.isBlank((CharSequence)fieldEntity.getId())) {
                this.dataViewFieldService.create(fieldEntity, true);
                continue;
            }
            this.dataViewFieldService.update(fieldEntity);
        }
        filters.forEach(e -> {
            e.setDataView(currentDataViewEntity);
            Optional<DataViewFieldEntity> optional = fields.stream().filter(x -> StringUtils.equals((CharSequence)e.getField().getFieldName(), (CharSequence)x.getFieldName())).findFirst();
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u6ca1\u6709\u627e\u5230\u76f8\u5e94\u7684\u5b57\u6bb5\u4fe1\u606f\u4e0e\u7b5b\u9009\u4fe1\u606f\u76f8\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            e.setField(optional.get());
            if (StringUtils.isBlank((CharSequence)e.getId())) {
                this.dataViewFilterService.create((DataViewFilterEntity)e, true);
            } else {
                this.dataViewFilterService.update((DataViewFilterEntity)e);
            }
        });
        for (DataViewSystemEntity systemFilterEntity : systemFilters) {
            systemFilterEntity.setDataView(currentDataViewEntity);
            if (StringUtils.isBlank((CharSequence)systemFilterEntity.getId())) {
                this.dataViewSystemService.create(systemFilterEntity, true);
                continue;
            }
            this.dataViewSystemService.update(systemFilterEntity);
        }
        currentDataViewEntity.setDataSource(dataSource);
        currentDataViewEntity.setDataViewGroup(dataViewGroup);
        currentDataViewEntity.setFields(fields);
        currentDataViewEntity.setFilters(filters);
        currentDataViewEntity.setSystemFilters(systemFilters);
        this.dataViewEntityRepository.save(currentDataViewEntity);
        return currentDataViewEntity;
    }

    @Override
    public void updateValidation(DataViewEntity dataViewEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dataViewEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u524d\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getCode(), (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getName(), (String)"\u89c6\u56fe\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getSourceSql(), (String)"\u539f\u59cbSQL\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataViewEntity.getTstatus(), (String)"\u89c6\u56fe\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getCode() == null || dataViewEntity.getCode().length() < 64 ? 1 : 0) != 0, (String)"\u6570\u636e\u89c6\u56fe\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getName() == null || dataViewEntity.getName().length() < 64 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u4e2d\u6587\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((dataViewEntity.getSourceSql() == null || dataViewEntity.getSourceSql().length() < 2048 ? 1 : 0) != 0, (String)"\u539f\u59cbSQL,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(2048)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public List<DataViewEntity> findByDataSource(String dataSourceId) {
        if (StringUtils.isBlank((CharSequence)dataSourceId)) {
            return Collections.emptyList();
        }
        return this.dataViewEntityRepository.findByDataSource(dataSourceId);
    }

    @Override
    public List<DataViewEntity> findByDataViewGroup(String dataViewGroupId) {
        if (StringUtils.isBlank((CharSequence)dataViewGroupId)) {
            return Collections.emptyList();
        }
        return this.dataViewEntityRepository.findByDataViewGroup(dataViewGroupId);
    }

    @Override
    public DataViewEntity findByFields(String fieldsId) {
        if (StringUtils.isBlank((CharSequence)fieldsId)) {
            return null;
        }
        return this.dataViewEntityRepository.findByFields(fieldsId);
    }

    @Override
    public DataViewEntity findByFilters(String filtersId) {
        if (StringUtils.isBlank((CharSequence)filtersId)) {
            return null;
        }
        return this.dataViewEntityRepository.findByFilters(filtersId);
    }

    @Override
    public DataViewEntity findBySystemFilters(String systemFiltersId) {
        if (StringUtils.isBlank((CharSequence)systemFiltersId)) {
            return null;
        }
        return this.dataViewEntityRepository.findBySystemFilters(systemFiltersId);
    }

    @Override
    public DataViewEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dataViewEntityRepository.findDetailsById(id);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.dataViewEntityRepository.findById(id);
        op.ifPresent(dataViewEntity -> this.dataViewEntityRepository.delete(dataViewEntity));
    }

    @Override
    @Async(value="dynamicExecutor")
    public Future<?> executeTop1(String dataSourceCode, DataViewEntity dataView, InvokeParams invokeParams, Principal principal) {
        AsyncResult future;
        try {
            SQLAnalysis sqlAnalysis = this.dataViewLogic(dataView, dataSourceCode, principal, invokeParams, null);
            JSONArray jsonArr = this.dataViewRepositoryCustom.executeSQLTop1(dataSourceCode, sqlAnalysis);
            future = new AsyncResult((Object)jsonArr);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            future = new AsyncResult((Object)e);
        }
        return future;
    }

    @Override
    public JSONArray executeTop1(DataViewEntity dataView, InvokeParams invokeParams, Principal principal) {
        SQLAnalysis sqlAnalysis = this.dataViewLogic(dataView, null, principal, invokeParams, (Pageable)PageRequest.of((int)0, (int)1));
        return this.dataViewRepositoryCustom.executeSQLTop1(sqlAnalysis);
    }

    @Override
    @Async(value="dynamicExecutor")
    public Future<?> execute(String dataSourceCode, DataViewEntity dataView, InvokeParams invokeParams, Principal principal) {
        AsyncResult future;
        try {
            SQLAnalysis sqlAnalysis = this.dataViewLogic(dataView, dataSourceCode, principal, invokeParams, null);
            JSONArray jsonArr = this.dataViewRepositoryCustom.executeSQL(dataSourceCode, sqlAnalysis, dataView);
            future = new AsyncResult((Object)jsonArr);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            future = new AsyncResult((Object)e);
        }
        return future;
    }

    @Override
    @Async(value="dynamicExecutor")
    public Future<?> execute(String dataSourceCode, DataViewEntity dataView, InvokeParams invokeParams, Pageable pageable, Principal principal) {
        AsyncResult future;
        try {
            SQLAnalysis sqlAnalysis = this.dataViewLogic(dataView, dataSourceCode, principal, invokeParams, pageable);
            Page<JSONObject> page = this.dataViewRepositoryCustom.executeSQLPageAble(dataSourceCode, sqlAnalysis, pageable);
            future = new AsyncResult(page);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            future = new AsyncResult((Object)e);
        }
        return future;
    }

    @Override
    public Page<JSONObject> execute(DataViewEntity dataView, InvokeParams invokeParams, Pageable pageable, Principal principal) {
        SQLAnalysis sqlAnalysis = this.dataViewLogic(dataView, null, principal, invokeParams, pageable);
        return this.dataViewRepositoryCustom.executeSQLPageAble(sqlAnalysis);
    }

    @Override
    public JSONArray execute(DataViewEntity dataView, InvokeParams invokeParams, Principal principal) {
        SQLAnalysis sqlAnalysis = this.dataViewLogic(dataView, null, principal, invokeParams, null);
        return this.dataViewRepositoryCustom.executeSQL(sqlAnalysis);
    }

    private SQLAnalysis dataViewLogic(DataViewEntity dataView, String dataSourceCode, Principal principal, InvokeParams invokeParams, Pageable pageable) {
        dataView = StringUtils.isBlank((CharSequence)dataSourceCode) ? this.validateMainInfo(dataView) : this.validateThirdInfo(dataSourceCode, dataView);
        Set<DataViewAuthHorizontalEntity> authHorizontals = this.dataViewAuthHorizontalService.findDetailsByDataView(dataView.getId());
        Set<DataViewAuthVerticalEntity> authVerticals = this.dataViewAuthVerticalService.findDetailsByDataView(dataView.getId());
        Map<String, Object> sysPresets = this.sqlPresetValueAnalysis.systemPresetValues(dataView.getSystemFilters(), principal);
        Map<Integer, Object> verticalPresets = this.sqlPresetValueAnalysis.authVerticalPresetValues(authVerticals, principal);
        Map<String, Object> authHorizontalPresets = this.sqlPresetValueAnalysis.authHorizontalPresetValues(authHorizontals, principal);
        Set<DataViewFieldEntity> allFileds = dataView.getFields();
        SQLAnalysis sqlAnalysis = new SQLAnalysis(dataView, dataView.getFilters(), dataView.getSystemFilters(), authHorizontals, authVerticals, invokeParams, pageable, allFileds);
        sqlAnalysis.setPresets(sysPresets, authHorizontalPresets, verticalPresets);
        return sqlAnalysis;
    }

    @Override
    public DataViewEntity executeResource(String dataSourceCode, DataViewEntity dataView) {
        this.checkSQL(dataView);
        return this.dataViewRepositoryCustom.executeResource(dataSourceCode, dataView);
    }

    @Override
    public DataViewEntity executeResource(DataViewEntity dataView) {
        this.checkSQL(dataView);
        return this.dataViewRepositoryCustom.executeResource(dataView);
    }

    private void checkSQL(DataViewEntity dataView) {
        String[] notAllowed = new String[]{"delete", "insert", "drop", "create", "alter", ";"};
        List<String> notAllowedList = Arrays.asList(notAllowed);
        Validate.notNull((Object)dataView, (String)"\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getSourceSql(), (String)"\u539f\u59cbSQL\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String sql = dataView.getSourceSql();
        List<String> words = Arrays.asList(StringUtils.split((String)sql, (String)" "));
        if (!CollectionUtils.isEmpty(words)) {
            Validate.isTrue((boolean)"select".equals(StringUtils.lowerCase((String)words.get(0))), (String)"\u67e5\u8be2\u8bed\u53e5\u53ea\u5141\u8bb8\u4ee5'select'\u8d77\u59cb\u7684\u67e5\u8be2\u8bed\u53e5", (Object[])new Object[0]);
            words.forEach(o -> Validate.isTrue((!notAllowedList.contains(o) ? 1 : 0) != 0, (String)String.format("\u8bed\u53e5\u4e2d\u4e0d\u80fd\u542b\u6709\u5b57\u7b26%s", o), (Object[])new Object[0]));
            Validate.isTrue((!words.get(words.size() - 1).contains(";") ? 1 : 0) != 0, (String)"\u6700\u540e\u4e00\u4e2a\u8bcd\u540e\u4e0d\u80fd\u63a5\u5206\u53f7", (Object[])new Object[0]);
        }
    }

    private DataViewEntity validateThirdInfo(String dataSourceCode, DataViewEntity dataView) {
        DataSourceEntity dataSourceEntity = this.dataSourceService.findDetailsByCode(dataSourceCode);
        Validate.notNull((Object)dataSourceEntity, (String)"\u6839\u636e\u4f20\u5165\u7684code\u503c\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataSourceEntity.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u72b6\u6001\u662f\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)dataView, (String)"\u4f20\u5165\u7684\u89c6\u56fe\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getId(), (String)"\u4f20\u5165\u7684\u89c6\u56fe\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        dataView = this.dataViewEntityRepository.findDetailsById(dataView.getId());
        Validate.notNull((Object)dataView, (String)"\u6839\u636e\u89c6\u56feid\u4fe1\u606f\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataView.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u72b6\u6001\u662f\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notNull((Object)dataView.getDataSource(), (String)"\u5f53\u524d\u6570\u636e\u89c6\u56fe\u4fe1\u606f\u6709\u8bef\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u7b2c\u4e09\u65b9\u6570\u636e\u6e90\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)dataSourceCode, (CharSequence)dataView.getDataSource().getCode()), (String)"\u4f20\u5165\u7684\u6570\u636e\u6e90code\u503c%s\u4e0e\u5f53\u524d\u6570\u636e\u89c6\u56fe\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return dataView;
    }

    private DataViewEntity validateMainInfo(DataViewEntity dataView) {
        Validate.notNull((Object)dataView, (String)"\u4f20\u5165\u7684\u89c6\u56fe\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataView.getId(), (String)"\u4f20\u5165\u7684\u89c6\u56fe\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        dataView = this.dataViewEntityRepository.findDetailsById(dataView.getId());
        Validate.notNull((Object)dataView, (String)"\u6839\u636e\u89c6\u56feid\u4fe1\u606f\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataView.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u89c6\u56fe\u72b6\u6001\u662f\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((dataView.getDataSource() == null ? 1 : 0) != 0, (String)"\u4f20\u5165\u7684\u6570\u636e\u89c6\u56fe\u4e0d\u662f\u4e3b\u6570\u636e\u6e90\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        return dataView;
    }

    @Override
    public JSONArray findByDataSourceCode(String dataSourceCode) {
        List<Object[]> jsonList = null;
        jsonList = StringUtils.isBlank((CharSequence)dataSourceCode) ? this.dataViewEntityRepository.findByDataSourceCode() : this.dataViewEntityRepository.findByDataSourceCode(dataSourceCode);
        JSONArray jsonViewArr = new JSONArray();
        if (!CollectionUtils.isEmpty(jsonList)) {
            jsonList.forEach(e -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("id", (Object)e[0].toString());
                jsonObject.put("code", (Object)e[1].toString());
                jsonObject.put("title", (Object)e[2].toString());
                jsonObject.put("datasourcegroup", (Object)e[3].toString());
                jsonObject.put("outCount", (Object)(e[4] == null ? 0 : ((BigInteger)e[4]).intValue()));
                jsonObject.put("displayCount", (Object)(e[5] == null ? 0 : ((BigInteger)e[5]).intValue()));
                jsonViewArr.add((Object)jsonObject);
            });
        }
        JSONArray groupArr = new JSONArray();
        List<DataViewGroupEntity> groupList = this.dataViewGroupService.findByDataSourceCode(dataSourceCode);
        Validate.notNull(groupList, (String)"\u6839\u636e\u6570\u636e\u6e90code\u503c\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u5206\u7ec4\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        groupList.forEach(e -> {
            JSONObject jsonObject = new JSONObject();
            JSONArray viewArr = new JSONArray();
            jsonObject.put("id", (Object)e.getId());
            jsonObject.put("title", (Object)e.getGroupName());
            jsonObject.put("targetTable", (Object)e.getTargetTable());
            if (!jsonViewArr.isEmpty()) {
                jsonViewArr.stream().filter(view -> StringUtils.equals((CharSequence)e.getId(), (CharSequence)((JSONObject)view).getString("datasourcegroup"))).forEach(arg_0 -> ((JSONArray)viewArr).add(arg_0));
            }
            jsonObject.put("children", (Object)viewArr);
            groupArr.add((Object)jsonObject);
        });
        return groupArr;
    }

    @Override
    public JSONArray findByViewAndDataKey(DataViewEntity dataViewEntity, InvokeParams invokeParams, Principal principal, String primaryKey, JSONArray primaryValue) {
        Validate.notBlank((CharSequence)primaryKey, (String)"\u4f20\u5165\u7684\u89c6\u56feprimaryKey\u552f\u4e00\u6027\u952e\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        if (primaryValue == null) {
            return null;
        }
        Validate.notNull((Object)dataViewEntity, (String)"\u4f20\u5165\u7684\u89c6\u56fe\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dataViewEntity.getId(), (String)"\u6839\u636e\u4f20\u5165\u7684\u89c6\u56fe\u53c2\u6570\uff0c\u672a\u80fd\u83b7\u53d6\u89c6\u56feID\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        DataViewEntity dataView = this.dataViewEntityRepository.findDetailsById(dataViewEntity.getId());
        Validate.notNull((Object)dataView, (String)"\u6839\u636e\u89c6\u56feID\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56fe\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String sql = dataView.getSourceSql();
        Validate.notBlank((CharSequence)sql, (String)"\u672a\u80fd\u83b7\u53d6\u5230\u89c6\u56feSQL\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Map<String, Object> sysPresets = null;
        Set<DataViewSystemEntity> systemEntities = dataView.getSystemFilters();
        if (CollectionUtils.isEmpty(systemEntities)) {
            sysPresets = this.sqlPresetValueAnalysis.systemPresetValues(systemEntities, principal);
        }
        return this.dataViewRepositoryCustom.executeSQLEcho(dataView, invokeParams, sysPresets, primaryKey, primaryValue);
    }
}

