/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.image;

import com.bizunited.platform.core.entity.OrdinaryFileEntity;
import com.bizunited.platform.core.repository.OrdinaryFileRepository;
import com.bizunited.platform.core.service.file.NebulaFileService;
import com.bizunited.platform.core.service.image.FileViewService;
import com.bizunited.platform.core.service.image.ImageHandler;
import com.bizunited.platform.core.service.image.ImageHandlerBuilder;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="imageViewServiceImpl")
public class FileViewServiceImpl
implements FileViewService {
    private static final Log LOGGER = LogFactory.getLog(FileViewServiceImpl.class);
    @Autowired
    private OrdinaryFileRepository ordinaryFileRepository;
    @Autowired
    private NebulaFileService kuiperFileService;

    @Override
    public byte[] fileQuery(String relativeLocal, String fileName) throws IllegalArgumentException, IOException {
        if (relativeLocal == null || StringUtils.isBlank((CharSequence)fileName)) {
            return new byte[0];
        }
        OrdinaryFileEntity ordinaryFile = this.ordinaryFileRepository.findByFileNameAndRelativeLocal(fileName, relativeLocal);
        if (ordinaryFile == null) {
            return new byte[0];
        }
        String prefix = ordinaryFile.getPrefix();
        String originalFileName = ordinaryFile.getOriginalFileName();
        return this.fileContentsQuery(relativeLocal, originalFileName, fileName, "", prefix);
    }

    private byte[] fileContentsQuery(String relativeLocal, String fileName, String fileRename, String special, String prefix) throws IllegalArgumentException, IOException {
        byte[] fileBytes = this.kuiperFileService.readFileContent(relativeLocal, fileRename);
        if (fileBytes == null) {
            return new byte[0];
        }
        if (StringUtils.isBlank((CharSequence)special) || !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"jpeg") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"jpg") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"gif") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"bmp") && !StringUtils.equalsIgnoreCase((CharSequence)prefix, (CharSequence)"png")) {
            return fileBytes;
        }
        String[] specialSteps = special.split("\\-\\>");
        if (specialSteps.length == 0) {
            return fileBytes;
        }
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(fileBytes));
        }
        catch (IOException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        ImageHandlerBuilder.Builder builder = new ImageHandlerBuilder.Builder();
        for (String specialStep : specialSteps) {
            String[] params = specialStep.split("\\|");
            if (StringUtils.equals((CharSequence)params[0], (CharSequence)"cutimage")) {
                this.builderCutAndZoomImageHandle(params, builder, "cutimage");
                continue;
            }
            if (StringUtils.equals((CharSequence)params[0], (CharSequence)"zoomimage")) {
                this.builderCutAndZoomImageHandle(params, builder, "zoomimage");
                continue;
            }
            if (!StringUtils.equals((CharSequence)params[0], (CharSequence)"markimage")) continue;
            this.builderMarkImageHandle(params, builder);
        }
        ImageHandler imageHandle = builder.build();
        BufferedImage imageResults = imageHandle.dispose(bufferedImage);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)imageResults, prefix, out);
        byte[] imageBytes = out.toByteArray();
        return imageBytes;
    }

    @Override
    public byte[] imageQuery(String folder, String imageFile, String prefix, String special) throws IOException {
        String relativePath = folder;
        String fileName = imageFile + "." + prefix;
        return this.fileContentsQuery(relativePath, fileName, fileName, special, prefix);
    }

    private void builderMarkImageHandle(String[] params, ImageHandlerBuilder.Builder builder) {
        String markValue = null;
        Integer fontSize = 20;
        for (String param : params) {
            String[] paramVars = param.split("=");
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"markValue")) {
                markValue = paramVars[1];
            }
            if (!StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"fontSize")) continue;
            fontSize = Integer.parseInt(paramVars[1]);
        }
        if (StringUtils.isEmpty(markValue)) {
            throw new IllegalArgumentException("markValue must be set value!");
        }
        builder.createMarkHandler(markValue, fontSize);
    }

    private void builderCutAndZoomImageHandle(String[] params, ImageHandlerBuilder.Builder builder, String opType) {
        Integer width = null;
        Integer height = null;
        Float ratio = null;
        for (String param : params) {
            String[] paramVars = param.split("=");
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"width")) {
                width = Integer.parseInt(paramVars[1]);
                continue;
            }
            if (StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"height")) {
                height = Integer.parseInt(paramVars[1]);
                continue;
            }
            if (!StringUtils.equals((CharSequence)paramVars[0], (CharSequence)"ratio")) continue;
            ratio = Float.valueOf(Float.parseFloat(paramVars[1]));
        }
        if (ratio != null && (ratio.floatValue() <= 0.0f || ratio.floatValue() >= 1.0f)) {
            throw new IllegalArgumentException("ratio must between from 0 to 1!");
        }
        if (ratio == null && (width == null || height == null)) {
            throw new IllegalArgumentException("width and height must be set value!");
        }
        if (ratio != null && StringUtils.equals((CharSequence)opType, (CharSequence)"cutimage")) {
            builder.createCutHandler(ratio.floatValue());
        } else if (ratio != null && StringUtils.equals((CharSequence)opType, (CharSequence)"zoomimage")) {
            builder.createZoomHandler(ratio.floatValue());
        } else if (ratio == null && StringUtils.equals((CharSequence)opType, (CharSequence)"cutimage")) {
            builder.createCutHandler(width, height);
        } else if (ratio == null && StringUtils.equals((CharSequence)opType, (CharSequence)"zoomimage")) {
            builder.createZoomHandler(width, height);
        }
    }

    @Override
    public OrdinaryFileEntity findByFileNameAndRelativeLocal(String fileName, String relativeLocal) {
        if (relativeLocal == null || StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        return this.ordinaryFileRepository.findByFileNameAndRelativeLocal(fileName, relativeLocal);
    }
}

