/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.scheduler;

import com.bizunited.platform.core.entity.DynamicTaskSchedulerLogEntity;
import com.bizunited.platform.core.repository.DynamicTaskSchedulerLogRepository;
import com.bizunited.platform.core.service.DynamicTaskSchedulerLogService;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="DynamicTaskSchedulerLogServiceImpl")
public class DynamicTaskSchedulerLogServiceImpl
implements DynamicTaskSchedulerLogService {
    @Autowired
    private DynamicTaskSchedulerLogRepository dynamicTaskSchedulerLogRepository;

    @Override
    @Transactional
    public DynamicTaskSchedulerLogEntity create(DynamicTaskSchedulerLogEntity log) {
        DynamicTaskSchedulerLogEntity current = this.createForm(log);
        return current;
    }

    @Override
    @Transactional
    public DynamicTaskSchedulerLogEntity createForm(DynamicTaskSchedulerLogEntity log) {
        this.createValidation(log);
        this.dynamicTaskSchedulerLogRepository.save(log);
        return log;
    }

    private void createValidation(DynamicTaskSchedulerLogEntity log) {
        Validate.notNull((Object)log, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)log.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        log.setId(null);
        Validate.notNull((Object)log.getStartTime(), (String)"\u6267\u884c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)log.getEndTime(), (String)"\u6267\u884c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)log.getSuccess(), (String)"\u6267\u884c\u662f\u5426\u6210\u529f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((log.getErrorContents() == null || log.getErrorContents().length() < 512 ? 1 : 0) != 0, (String)"\u53ef\u80fd\u7684\u9519\u8bef\u65e5\u5fd7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public DynamicTaskSchedulerLogEntity update(DynamicTaskSchedulerLogEntity dynamicTaskSchedulerLogEntity) {
        DynamicTaskSchedulerLogEntity current = this.updateForm(dynamicTaskSchedulerLogEntity);
        return current;
    }

    @Override
    @Transactional
    public DynamicTaskSchedulerLogEntity updateForm(DynamicTaskSchedulerLogEntity log) {
        this.updateValidation(log);
        String currentId = log.getId();
        Optional op = this.dynamicTaskSchedulerLogRepository.findById(currentId);
        DynamicTaskSchedulerLogEntity currentDynamicTaskSchedulerLogEntity = op.orElse(null);
        Validate.notNull((Object)currentDynamicTaskSchedulerLogEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentDynamicTaskSchedulerLogEntity.setStartTime(log.getStartTime());
        currentDynamicTaskSchedulerLogEntity.setEndTime(log.getEndTime());
        currentDynamicTaskSchedulerLogEntity.setSuccess(log.getSuccess());
        currentDynamicTaskSchedulerLogEntity.setErrorContents(log.getErrorContents());
        currentDynamicTaskSchedulerLogEntity.setDynamicTaskScheduler(log.getDynamicTaskScheduler());
        this.dynamicTaskSchedulerLogRepository.saveAndFlush(currentDynamicTaskSchedulerLogEntity);
        return currentDynamicTaskSchedulerLogEntity;
    }

    private void updateValidation(DynamicTaskSchedulerLogEntity dynamicTaskSchedulerLogEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)dynamicTaskSchedulerLogEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dynamicTaskSchedulerLogEntity.getStartTime(), (String)"\u6267\u884c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dynamicTaskSchedulerLogEntity.getEndTime(), (String)"\u6267\u884c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dynamicTaskSchedulerLogEntity.getSuccess(), (String)"\u6267\u884c\u662f\u5426\u6210\u529f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((dynamicTaskSchedulerLogEntity.getErrorContents() == null || dynamicTaskSchedulerLogEntity.getErrorContents().length() < 512 ? 1 : 0) != 0, (String)"\u53ef\u80fd\u7684\u9519\u8bef\u65e5\u5fd7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(512)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public Set<DynamicTaskSchedulerLogEntity> findDetailsByDynamicTaskScheduler(String dynamicTaskScheduler) {
        if (StringUtils.isBlank((CharSequence)dynamicTaskScheduler)) {
            return null;
        }
        return this.dynamicTaskSchedulerLogRepository.findDetailsByDynamicTaskScheduler(dynamicTaskScheduler);
    }

    @Override
    public DynamicTaskSchedulerLogEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.dynamicTaskSchedulerLogRepository.findDetailsById(id);
    }

    @Override
    public DynamicTaskSchedulerLogEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dynamicTaskSchedulerLogRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public Page<DynamicTaskSchedulerLogEntity> findByConditions(Pageable pageable, String taskId, Boolean success, String logtime) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        Validate.notBlank((CharSequence)taskId, (String)"\u67e5\u8be2\u65f6\uff0c\u4efb\u52a1id\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        conditions.put("taskId", taskId);
        if (success != null) {
            conditions.put("success", success);
        }
        if (StringUtils.isNotBlank((CharSequence)logtime)) {
            conditions.put("logtime", logtime);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        return this.dynamicTaskSchedulerLogRepository.queryPage(pageable, conditions);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional current = this.dynamicTaskSchedulerLogRepository.findById(id);
        if (current.isPresent()) {
            this.dynamicTaskSchedulerLogRepository.delete(current.get());
        }
    }
}

