/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.script;

import com.bizunited.platform.core.repository.ScriptRepository;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.script.model.ScriptInputParamsModel;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="JavaServiceInputHandle")
public class JavaServiceInputHandle
implements InvokeRequestHandle {
    @Autowired
    private ScriptRepository scriptRepository;

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        ScriptInputParamsModel model = (ScriptInputParamsModel)context.getChainParam("scriptInputParamsModel");
        Validate.notNull((Object)model, (String)"\u4f20\u5165groovy\u53d8\u91cf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        List<String> scriptIds = model.getScriptIds();
        Validate.notEmpty(model.getScriptIds(), (String)"\u4f20\u5165\u811a\u672cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        context.setChainParam("scriptIds", scriptIds);
        for (String id : scriptIds) {
            Optional op = this.scriptRepository.findById(id);
            Validate.isTrue((boolean)op.isPresent(), (String)"\u4f20\u5165groovy\u811a\u672cid\u672a\u80fd\u67e5\u8be2\u5230\u5b9e\u4f53\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        }
        Validate.notEmpty(scriptIds, (String)"\u4f20\u5165groovy\u811a\u672cid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Set<String> keys = model.keySet();
        if (!CollectionUtils.isEmpty(keys)) {
            for (String key : keys) {
                context.setChainParam(key, model.getParams(key));
            }
        }
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }
}

