/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.script;

import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.core.service.script.model.ScriptInputParamsModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="GroovyScriptExecuteHandle")
public class ScriptExecuteHandle
implements InvokeRequestHandle {
    @Autowired
    private ScriptService scriptService;

    @Override
    public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
        ScriptInputParamsModel model = (ScriptInputParamsModel)context.getChainParam("scriptInputParamsModel");
        Validate.notNull((Object)model, (String)"\u4f20\u5165groovy\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(model.getScriptIds(), (String)"\u4f20\u5165groovy\u5165\u53c2\u4e2d\u811a\u672cID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        for (String scriptId : model.getScriptIds()) {
            Map<String, Object> result;
            HashMap<String, Object> currentContextParams = new HashMap<String, Object>();
            Set<String> contextKey = context.getParamKeys();
            if (!CollectionUtils.isEmpty(contextKey)) {
                for (String key : contextKey) {
                    currentContextParams.put(key, context.getChainParam(key));
                }
            }
            if (CollectionUtils.isEmpty(result = this.scriptService.invoke(scriptId, currentContextParams))) continue;
            for (String key : result.keySet()) {
                context.setChainParam(key, result.get(key));
            }
        }
        chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
    }
}

