/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.core.service.serviceable.model;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.model.InvokeOperations;
import com.bizunited.platform.core.service.invoke.model.InvokeParams;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class InputParamsModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String serviceName;
    private Map<String, Object> params;
    private Map<String, Object> customData;
    private List<InvokeOperations> filterParams;
    private JSONObject formData;
    private String instanceActivityId;

    public boolean isFilterParamsExist() {
        return this.filterParams == null ? false : !this.filterParams.isEmpty();
    }

    public void fill(InvokeParams params) {
        if (params == null) {
            return;
        }
        this.filterParams.forEach(e -> params.add(e.getParamName(), (InvokeOperations)e, false));
    }

    public Set<String> transAndKeys() {
        HashSet<String> keys = new HashSet<String>();
        if (this.isFilterParamsExist()) {
            for (int index = 0; index < this.filterParams.size(); ++index) {
                this.checkValid(this.filterParams.get(index));
                this.trans(this.filterParams.get(index), index);
                keys.add(this.filterParams.get(index).getParamName());
            }
        }
        return keys;
    }

    public void checkValid(InvokeOperations model) {
        Validate.notNull((Object)model, (String)"\u4f20\u5165\u7684\u7b5b\u9009\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)model.getParamName(), (String)"\u4f20\u5165\u7684\u53c2\u6570\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        if (InvokeOperations.isRegionOprt(model.getOprtType()) || InvokeOperations.isBetweenOprt(model.getOprtType())) {
            Validate.notNull((Object)model.getCompareValue(), (String)"\u533a\u95f4\u8303\u56f4\u4ee5\u53cabetween\u7b5b\u9009\u6761\u4ef6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
            Validate.isTrue((boolean)(model.getCompareValue() instanceof List), (String)"\u533a\u95f4\u8303\u56f4\u4ee5\u53cabetween\u7b5b\u9009\u6761\u4ef6\uff0c\u8bf7\u7528\u6570\u7ec4\u65b9\u5f0f\u4f20\u9012\uff01\uff01", (Object[])new Object[0]);
            List list = (List)model.getCompareValue();
            Validate.isTrue((list.size() == 2 ? 1 : 0) != 0, (String)"\u533a\u95f4\u8303\u56f4\u4ee5\u53cabetween\u7b5b\u9009\u6761\u4ef6\uff0c\u6570\u7ec4\u957f\u5ea6\u4e0d\u4e3a2\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            list.forEach(e -> Validate.notNull((Object)e, (String)"\u533a\u95f4\u8303\u56f4\u4ee5\u53cabetween\u7b5b\u9009\u6761\u4ef6\u4f20\u5165\u7684\u7b5b\u9009\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]));
        } else if (InvokeOperations.isInOprt(model.getOprtType())) {
            Validate.notNull((Object)model.getCompareValue(), (String)"IN\u64cd\u4f5c\u7684\u7b5b\u9009\u6761\u4ef6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01", (Object[])new Object[0]);
            if (model.getCompareValue() instanceof List) {
                List list = (List)model.getCompareValue();
                Validate.isTrue((list.size() >= 1 ? 1 : 0) != 0, (String)"IN\u64cd\u4f5c\u7684\u7b5b\u9009\u6761\u4ef6\uff0c\u6570\u7ec4\u957f\u5ea6\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e1\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
                list.forEach(e -> Validate.notNull((Object)e, (String)"IN\u7b5b\u9009\u6761\u4ef6\u4f20\u5165\u7684\u7b5b\u9009\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]));
            }
        } else if (!(StringUtils.equalsIgnoreCase((CharSequence)model.getSortType(), (CharSequence)InvokeParams.SortType.ASC.name()) || StringUtils.equalsIgnoreCase((CharSequence)model.getSortType(), (CharSequence)InvokeParams.SortType.DESC.name()) || InvokeOperations.nullOprt(model.getOprtType()) || InvokeOperations.KEYWORD.contains(model.getOprtType()))) {
            Validate.notNull((Object)model.getCompareValue(), (String)"\u4f20\u5165\u7684\u7b5b\u9009\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
    }

    public void trans(InvokeOperations model, int index) {
        if (StringUtils.isNotBlank((CharSequence)model.getSortType())) {
            model.setSortIndex(index);
        }
        if (StringUtils.isBlank((CharSequence)model.getOprtType()) && model.getCompareValue() != null) {
            model.setOprtType(InvokeParams.OprtCharType.EQ.name());
        }
    }

    public String getInstanceActivityId() {
        return this.instanceActivityId;
    }

    public void setInstanceActivityId(String instanceActivityId) {
        this.instanceActivityId = instanceActivityId;
    }

    public List<InvokeOperations> getFilterParams() {
        return this.filterParams;
    }

    public void setFilterParams(List<InvokeOperations> filterParams) {
        this.filterParams = filterParams;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public Map<String, Object> getCustomData() {
        return this.customData;
    }

    public void setCustomData(Map<String, Object> customData) {
        this.customData = customData;
    }

    public JSONObject getFormData() {
        return this.formData;
    }

    public void setFormData(JSONObject formData) {
        this.formData = formData;
    }
}

