package com.bizunited.platform.core.common;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

/**
 * 平台上下文工具
 * @author yinwenjie
 */
@Component("PlatformContext")
public class PlatformContext implements ApplicationContextAware {

  /**
   * 应用上下文,spring容器初始化后自动设置
   */
  private static ApplicationContext applicationContext;

  /**
   * 技术中台实例是否成功启动了kuiper表单引擎子系统
   */
  private boolean enableKuiper = false;
  
  /**
   * 技术中台实例是否成功启动了titan流程引擎子系统
   */
  private boolean enableTitan = false;

  /**
   * 技术中台实例是否成功启动了kuiper表单引擎子系统
   * @return
   */
  public boolean isEnableKuiper() {
    return enableKuiper;
  }

  public void setEnableKuiper(boolean enableKuiper) {
    this.enableKuiper = enableKuiper;
  }

  /**
   * 技术中台实例是否成功启动了titan流程引擎子系统
   * @return
   */
  public boolean isEnableTitan() {
    return enableTitan;
  }

  public void setEnableTitan(boolean enableTitan) {
    this.enableTitan = enableTitan;
  }

  @Override
  public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
    PlatformContext.applicationContext = applicationContext;
  }

  public static ApplicationContext getApplicationContext() {
    return applicationContext;
  }
}