package com.bizunited.platform.core.common.enums;

import org.apache.commons.lang3.StringUtils;

/**
 * 数据库枚举
 * @Author: Paul Chan
 * @Date: 2019-10-10 17:29
 */
public enum DataSourceTypeEnum {

  MYSQL("mysql", "com.mysql.jdbc.Driver", "com.mysql.cj.jdbc.Driver"),
  ORACLE("oracle", "oracle.jdbc.driver.OracleDriver");

  private String database;

  private String[] driverClassNames;

  DataSourceTypeEnum(String database, String... driverClassNames) {
    this.database = database;
    this.driverClassNames = driverClassNames;
  }

  /**
   * 根据驱动类名称获取数据库枚举
   * @param driverClassName
   * @return
   */
  public static DataSourceTypeEnum valueOfDriver(String driverClassName) {
    if(StringUtils.isBlank(driverClassName)) {
      return null;
    }
    for (DataSourceTypeEnum value : values()) {
      for (String className : value.driverClassNames) {
        if(className.equals(driverClassName)) {
          return value;
        }
      }
    }
    return null;
  }

  public String getDatabase() {
    return database;
  }

  public String[] getDriverClassNames() {
    return driverClassNames;
  }
}
