package com.bizunited.platform.core.configuration;

import com.bizunited.platform.core.service.invoke.InvokeProxy;
import com.bizunited.platform.core.service.script.ScriptExecuteHandle;
import com.bizunited.platform.core.service.script.ScriptResultResponseHandle;
import com.bizunited.platform.core.service.script.JavaServiceInputHandle;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
public class ScriptInvokeConfig {

  @Autowired
  private ApplicationContext applicationContext;
  @Autowired
  private JavaServiceInputHandle javaServiceInputHandle;
  @Autowired
  private ScriptExecuteHandle scriptExecuteHandle;
  @Autowired
  private ScriptResultResponseHandle scriptResultResponseHandle;

  @Bean("GroovyProxy")
  @Scope("prototype")
  public InvokeProxy getGroovyProxy(){
    InvokeProxy.Build build = new InvokeProxy.Build();
    build.addClassLoader(applicationContext.getClassLoader());
    build.addInvokeRequestFilter(javaServiceInputHandle, scriptExecuteHandle);
    build.addInvokeResponseFilter(scriptResultResponseHandle);
    InvokeProxy servicableProxy = build.build();
    return servicableProxy;
  }
}