package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DictItemEntity;
import com.bizunited.platform.core.service.DictItemService;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * DictItemController
 *
 * @description:
 * @author: yanwe
 * @date: 14/Feb/2019 09:52
 */
@RestController
@RequestMapping("/v1/nebula/dictItems")
public class DictItemController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(DictItemController.class);
  @Autowired private DictItemService dictItemService;

  @ApiOperation(value = "根据字典编码查询所有子项")
  @RequestMapping(value = "/findByCode", method = RequestMethod.GET)
  public ResponseModel findByCode(@RequestParam(name = "dictCode") @ApiParam(name = "dictCode", value = "指定的字典编码") String dictCode) {
    try {
      return buildHttpReslutW(dictItemService.findItemsByCode(dictCode), "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }

  @ApiOperation(value = "为字典类 修改/添加/删除 明细项")
  @RequestMapping(value = "/update", method = RequestMethod.POST)
  public ResponseModel update(
      @RequestParam(name = "dictCode") @ApiParam(name = "dictCode", value = "字典编码") String dictCode,
      @ApiParam(name = "字典明细信息") @RequestBody List<DictItemEntity> items) {
    LOGGER.debug("待新增/修改的字典编码：{},字典信息：{}", dictCode, JSON.toJSONString(items));
    try {
      return buildHttpReslutW(dictItemService.updateItems(dictCode, items), "");
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpReslutForException(e);
    }
  }
}
