package com.bizunited.platform.core.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.bizunited.platform.core.service.image.FileViewService;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 这个controller用于接受一个新的文件，支持jpg、gif、png、bmp格式，还可以按照指定的图片特效进行展示
 * @author yinwenjie
 */
@RestController
@RequestMapping("/v1/nebula/images")
public class ImageFileController extends BaseController {

  @Autowired
  private FileViewService imageViewService;
  
  @ApiOperation(value = "该方法可浏览一张指定的图片，当您上传一张图片并成功后，图片服务系统会向您返回一个图片在服务端存储的路径（例如:xxxxx/yyyy.jpg）<br>"
      + "接下来您可以拼凑一个完整的图片访问路径，访问这张图片（无权限要求的情况下），例如:http://localhost:5555/imageServer/v1/images/xxxxx/yyyy.jpg<br>" ,
      notes="请注意http://localhost:5555/imageServer/v1/kuiper/images/相对路径 为图片上传/下载操作的的固定写法，而这样访问只能访问原始图片<br><br>"
          + ""
          + "但实际情况是，往往我们需要访问的是加了水印，或者指定了某个缩放分辨率的图片，所以往往需要在访问图片时做动态处理。目前图片服务支持以下图片特效：<br>"
          + "1、按照固定比例（例如0.3）对图片进行等比例缩放<br>"
          + "2、指定一个固定分辨率（例如300*300）对图片进行等比例缩放<br>"
          + "3、从图片中心位置，按照一个比例或者像素范围，截取图片的一个区块<br>"
          + "4、在图片左上方，为图片增加多行文本（黄色字体）<br><br><br>"
          + "图片服务还支持以上多种特效功能复合使用，例如：<br><br>"
          + "zoomimage|width=300|height=300->markimage|markValue=wwwyinwenjienet.222：首先按照指定的分辨率缩放图片，然后在图片的左上方增加文字“wwwyinwenjienet.222”<br><br>"
          + "zoomimage|ratio=0.1->markimage|fontSize=24|markValue=www.yinwenjie.net#这是第二行中文：首先按照指定的比例缩放图片，然后增加两行水印（“www.yinwenjie.net”和“这是第二行中文”）<br>"
          + "(<b>注意，以上两个示例在正式使用时，需要使用http encode进行编码处理！</b>)<br>"
          + "完整的访问示例如下：<br>"
          + "http://localhost:5555/imageServer/v1/kuiper/images/xxxx/0/yyy.jpg?special=zoomimage%7cratio%3d0.3-%3emarkimage%7cmarkValue%3dwww.yinwenjie.net%23%e8%bf%99%e6%98%af%e7%ac%ac%e4%ba%8c%e8%a1%8c%e4%b8%ad%e6%96%87"
          + "<br><br>"
          + "以下列举了目前图片服务支持的特效功能<br>:"
          + "1、按照固定比例（例如0.1）对图片进行等比例缩放<br>"
          + "zoomimage|ratio=0.1<br>"
          + "2、按照固定分辨率（例如100*100）对图片进行等比例缩放（注意，是等比例缩放，不是对图片进行拉伸处理）<br>"
          + "zoomimage|width=300|height=300<br>"
          + "3、从图片中心位置，按照一个比例或者像素范围，截取图片的一个区块：<br>"
          + "cutimage|ratio=0.1或者cutimage|width=200|height=200<br>"
          + "4、在图片左上方，为图片增加多行文本（黄色字体）：<br>"
          + "markimage|markValue=www.yinwenjie.net#这是第二行中文<br>")
  @RequestMapping(path = {"/{subsystem}/{folder}/{randomfolder}/{imageFile}.{prefix}"}, method = RequestMethod.GET)
  public void imageQuery(HttpServletResponse response ,  
                         @PathVariable("subsystem") String subsystem, 
                         @PathVariable("randomfolder") String randomfolder , 
                         @PathVariable("folder") String folder, 
                         @PathVariable("imageFile") String imageFile, 
                         @PathVariable("prefix") String prefix, @ApiParam(name="special" , value="按照规范设定的图片访问特效" , required=false) String special) throws IllegalArgumentException, IOException {
    String relativePath = StringUtils.join("/" , subsystem , "/" , folder , "/" , randomfolder);
    byte[] imageBytes = imageViewService.imageQuery(relativePath , imageFile, prefix, special);
    if (imageBytes == null) {
      return;
    }
    // 显示到页面上
    this.writeResponseFile(response , 1 , imageBytes);
  }
  
  @ApiOperation(value = "该方法可浏览一张指定的图片，当您上传一张图片并成功后，图片服务系统会向您返回一个图片在服务端存储的路径（例如:xxxxx/yyyy.jpg）<br>"
      + "接下来您可以拼凑一个完整的图片访问路径，访问这张图片（无权限要求的情况下），例如:http://localhost:5555/imageServer/v1/images/xxxxx/yyyy.jpg<br>" ,
      notes="请注意http://localhost:5555/imageServer/v1/kuiper/images/相对路径 为图片上传/下载操作的的固定写法，而这样访问只能访问原始图片<br><br>"
          + ""
          + "但实际情况是，往往我们需要访问的是加了水印，或者指定了某个缩放分辨率的图片，所以往往需要在访问图片时做动态处理。目前图片服务支持以下图片特效：<br>"
          + "1、按照固定比例（例如0.3）对图片进行等比例缩放<br>"
          + "2、指定一个固定分辨率（例如300*300）对图片进行等比例缩放<br>"
          + "3、从图片中心位置，按照一个比例或者像素范围，截取图片的一个区块<br>"
          + "4、在图片左上方，为图片增加多行文本（黄色字体）<br><br><br>"
          + "图片服务还支持以上多种特效功能复合使用，例如：<br><br>"
          + "zoomimage|width=300|height=300->markimage|markValue=wwwyinwenjienet.222：首先按照指定的分辨率缩放图片，然后在图片的左上方增加文字“wwwyinwenjienet.222”<br><br>"
          + "zoomimage|ratio=0.1->markimage|fontSize=24|markValue=www.yinwenjie.net#这是第二行中文：首先按照指定的比例缩放图片，然后增加两行水印（“www.yinwenjie.net”和“这是第二行中文”）<br>"
          + "(<b>注意，以上两个示例在正式使用时，需要使用http encode进行编码处理！</b>)<br>"
          + "完整的访问示例如下：<br>"
          + "http://localhost:5555/imageServer/v1/images/xxxx/0/yyy.jpg?special=zoomimage%7cratio%3d0.3-%3emarkimage%7cmarkValue%3dwww.yinwenjie.net%23%e8%bf%99%e6%98%af%e7%ac%ac%e4%ba%8c%e8%a1%8c%e4%b8%ad%e6%96%87"
          + "<br><br>"
          + "以下列举了目前图片服务支持的特效功能<br>:"
          + "1、按照固定比例（例如0.1）对图片进行等比例缩放<br>"
          + "zoomimage|ratio=0.1<br>"
          + "2、按照固定分辨率（例如100*100）对图片进行等比例缩放（注意，是等比例缩放，不是对图片进行拉伸处理）<br>"
          + "zoomimage|width=300|height=300<br>"
          + "3、从图片中心位置，按照一个比例或者像素范围，截取图片的一个区块：<br>"
          + "cutimage|ratio=0.1或者cutimage|width=200|height=200<br>"
          + "4、在图片左上方，为图片增加多行文本（黄色字体）：<br>"
          + "markimage|markValue=www.yinwenjie.net#这是第二行中文<br>")
  @RequestMapping(path = {"/{folder}/{randomfolder}/{imageFile}.{prefix}"}, method = RequestMethod.GET)
  public void imageQuery(HttpServletResponse response , 
                         @PathVariable("folder") String folder,
                         @PathVariable("randomfolder") String randomfolder ,
                         @PathVariable("imageFile") String imageFile, 
                         @PathVariable("prefix") String prefix, 
                         @ApiParam(name="special" , value="按照规范设定的图片访问特效" , required=false) String special) throws IllegalArgumentException, IOException {
    String relativePath = StringUtils.join("/" , folder , "/" , randomfolder);
    byte[] imageBytes = imageViewService.imageQuery(relativePath , imageFile, prefix, special);
    if (imageBytes == null) {
      return;
    }
    // 显示到页面上
    this.writeResponseFile(response , 1 , imageBytes);
  }
  
  /**
   * 根据图片编号下载图片，支持传入图片特效
   */
  @ApiOperation(value="根据图片编号下载图片，支持传入图片特效")
  @RequestMapping(path = {"/download/{subsystem}/{folder}/{randomfolder}/{imageFile}.{prefix}"}, method = RequestMethod.GET)
  public void downloadImage(HttpServletRequest request, HttpServletResponse response ,
                         @PathVariable("subsystem") String subsystem, 
                         @PathVariable("randomfolder") String randomfolder , 
                         @PathVariable("folder") String folder, 
                         @PathVariable("imageFile") String imageFile, 
                         @PathVariable("prefix") String prefix, @ApiParam(name="special" , value="按照规范设定的图片访问特效" , required=false) String special) throws IllegalArgumentException, IOException {
    String relativePath = StringUtils.join("/" , subsystem , "/" , folder , "/" , randomfolder);
    byte[] imageBytes = imageViewService.imageQuery(relativePath , imageFile, prefix, special);
    if (imageBytes == null) {
      return;
    }
    // 图片下载
    this.writeResponseFile(request, response, imageBytes, StringUtils.join(imageFile , "." , prefix));
  }
  
  @ApiOperation(value="根据图片编号下载图片，支持传入图片特效")
  @RequestMapping(path = {"/download/{folder}/{randomfolder}/{imageFile}.{prefix}"}, method = RequestMethod.GET)
  public void downloadImage(HttpServletRequest request, HttpServletResponse response ,
                         @PathVariable("randomfolder") String randomfolder , 
                         @PathVariable("folder") String folder, 
                         @PathVariable("imageFile") String imageFile, 
                         @PathVariable("prefix") String prefix, @ApiParam(name="special" , value="按照规范设定的图片访问特效" , required=false) String special) throws IllegalArgumentException, IOException {
    String relativePath = StringUtils.join("/" , folder , "/" , randomfolder);
    byte[] imageBytes = imageViewService.imageQuery(relativePath , imageFile, prefix, special);
    if (imageBytes == null) {
      return;
    }
    // 图片下载
    this.writeResponseFile(request, response, imageBytes, StringUtils.join(imageFile , "." , prefix));
  }
}