package com.bizunited.platform.core.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.service.migrate.MigrateExportService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value = "MigrateExportController")
@RestController
@RequestMapping("/v1/nebula/migrateExports")
public class MigrateExportController extends BaseController {
  
  private static final Logger LOGGER = LoggerFactory.getLogger(MigrateExportController.class);
  
  @Autowired
  private MigrateExportService migrateExportService;
  
  @ApiOperation(value = "导出指定编号的数据视图、业务编码逻辑、字典逻辑、全局环境变量、远端服务源信息。并以压缩文件（zip文件）下载的形式返回内容")
  @RequestMapping(value = "/export", method = RequestMethod.GET)
  public void export(@ApiParam(name="dataviewIds", value = "指定导出的数据视图ID编号集合，如果不传入任何编号，说明不导出" , required = false) @RequestParam(name="dataviewIds" , required = false) String[] dataviewIds ,
                     @ApiParam(name="codeRuleIds", value = "指定导出的业务编码规则ID集合，如果不传入任何编号，说明不导出" , required = false) @RequestParam(name="codeRuleIds" , required = false) String[] codeRuleIds ,
                     @ApiParam(name="dictIds", value = "指定导出的字典业务编码规则ID集合（不需要传入父级字典分类的编号），如果不传入任何编号，说明不导出" , required = false) @RequestParam(name="dictIds" , required = false) String[] dictIds ,
                     @ApiParam(name="envIds", value = "指定导出的全局环境变量ID集合，如果不传入任何编号，说明不导出" , required = false) @RequestParam(name="envIds" , required = false) String[] envIds ,
                     @ApiParam(name="remoteServiceIds", value = "指定导出的远端服务的ID集合，如果不传入任何编号，说明不导出" , required = false) @RequestParam(name="remoteServiceIds" , required = false) String[] remoteServiceIds ,
                     HttpServletRequest request, HttpServletResponse response) {
    try {
      byte[] result = this.migrateExportService.export(dataviewIds, codeRuleIds, dictIds, envIds, remoteServiceIds);
      if(result == null || result.length == 0) {
        throw new IllegalArgumentException("没有任何下载信息，很大几率原因是导出逻辑出现错误!!");
      }
      
      // 随机生成下载内容的文件名（zip文件）
      String fileName = StringUtils.join(UUID.randomUUID().toString() , ".zip");
      this.writeResponseFile(request, response, result, fileName);
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      this.printErrorMessage(this.buildHttpReslutForException(e), response);
    }
  }
  
  private void printErrorMessage(ResponseModel errorMessage , HttpServletResponse response) {
    response.setContentType("application/json;charset=UTF-8");
    OutputStream out = null;
    try {
      out = response.getOutputStream();
      out.write(JSONObject.toJSONString(errorMessage).getBytes());
    } catch (IOException e) {
      throw new IllegalArgumentException(e.getMessage() , e);
    }
  }
}