package com.bizunited.platform.core.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.ScriptEntity;
import com.bizunited.platform.core.service.ScriptService;
import com.bizunited.platform.core.service.script.model.ScriptInputParamsModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.Validate;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page; 
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.*;

/**
 * ScriptController
 *
 * @description:
 * @author: yanwe
 * @date: 27/May/2019 15:45
 */
@Api(value = "ScriptController", tags = "脚本链调用")
@RestController
@RequestMapping("/v1/nebula/scripts")
public class ScriptController extends BaseController {
  @Autowired 
  private ScriptService scriptService;

  @ApiOperation(value = "后端脚本执行")
  @RequestMapping(value = "/invoke", method = RequestMethod.POST)
  public ResponseModel invoke(@RequestBody ScriptInputParamsModel scriptInputParamsModel) {
    try {
      Validate.notNull(scriptInputParamsModel, "入参不能为空！");
      Validate.notEmpty(scriptInputParamsModel.getScriptIds(), "脚本ID集合不能为空");
      Object result = scriptService.invoke(scriptInputParamsModel);
      return buildHttpReslutW(result);
    } catch (Exception e) {
      return buildHttpReslutForException(e);
    }
  }

  @ApiOperation(value = "分页查询")
  @RequestMapping(value = "/findByConditions", method = RequestMethod.GET)
  public ResponseModel findByConditions(
      @RequestParam(name = "name") String name,
      @RequestParam(name = "language") String language, Pageable pageable) {
    try {
      Page<ScriptEntity> page = scriptService.findByConditions(pageable,name,language);
      return buildHttpReslutW(page);
    } catch (Exception e) {
      return buildHttpReslutForException(e);
    }
  }

  @ApiOperation(value = "根据ID查询脚本内容")
  @RequestMapping(value = "/findContentById", method = RequestMethod.GET)
  public ResponseModel findContentById(
      @RequestParam(name = "scriptId") String scriptId) {
    try {
      String content = scriptService.findContentById(scriptId);
      return buildHttpReslutW(content);
    } catch (Exception e) {
      return buildHttpReslutForException(e);
    }
  }

  @ApiOperation(value = "根据ID查询脚本基础信息")
  @RequestMapping(value = "/findById", method = RequestMethod.GET)
  public ResponseModel findById(
      @RequestParam(name = "scriptId") String scriptId) {
    try {
      ScriptEntity entity = scriptService.findById(scriptId);
      return buildHttpReslutW(entity);
    } catch (Exception e) {
      return buildHttpReslutForException(e);
    }
  }

  @ApiOperation(value = "保存脚本致文件系统")
  @RequestMapping(value = "", method = RequestMethod.POST)
  public ResponseModel create(
      @RequestParam(name = "scriptEntity") String scriptEntityStr,
      @RequestParam(name = "scriptContent") String scriptContent) {
    try {
      ScriptEntity scriptEntity = JSONObject.parseObject(scriptEntityStr, ScriptEntity.class);
      ScriptEntity result = scriptService.create(scriptEntity, scriptContent);
      return buildHttpReslutW(result);
    } catch (Exception e) {
      return buildHttpReslutForException(e);
    }
  }

  @ApiOperation(value = "修改脚本致文件系统")
  @RequestMapping(value = "/update", method = RequestMethod.PATCH)
  public ResponseModel update(
      @RequestParam(name = "scriptEntity") String scriptEntityStr,
      @RequestParam(name = "scriptContent") String scriptContent) {
    try {
      ScriptEntity scriptEntity = JSONObject.parseObject(scriptEntityStr, ScriptEntity.class);
      ScriptEntity result = scriptService.update(scriptEntity, scriptContent);
      return buildHttpReslutW(result);
    } catch (Exception e) {
      return buildHttpReslutForException(e);
    }
  }
}