package com.bizunited.platform.core.controller;

import com.bizunited.platform.core.entity.ServicableMethodEntity;
import com.bizunited.platform.core.service.serviceable.ServicableMethodService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;


@Api(value = "ServicableMethodController",tags="向外界暴露的服务源接口信息")
@RestController
@RequestMapping("/v1/nebula/servicableMethods")
public class ServicableMethodController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(ServicableMethodController.class); 
  @Autowired
  private ServicableMethodService servicableMethodService;
  
  @ApiOperation(value = "按照条件搜索可用服务源列表，支持分页但不支持模糊查询")
  @RequestMapping(value = "/findByConditions", method = RequestMethod.GET)
  public ResponseModel findByConditions(@ApiParam(name = "name", value = "可能的服务源标识名称", required = false) @RequestParam(required=false , name="name") String name,
                                        @ApiParam(name = "description", value = "方法中文描述（支持模糊查询）", required = false) @RequestParam(required=false , name="description") String description,
                                        @ApiParam(name = "interfaceName", value = "可能的服务源完整接口类名查询条件", required = false) @RequestParam(required=false , name="interfaceName") String interfaceName, 
                                        @ApiParam(name = "simpleMethodName", value = "可能的服务源方法名简称查询条件", required = false) @RequestParam(required=false , name="simpleMethodName") String simpleMethodName, 
                                        @ApiParam(name = "returnClassName", value = "可能的返回classname（全名）作为查询条件", required = false) @RequestParam(required=false , name="returnClassName") String returnClassName , 
                                        @ApiParam(name = "propertyClassName", value = "可能的参数类型classname（全名）作为查询条件", required = false) @RequestParam(required=false , name="propertyClassName") String propertyClassName ,
                                        @ApiParam(name = "usedScope", value = "服务源方法的应用范围：目前支持：读操作(READ)，写操作(WRITE)", required = true) @RequestParam(required=true , value="usedScope") String usedScope,
                                        @PageableDefault(value = 50) Pageable pageable) {
    try {
      Page<ServicableMethodEntity> page = this.servicableMethodService.findByConditions(pageable, name , description , interfaceName, simpleMethodName , returnClassName , propertyClassName ,usedScope);
      return this.buildHttpReslutW(page, new String[] {"properties"});
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpReslutForException(e);
    }
  }
}