package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthVerticalEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * DataViewAuthVerticalEntity 数据视图纵向权限
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/dataViewVerticals")
public class DataViewAuthVerticalController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthVerticalController.class);
  
  @Autowired
  private DataViewAuthVerticalService dataViewAuthVerticalService;

  /**
   * 创建数据视图纵向权限
   * */
  @ApiOperation(value = "创建数据视图纵向权限")
  @PostMapping(value="")
  public ResponseModel create(@RequestBody @ApiParam(name="authVerticals" , value="创建数据视图纵向权限") Set<DataViewAuthVerticalEntity> authVerticals) {
    try {
      Set<DataViewAuthVerticalEntity> current = this.dataViewAuthVerticalService.create(authVerticals);
      return this.buildHttpReslutW(current, new String[]{});
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpReslutForException(e);
    }
  }

  /**
   * 更新数据视图纵向权限
   * */
  @ApiOperation(value = "更新数据视图纵向权限")
  @PatchMapping(value="")
  public ResponseModel update(@RequestBody @ApiParam(name="authVerticals" , value="更新数据视图纵向权限") Set<DataViewAuthVerticalEntity> authVerticals,
                              @RequestParam("dataViewId") @ApiParam(name="dataViewId" , value="数据视图ID") String dataViewId) {
    try {
      Set<DataViewAuthVerticalEntity> current = this.dataViewAuthVerticalService.update(authVerticals,dataViewId);
      return this.buildHttpReslutW(current, new String[]{});
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpReslutForException(e);
    }
  }


  /**
   * 按照关联的 对应的视图进行查询
   * @param dataView 关联的 对应的视图
   */
  @ApiOperation(value = "按照关联的 对应的视图进行查询")
  @RequestMapping(value="/findDetailsByDataView" , method={RequestMethod.GET})
  public ResponseModel findDetailsByDataView(@RequestParam("dataView") @ApiParam("关联的 对应的视图") String dataView) {
    try { 
      Set<DataViewAuthVerticalEntity> result = this.dataViewAuthVerticalService.findDetailsByDataViewCode(dataView);
      return this.buildHttpReslutW(result, new String[]{"authRelations","authRelations.authVertical","displayFields","dataView","field"});
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpReslutForException(e);
    } 
  }  
  /**
   * 按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      DataViewAuthVerticalEntity result = this.dataViewAuthVerticalService.findDetailsById(id);
      return this.buildHttpReslutW(result, new String[]{"authRelations","authRelations.authVertical","displayFields","dataView","field"});
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpReslutForException(e);
    } 
  }  
} 
