package com.bizunited.platform.core.controller.dataview;

import com.bizunited.platform.core.controller.BaseController;
import com.bizunited.platform.core.controller.model.ResponseModel;
import com.bizunited.platform.core.entity.DataViewAuthVerticalRelationEntity;
import com.bizunited.platform.core.service.dataview.DataViewAuthVerticalRelationService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * 纵向权限选定的权限关系集
 * @author saturn
 */
@RestController
@RequestMapping("/v1/nebula/dataViewAuthVerticalRelations")
public class DataViewAuthVerticalRelationController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DataViewAuthVerticalRelationController.class);
  
  @Autowired
  private DataViewAuthVerticalRelationService dataViewAuthVerticalRelationService;

  /**
   * 按照关联的 纵向数据权限进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param authVertical 关联的 纵向数据权限
   */
  @ApiOperation(value = "按照关联的 纵向数据权限进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsByAuthVertical" , method={RequestMethod.GET})
  public ResponseModel findDetailsByAuthVertical(@RequestParam("authVertical") @ApiParam("关联的 纵向数据权限") String authVertical) {
    try { 
      Set<DataViewAuthVerticalRelationEntity> result = this.dataViewAuthVerticalRelationService.findDetailsByAuthVertical(authVertical);
      return this.buildHttpReslutW(result, new String[]{"authVertical"}); 
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpReslutForException(e);
    } 
  }  
  /**
   * 按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * @param id 主键
   */
  @ApiOperation(value = "按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。")
  @RequestMapping(value="/findDetailsById" , method={RequestMethod.GET})
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try { 
      DataViewAuthVerticalRelationEntity result = this.dataViewAuthVerticalRelationService.findDetailsById(id);
      return this.buildHttpReslutW(result, new String[]{"authVertical"}); 
    } catch(Exception e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpReslutForException(e);
    } 
  }  
} 
