package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import org.hibernate.annotations.OrderBy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

/**
 * 数据视图基本信息
 * @author hc
 */
@Entity
@Table(name="engine_dataview")
@org.hibernate.annotations.Table(appliesTo = "engine_dataview" , comment = "数据视图基本信息")
public class DataViewEntity extends UuidEntity {
  private static final long serialVersionUID = -5591794440769954676L;
  /**
   * 可能的所属数据源
   */
  @ManyToOne(fetch=FetchType.LAZY , targetEntity=DataSourceEntity.class)
  @JoinColumn(name="data_source" , nullable=true , columnDefinition = "varchar(255) COMMENT '数据源信息'")
  @SaturnColumn(description="数据源信息")
  private DataSourceEntity dataSource;
  /**
   * 所属的数据库分组
   */
  @ManyToOne(fetch=FetchType.LAZY , targetEntity=DataViewGroupEntity.class)
  @JoinColumn(name="data_source_group" , nullable=false, columnDefinition = "varchar(255) COMMENT '数据库分组'")
  @SaturnColumn(description="数据库分组")
  private DataViewGroupEntity dataViewGroup;
  /**
   * 数据视图编号
   */
  @Column(name="code" , length=64 , nullable=false , unique = true, columnDefinition = "varchar(64) COMMENT '数据视图编号'")
  @SaturnColumn(description="数据视图编号")
  private String code;
  /**
   * 数据视图中文名
   */
  @Column(name="name" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '视图中文名'")
  @SaturnColumn(description="视图中文名")
  private String name;
  /**
   * 原始SQL
   */
  @Column(name="source_sql" , length=4096 , nullable=false, columnDefinition = "varchar(4096) COMMENT '原始SQL'")
  @SaturnColumn(description="原始SQL")
  private String sourceSql = "";
  /**
   * 视图状态
   * 1:正常；0作废
   */
  @Column(name="t_status" , nullable=false, columnDefinition = "int(11) COMMENT '视图状态'")
  @SaturnColumn(description="视图状态")
  private Integer tstatus = 1;
  /**
   * 视图结构的输出字段信息
   */
  @OneToMany(fetch=FetchType.LAZY , mappedBy="dataView")
  @SaturnColumn(description="结构字段")
  @OrderBy(clause = "sortIndex")
  private Set<DataViewFieldEntity> fields;
  /**
   * 视图结构的用户条件过滤信息
   */
  @OneToMany(fetch=FetchType.LAZY , mappedBy="dataView")
  @SaturnColumn(description="过滤筛选字段")
  private Set<DataViewFilterEntity> filters;
  /**
   * 视图结构的系统查询字段信息
   */
  @OneToMany(fetch=FetchType.LAZY , mappedBy="dataView")
  @SaturnColumn(description="系统查询字段")
  private Set<DataViewSystemEntity> systemFilters;

  public DataSourceEntity getDataSource() {
    return dataSource;
  }
  public void setDataSource(DataSourceEntity dataSource) {
    this.dataSource = dataSource;
  }
  public DataViewGroupEntity getDataViewGroup() {
    return dataViewGroup;
  }
  public void setDataViewGroup(DataViewGroupEntity dataViewGroup) {
    this.dataViewGroup = dataViewGroup;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }
  public String getSourceSql() {
    return sourceSql;
  }
  public void setSourceSql(String sourceSql) {
    this.sourceSql = sourceSql;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }
  public Set<DataViewFieldEntity> getFields() {
    return fields;
  }
  public void setFields(Set<DataViewFieldEntity> fields) {
    this.fields = fields;
  }
  public Set<DataViewFilterEntity> getFilters() {
    return filters;
  }
  public void setFilters(Set<DataViewFilterEntity> filters) {
    this.filters = filters;
  }
  public Set<DataViewSystemEntity> getSystemFilters() {
    return systemFilters;
  }
  public void setSystemFilters(Set<DataViewSystemEntity> systemFilters) {
    this.systemFilters = systemFilters;
  }
}
