package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 数据视图分组
 * @author yinwenjie
 */
@Entity
@Table(name="engine_dataview_group" , indexes={@Index(columnList="data_source,target_table" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_group" , comment = "数据视图分组")
public class DataViewGroupEntity extends UuidEntity {
  private static final long serialVersionUID = -3134805192098226179L;


  /**
   * 数据视图分组新增编码
   */
  @Column(name="code" , length=255 , nullable=false , unique=true)
  @SaturnColumn(description="code")
  private String code;

  /**
   * 分组名(中文名)
   */
  @Column(name="group_name" , length=64 , nullable=false , unique=false , columnDefinition = "varchar(64) COMMENT '分组名(中文名)'")
  @SaturnColumn(description="分组名(中文名)")
  private String groupName;
  /**
   * 基准数据表
   */
  @Column(name="target_table" , length=64 , nullable=false , columnDefinition = "varchar(64) COMMENT '基准数据表'")
  @SaturnColumn(description="基准数据表")
  private String targetTable = "";
  /**
   * 可能的所属数据源编号
   */
  @ManyToOne(fetch=FetchType.LAZY , targetEntity=DataSourceEntity.class)
  @JoinColumn(name="data_source" , nullable=true , columnDefinition = "varchar(255) COMMENT '数据源编号'")
  @SaturnColumn(description="数据源编号")
  private DataSourceEntity dataSource;
  public String getGroupName() {
    return groupName;
  }
  public void setGroupName(String groupName) {
    this.groupName = groupName;
  }
  public String getTargetTable() {
    return targetTable;
  }
  public void setTargetTable(String targetTable) {
    this.targetTable = targetTable;
  }
  public DataSourceEntity getDataSource() {
    return dataSource;
  }
  public void setDataSource(DataSourceEntity dataSource) {
    this.dataSource = dataSource;
  }

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }
}
