package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 数据视图系统参数设定部分的信息
 * @author yinwenjie
 */
@Entity
@Table(name="engine_dataview_system" , indexes={@Index(columnList="data_view,param_name" , unique=true)})
@org.hibernate.annotations.Table(appliesTo = "engine_dataview_system" , comment = "数据视图系统参数设定部分的信息")
public class DataViewSystemEntity extends UuidEntity {
  private static final long serialVersionUID = -7429253225741078856L;
  /**
   * 对应的视图
   */
  @ManyToOne(fetch=FetchType.LAZY)
  @JoinColumn(name="data_view" , nullable=false, columnDefinition = "varchar(255) COMMENT '对应的视图'")
  @SaturnColumn(description="对应的视图")
  private DataViewEntity dataView;
  /**
   * 参数名（英文），参数名由分析SQL语句时提取。
   */
  @Column(name="param_name" , length=64 , nullable=false, columnDefinition = "varchar(64) COMMENT '参数名（英文），参数名由分析SQL语句时提取。'")
  @SaturnColumn(description="参数名")
  private String paramName;
  /**
   * 参数来源类型：<br>
   * 1、外部传入
   * 2、固定值
   * 3、预制值
   */
  @Column(name="param_source_type" , nullable=false, columnDefinition = "int(11) COMMENT '参数来源类型：1、外部传入 2、固定值 3、预制值'")
  @SaturnColumn(description="参数来源类型")
  private Integer paramSourceType = 1;
  /**
   * 参数类型：<br>
   * 支持：ava.lang.String，java.util.Date，java八大基础类型
   */
  @Column(name="param_type" , nullable=false, columnDefinition = "varchar(255) COMMENT '参数类型 支持：ava.lang.String，java.util.Date，java八大基础类型'")
  @SaturnColumn(description="参数类型")
  private String paramType;
  /**
   * 如果参数来源类型为3（预制值）时，这里记录预制值的标识key
   */
  @Column(name="param_key" , length=64, nullable=true , columnDefinition = "varchar(64) COMMENT '如果参数来源类型为3（预制值）时，这里记录预制值的标识key'")
  @SaturnColumn(description="预制值标识")
  private String paramKey = "";
  /**
   * 如果当前参数来源类型为2（固定值）时，这里负责记录具体的固定值
   */
  @Column(name="param_value" , nullable=true , columnDefinition = "varchar(255) COMMENT '如果当前参数来源类型为2（固定值）时，这里负责记录具体的固定值'")
  @SaturnColumn(description="参数值")
  private String paramValue;
  public DataViewEntity getDataView() {
    return dataView;
  }
  public void setDataView(DataViewEntity dataView) {
    this.dataView = dataView;
  }
  public String getParamName() {
    return paramName;
  }
  public void setParamName(String paramName) {
    this.paramName = paramName;
  }
  public String getParamKey() {
    return paramKey;
  }
  public void setParamKey(String paramKey) {
    this.paramKey = paramKey;
  }
  public String getParamValue() {
    return paramValue;
  }
  public void setParamValue(String paramValue) {
    this.paramValue = paramValue;
  }
  public Integer getParamSourceType() {
    return paramSourceType;
  }
  public void setParamSourceType(Integer paramSourceType) {
    this.paramSourceType = paramSourceType;
  }
  public String getParamType() {
    return paramType;
  }
  public void setParamType(String paramType) {
    this.paramType = paramType;
  }
}