package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.*;

/**
 * DictItemEntity
 * @description:
 * @author: yanwe
 * @date: 13/Feb/2019 10:20
 */
@ApiModel(value = "DictItemEntity", description = "字典明细项")
@Entity
@Table(
    name = "engine_dict_item",
    indexes = {
      @Index(columnList = "dict_entity_id,dict_value", unique = true),
      @Index(columnList = "dict_entity_id,dict_key", unique = true)
    })
@org.hibernate.annotations.Table(appliesTo = "engine_dict_item" , comment = "字典明细项")
public class DictItemEntity extends UuidEntity {

  /**
   * 
   */
  private static final long serialVersionUID = -4010037372438544827L;

  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "dict_entity_id", columnDefinition = "varchar(255) COMMENT '对应字典'")
  @SaturnColumn(description = "对应字典")
  private DictEntity dictEntity;

  /** 字典的值. * */
  @Column(name = "dict_value", nullable = false, columnDefinition = "varchar(255) COMMENT '字典值'")
  @ApiModelProperty(name = "dictValue", value = "字典值", required = true)
  @SaturnColumn(description = "字典值")
  private String dictValue;

  /** 字典的名称. * */
  @Column(name = "dict_key", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '字典的名称'")
  @ApiModelProperty(name = "dictKey", value = "字典名称", required = true)
  @SaturnColumn(description = "字典名称")
  private String dictKey;

  /** 字典的排序 * */
  @Column(name = "dict_sort", columnDefinition = "int(11) COMMENT '字典的排序'")
  @ApiModelProperty(name = "dictSort", value = "字典排序")
  @SaturnColumn(description = "字典排序")
  private Integer dictSort;

  /** 字典明细的启用状态 */
  @Column(name = "dict_item_status", columnDefinition = "bit(1) COMMENT '字典明细的启用状态'")
  @ApiModelProperty(name = "dictItemStatus", value = "字典明细的启用状态,")
  @SaturnColumn(description = "字典明细的启用状态")
  private Boolean dictItemStatus;

  public DictEntity getDictEntity() {
    return dictEntity;
  }

  public void setDictEntity(DictEntity dictEntity) {
    this.dictEntity = dictEntity;
  }

  public String getDictValue() {
    return dictValue;
  }

  public void setDictValue(String dictValue) {
    this.dictValue = dictValue;
  }

  public String getDictKey() {
    return dictKey;
  }

  public void setDictKey(String dictKey) {
    this.dictKey = dictKey;
  }

  public Integer getDictSort() {
    return dictSort;
  }

  public void setDictSort(Integer dictSort) {
    this.dictSort = dictSort;
  }

  public Boolean getDictItemStatus() {
    return dictItemStatus;
  }

  public void setDictItemStatus(Boolean dictItemStatus) {
    this.dictItemStatus = dictItemStatus;
  }
}
