package com.bizunited.platform.core.entity;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;

@ApiModel(value = "DynamicTaskSchedulerEntity", description = "技术中台，周期性或一次性动态任务")
@Entity
@Table(name = "engine_dynamic_task")
@org.hibernate.annotations.Table(appliesTo = "engine_dynamic_task" , comment = "技术中台，周期性或一次性动态任务")
public class DynamicTaskSchedulerEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = 9187377641504269587L;
  /**
   * 任务唯一编号（只能由英文、数字、下杠构成）
   */
  @Column(name="task_code" , length = 128 , nullable = false , unique = true, columnDefinition = "varchar(128) COMMENT '任务唯一编号（只能由英文、数字、下杠构成）'")
  @SaturnColumn(description = "任务唯一编号（只能由英文、数字、下杠构成）")
  private String taskCode;
  /**
   * 任务中文说明
   */
  @Column(name="task_desc" , nullable = false, columnDefinition = "varchar(255) COMMENT '任务中文说明'")
  @SaturnColumn(description = "任务中文说明")
  private String taskDesc;
  /**
   * 任务类型：1、一次性执行；2：周期性执行
   */
  @Column(name="task_type" , nullable = false, columnDefinition = "int(11) COMMENT '任务类型：1、一次性执行；2：周期性执行'")
  @SaturnColumn(description = "任务类型")
  private Integer taskType = 2;
  /**
   * 一次性任务的执行时间点
   */
  @Column(name="execute_point" , nullable = true, columnDefinition = "datetime COMMENT '一次性任务的执行时间点'")
  @SaturnColumn(description = "一次性任务的执行时间点")
  private Date executePoint;
  /**
   * 周期性任务执行表单式，满足corn表达式
   */
  @Column(name="execute_expression" , length = 32 , nullable = true, columnDefinition = "varchar(32) COMMENT '周期性任务执行表单式，满足corn表达式'")
  @SaturnColumn(description = "周期性任务执行表单式")
  private String executeExpression;
  /**
   * 周期性表单时的中文解析
   */
  @Column(name="expression_desc" , nullable = true, columnDefinition = "varchar(255) COMMENT '周期性表单时的中文解析'")
  @SaturnColumn(description = "周期性表单时的中文")
  private String expressionDesc;
  /**
   * 任务状态：0：无效任务；1、有效任务
   */
  @Column(name="t_status" , nullable = false, columnDefinition = "int(11) COMMENT '任务状态：0：无效任务；1、有效任务'")
  @SaturnColumn(description = "任务状态")
  private Integer tstatus = 0;
  /**
   * 工作状态：0：要求运行， 1：人工停止，2：已运行
   */
  @Column(name="working_status" , nullable = false, columnDefinition = "int(11) COMMENT '工作状态：0：要求运行， 1：人工停止，2：已运行'")
  @SaturnColumn(description = "工作状态：0：要求运行， 1：人工停止，2：已运行")
  private Integer workingStatus = 0;
  /**
   * 执行时所使用的执行脚本
   */
  @ManyToOne(fetch = FetchType.LAZY , targetEntity = ScriptEntity.class)
  @JoinColumn(name = "e_script" , nullable = false, columnDefinition = "varchar(255) COMMENT '执行时所使用的执行脚本'")
  @SaturnColumn(description = "执行脚本")
  private ScriptEntity script;
  /**
   * 创建者
   */
  @ManyToOne(fetch = FetchType.LAZY , targetEntity = UserEntity.class)
  @JoinColumn(name = "creator" , nullable = false, columnDefinition = "varchar(255) COMMENT '对应字典'")
  @SaturnColumn(description = "创建者")
  private UserEntity creator;
  /**
   * 创建时间
   */
  @Column(name = "create_time" , nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;
  /**
   * 创建者
   */
  @ManyToOne(fetch = FetchType.LAZY , targetEntity = UserEntity.class)
  @JoinColumn(name = "modifier" , nullable = false, columnDefinition = "varchar(255) COMMENT '创建者'")
  @SaturnColumn(description = "创建者")
  private UserEntity modifier;
  /**
   * 最后修改时间
   */
  @Column(name = "last_modify_time" , nullable = false, columnDefinition = "datetime COMMENT '最后修改时间'")
  @SaturnColumn(description = "最后修改时间")
  private Date lastModifyTime;
  /**
   * 任务有效期
   */
  @Column(name = "validity_time" , nullable = true, columnDefinition = "datetime COMMENT '任务有效期'")
  @SaturnColumn(description = "任务有效期")
  private Date validityTime;
  
  public String getTaskCode() {
    return taskCode;
  }
  public void setTaskCode(String taskCode) {
    this.taskCode = taskCode;
  }
  public String getTaskDesc() {
    return taskDesc;
  }
  public void setTaskDesc(String taskDesc) {
    this.taskDesc = taskDesc;
  }
  public Integer getTaskType() {
    return taskType;
  }
  public void setTaskType(Integer taskType) {
    this.taskType = taskType;
  }
  public Date getExecutePoint() {
    return executePoint;
  }
  public void setExecutePoint(Date executePoint) {
    this.executePoint = executePoint;
  }
  public String getExecuteExpression() {
    return executeExpression;
  }
  public void setExecuteExpression(String executeExpression) {
    this.executeExpression = executeExpression;
  }
  public String getExpressionDesc() {
    return expressionDesc;
  }
  public void setExpressionDesc(String expressionDesc) {
    this.expressionDesc = expressionDesc;
  }
  public Integer getTstatus() {
    return tstatus;
  }
  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  } 
  public ScriptEntity getScript() {
    return script;
  } 
  public void setScript(ScriptEntity script) {
    this.script = script;
  } 
  public UserEntity getCreator() {
    return creator;
  } 
  public void setCreator(UserEntity creator) {
    this.creator = creator;
  } 
  public Date getCreateTime() {
    return createTime;
  } 
  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
  public Integer getWorkingStatus() {
    return workingStatus;
  }
  public void setWorkingStatus(Integer workingStatus) {
    this.workingStatus = workingStatus;
  }
  public UserEntity getModifier() {
    return modifier;
  }
  public void setModifier(UserEntity modifier) {
    this.modifier = modifier;
  }
  public Date getLastModifyTime() {
    return lastModifyTime;
  }
  public void setLastModifyTime(Date lastModifyTime) {
    this.lastModifyTime = lastModifyTime;
  }
  public Date getValidityTime() {
    return validityTime;
  }
  public void setValidityTime(Date validityTime) {
    this.validityTime = validityTime;
  } 
}