package com.bizunited.platform.core.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

/**
 * 普通文件附件、图片附件的记录信息
 * @author yinwenjie 
 */
@ApiModel(value = "OrdinaryFileEntity" , description=" 普通文件附件、图片附件的记录信息")
@Entity
@Table(name = "engine_file" , indexes={@Index(columnList="original_name , relative_local") , @Index(columnList="effective_date")})
@org.hibernate.annotations.Table(appliesTo = "engine_file" , comment = "普通文件附件、图片附件的记录信息")
public class OrdinaryFileEntity extends UuidEntity {
  /**
   *
   */
  private static final long serialVersionUID = -5037551559571438647L;
  /**
   * 文件的上传者
   */
  @ApiModelProperty(name="commitUser" , value="文件的上传者" , required=false)
  @Column(name = "commit_user", length = 64, nullable = true, columnDefinition = "varchar(64) COMMENT '文件的上传者'")
  @SaturnColumn(description="文件的上传者")
  private String commitUser;
  /**
   * 重命名后的文件名字
   */
  @ApiModelProperty(name="fileName" , value="重命名后的文件名字" , required=false)
  @Column(name = "file_name", nullable = true , unique = true, columnDefinition = "varchar(255) COMMENT '重命名后的文件名字'")
  @SaturnColumn(description="重命名后的文件名字")
  private String fileName;
  /**
   * 重命名前的文件名字
   */
  @ApiModelProperty(name="originalFileName" , value="重命名前的文件名字" , required=false)
  @Column(name = "original_name", nullable = true, columnDefinition = "varchar(255) COMMENT '重命名前的文件名字'")
  @SaturnColumn(description="重命名前的文件名字")
  private String originalFileName;
  /**
   * 文件在本地的存储目录（相对位置，不包括）<br>
   */
  @ApiModelProperty(name="relativeLocal" , value="文件在本地的存储目录（相对位置，不包括）" , required=false)
  @Column(name = "relative_local", nullable = true , columnDefinition = "varchar(255) COMMENT '文件在本地的存储目录（相对位置，不包括）'")
  @SaturnColumn(description="文件在本地的存储目录")
  private String relativeLocal;
  /**
   * 文件的扩展类型，例如：png、gif、jpg等
   */
  @ApiModelProperty(name="prefix" , value="文件的扩展类型，例如：png、gif、jpg等" , required=false)
  @Column(name = "prefix", nullable = true, length = 32 , columnDefinition = "varchar(32) COMMENT '文件的扩展类型，例如：png、gif、jpg等'")
  @SaturnColumn(description="文件的扩展类型")
  private String prefix;
  /**
   * 文件有效期截止，默认为3999-01-01 00:00:00
   */
  @ApiModelProperty(name="effectiveDate" , value="文件有效期截止" , required=false)
  @Column(name = "effective_date", nullable = true, columnDefinition = "datetime COMMENT '文件有效期截止，默认为3999-01-01 00:00:00'")
  @SaturnColumn(description="文件有效期截止")
  private Date effectiveDate;
  /**
   * 创建时间
   */
  @ApiModelProperty(name="createDate" , value="创建时间" , required=true)
  @Column(name = "create_date", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description="创建时间")
  private Date createDate = new Date();
  public String getCommitUser() {
    return commitUser;
  }
  public void setCommitUser(String commitUser) {
    this.commitUser = commitUser;
  }
  public String getFileName() {
    return fileName;
  }
  public void setFileName(String fileName) {
    this.fileName = fileName;
  }
  public String getOriginalFileName() {
    return originalFileName;
  }
  public void setOriginalFileName(String originalFileName) {
    this.originalFileName = originalFileName;
  }
  public String getPrefix() {
    return prefix;
  }
  public void setPrefix(String prefix) {
    this.prefix = prefix;
  }
  public Date getCreateDate() {
    return createDate;
  }
  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }
  public String getRelativeLocal() {
    return relativeLocal;
  }
  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }
  public Date getEffectiveDate() {
    return effectiveDate;
  }
  public void setEffectiveDate(Date effectiveDate) {
    this.effectiveDate = effectiveDate;
  }
}
