package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * 描述业务系统中的组织机构信息
 * @author yinwenjie
 */
@ApiModel(value = "OrganizationEntity", description = "组织机构")
@Entity
@Table(name = "engine_org")
@org.hibernate.annotations.Table(appliesTo = "engine_org" , comment = "描述业务系统中的组织机构信息")
public class OrganizationEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -7899327347113427246L;

  @ApiModelProperty(name="code" , value="组织机构唯一编号", required=true)
  @Column(name="org_code" , length=128 , nullable=false , unique = true , columnDefinition = "varchar(128) COMMENT '组织机构唯一编号'")
  @SaturnColumn(description="组织机构的唯一编号")
  private String code;

  @ApiModelProperty(name = "org_name", value = "组织机构名称", required = true)
  @Column(name = "org_name", length = 64, nullable = false , columnDefinition = "varchar(64) COMMENT '组织机构名称'")
  @SaturnColumn(description = "组织机构名称")
  private String orgName;

  @ApiModelProperty(name = "type", value = "组织机构类型(0:部门,1:单位)", required = true)
  @Column(name = "org_type", nullable = false, columnDefinition = "int(11) COMMENT '组织机构类型(0:部门,1:单位)'")
  @SaturnColumn(description = "组织机构类型")
  private Integer type;

  @ApiModelProperty(name = "description", value = "组织机构描述", required = true)
  @Column(name = "org_desc", nullable = false, length = 512, columnDefinition = "varchar(512) COMMENT '组织机构描述'")
  @SaturnColumn(description = "组织机构描述")
  private String description = "";

  @ApiModelProperty(name = "sortIndex", value = "排序", required = true)
  @Column(name = "org_sort_index", nullable = false, columnDefinition = "int(11) COMMENT '组织机构排序'")
  @SaturnColumn(description = "组织机构排序")
  private Integer sortIndex = 100;

  @ApiModelProperty(name = "createTime", value = "创建时间", required = false)
  @Column(name = "createTime", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime = new Date();
 
  @ApiModelProperty(name = "users", value = "组织机构绑定的用户信息", hidden = true, required = true)
  @ManyToMany(fetch = FetchType.LAZY)
  @JoinTable(name = "engine_org_user_mapping", joinColumns = {@JoinColumn(name = "org_id")}, inverseJoinColumns = {@JoinColumn(name = "user_id")})
  @SaturnColumn(description = "组织机构绑定的用户信息")
  private Set<UserEntity> users;
  
  @ApiModelProperty(name = "tstatus", value = "组织机构状态（1正常；0不正常）", required = false)
  @Column(name = "tstatus", nullable = false, columnDefinition = "int(11) COMMENT '组织机构状态'")
  @SaturnColumn(description = "组织机构状态")
  private Integer tstatus;

  @ManyToOne(fetch = FetchType.LAZY, targetEntity = OrganizationEntity.class)
  @JoinColumn(name = "parent_id",nullable = true, columnDefinition = "varchar(255) COMMENT '父级组织'")
  @SaturnColumn(description="父级组织")
  private OrganizationEntity parent;

  @OneToMany(fetch = FetchType.LAZY,  mappedBy="parent")
  @SaturnColumn(description="子级组织")
  private Set<OrganizationEntity> child;
  
  @ManyToMany(fetch = FetchType.LAZY, targetEntity = RoleEntity.class)
  @JoinTable(name = "engine_org_role_mapping", joinColumns = {@JoinColumn(name = "org_id")}, inverseJoinColumns = {@JoinColumn(name = "role_id")})
  @SaturnColumn(description = "角色信息")
  private Set<RoleEntity> roles;

  @OneToMany(fetch = FetchType.LAZY,mappedBy = "organization")
  @SaturnColumn(description = "一对多对应的岗位") 
  private Set<PositionEntity> positions;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getOrgName() {
    return orgName;
  }

  public void setOrgName(String orgName) {
    this.orgName = orgName;
  }

  public Integer getType() {
    return type;
  }

  public void setType(Integer type) {
    this.type = type;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Integer getSortIndex() {
    return sortIndex;
  }

  public void setSortIndex(Integer sortIndex) {
    this.sortIndex = sortIndex;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Set<UserEntity> getUsers() {
    return users;
  }

  public void setUsers(Set<UserEntity> users) {
    this.users = users;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public OrganizationEntity getParent() {
    return parent;
  }

  public void setParent(OrganizationEntity parent) {
    this.parent = parent;
  }

  public Set<OrganizationEntity> getChild() {
    return child;
  }

  public void setChild(Set<OrganizationEntity> child) {
    this.child = child;
  }

  public Set<RoleEntity> getRoles() {
    return roles;
  }

  public void setRoles(Set<RoleEntity> roles) {
    this.roles = roles;
  }

  public Set<PositionEntity> getPositions() {
    return positions;
  }

  public void setPositions(Set<PositionEntity> positions) {
    this.positions = positions;
  }
}
