package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
/**
 * 描述业务系统中的岗位信息
 * @description:
 * @author: yanwe
 * @date: 17/Jan/2019 09:53
 */
@ApiModel(value = "PositionEntity", description = "岗位")
@Entity
@Table(name = "engine_position")
@org.hibernate.annotations.Table(appliesTo = "engine_position" , comment = "描述业务系统中的岗位信息")
public class PositionEntity extends UuidEntity {

  private static final long serialVersionUID = 6180350993871864854L;

  @ApiModelProperty(name = "code", value = "岗位唯一编号", required = true)
  @Column(name = "code", length = 128, nullable = false, unique = true, columnDefinition = "varchar(128) COMMENT '组织机构唯一编号'")
  @SaturnColumn(description = "岗位的唯一编号")
  private String code;

  @ApiModelProperty(name = "name", value = "岗位名称", required = true)
  @Column(name = "name", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '组织机构唯一编号'")
  @SaturnColumn(description = "岗位名称")
  private String name;

  @ManyToOne(fetch = FetchType.LAZY, targetEntity = OrganizationEntity.class)
  @JoinColumn(name = "organization_id", nullable = true, columnDefinition = "varchar(255) COMMENT '组织机构唯一编号'")
  @SaturnColumn(description = "所属组织id")
  private OrganizationEntity organization;

  @ApiModelProperty(name = "users", value = "这个岗位已经绑定的用户信息", hidden = true, required = true)
  @ManyToMany(fetch = FetchType.LAZY)
  @JoinTable(
      name = "engine_position_user_mapping",
      joinColumns = {@JoinColumn(name = "position_id")},
      inverseJoinColumns = {@JoinColumn(name = "user_id")})
  @SaturnColumn(description = "岗位已经绑定的用户信息")
  private Set<UserEntity> users;

  @ApiModelProperty(name = "roles", value = "这个岗位已经绑定的角色信息", hidden = true, required = true)
  @ManyToMany(fetch = FetchType.LAZY, targetEntity = RoleEntity.class)
  @JoinTable(
      name = "engine_position_role_mapping",
      joinColumns = {@JoinColumn(name = "position_id")},
      inverseJoinColumns = {@JoinColumn(name = "role_id")})
  @SaturnColumn(description = "岗位已经绑定的角色信息")
  private Set<RoleEntity> roles;

  @ApiModelProperty(name = "tstatus", value = "岗位状态（1正常；0不正常）", required = true)
  @Column(name = "tstatus", nullable = false, columnDefinition = "int(11) COMMENT '岗位状态'")
  @SaturnColumn(description = "岗位状态")
  private Integer tstatus;

  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "createTime", nullable = false, columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime = new Date();

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public OrganizationEntity getOrganization() {
    return organization;
  }

  public void setOrganization(OrganizationEntity organization) {
    this.organization = organization;
  }

  public Set<UserEntity> getUsers() {
    return users;
  }

  public void setUsers(Set<UserEntity> users) {
    this.users = users;
  }

  public Set<RoleEntity> getRoles() {
    return roles;
  }

  public void setRoles(Set<RoleEntity> roles) {
    this.roles = roles;
  }

  public Integer getTstatus() {
    return tstatus;
  }

  public void setTstatus(Integer tstatus) {
    this.tstatus = tstatus;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }
}
