package com.bizunited.platform.core.entity;

import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.util.Date;

/**
 * RemoteServiceAddressEntity 远端调用源地址
 * 
 * @description:
 * @author: yanwe
 * @date: 05/May/2019 14:49
 */
@Entity
@Table(name = "engine_remote_service_address")
@org.hibernate.annotations.Table(appliesTo = "engine_remote_service_address" , comment = "远端调用源地址")
public class RemoteServiceAddressEntity extends UuidEntity {

  private static final long serialVersionUID = -4172452997154023576L;

  @ApiModelProperty(name = "code", value = "远端地址编号", required = true)
  @Column(name = "code", length = 40, nullable = false, unique = true, columnDefinition = "varchar(40) COMMENT '远端地址编号'")
  @SaturnColumn(description = "远端地址编号")
  private String code;

  @ApiModelProperty(name = "alias", value = "远端地址别名", required = true)
  @Column(name = "alias", length = 128, nullable = false, unique = true, columnDefinition = "varchar(128) COMMENT '远端地址别名'")
  @SaturnColumn(description = "远端地址别名")
  private String alias;

  @ApiModelProperty(name = "addressDesc", value = "远端源地址说明")
  @Column(name = "address_desc", columnDefinition = "varchar(255) COMMENT '远端源地址说明'")
  @SaturnColumn(description = "远端源地址说明")
  private String addressDesc;

  @ApiModelProperty(name = "protocolType", value = "协议类型：0:HTTP,1:HTTPS", required = true)
  @Column(name = "protocol_type", nullable = false, columnDefinition = "int(11) COMMENT '协议类型：0:HTTP,1:HTTPS'")
  @SaturnColumn(description = "协议类型：0:HTTP,1:HTTPS")
  private Integer protocolType;

  @ApiModelProperty(name = "connectionType", value = "连接类型，0:custom remote 1:spring eureka", required = true)
  @Column(name = "connection_type", nullable = false, columnDefinition = "int(11) COMMENT '连接类型，0:custom remote 1:spring eureka'")
  @SaturnColumn(description = "连接类型，0:custom remote 1:spring eureka")
  private Integer connectionType;

  @ApiModelProperty(name = "address", value = "连接地址：IP或者域名", required = true)
  @Column(name = "address", length = 128, nullable = false, columnDefinition = "varchar(128) COMMENT '连接地址：IP或者域名'")
  @SaturnColumn(description = "连接地址：IP或者域名")
  private String address;

  @ApiModelProperty(name = "createDate", value = "创建时间")
  @Column(name = "create_date", columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createDate;

  @ApiModelProperty(name = "addressStatus", value = "状态,0: 未启用，1：启用，2：禁用", required = true)
  @Column(name = "address_status", nullable = false, columnDefinition = "int(11) COMMENT '状态,0: 未启用，1：启用，2：禁用'")
  @SaturnColumn(description = "状态,0: 未启用，1：启用，2：禁用")
  private Integer addressStatus;

  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  public String getAlias() {
    return alias;
  }

  public void setAlias(String alias) {
    this.alias = alias;
  }

  public String getAddressDesc() {
    return addressDesc;
  }

  public void setAddressDesc(String addressDesc) {
    this.addressDesc = addressDesc;
  }

  public Integer getProtocolType() {
    return protocolType;
  }

  public void setProtocolType(Integer protocolType) {
    this.protocolType = protocolType;
  }

  public Integer getConnectionType() {
    return connectionType;
  }

  public void setConnectionType(Integer connectionType) {
    this.connectionType = connectionType;
  }

  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public Date getCreateDate() {
    return createDate;
  }

  public void setCreateDate(Date createDate) {
    this.createDate = createDate;
  }

  public Integer getAddressStatus() {
    return addressStatus;
  }

  public void setAddressStatus(Integer addressStatus) {
    this.addressStatus = addressStatus;
  }
}
